/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.checklist.ChecklistPreview;
import pt.lsts.neptus.gui.swing.NeptusFileView;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class ChecklistFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -1779865653037996291L;

    public static File showOpenDialog(File basedir) {
        return ChecklistFileChooser.showOpenDialog(null, I18n.text("Open Checklist"), basedir);
    }

    public static File showOpenDialog(Component parent, File basedir) {
        return ChecklistFileChooser.showOpenDialog(parent, I18n.text("Open Checklist"), basedir);
    }

    public static File showOpenDialog() {
        return ChecklistFileChooser.showOpenDialog(null, I18n.text("Open Checklist"), null);
    }

    public static File showSaveDialog(File basedir) {
        return ChecklistFileChooser.showOpenDialog(null, I18n.text("Save Checklist"), basedir);
    }

    public static File showSaveDialog() {
        return ChecklistFileChooser.showOpenDialog(null, I18n.text("Save Checklist"), null);
    }

    public static File showSaveDialog(Component parent, File basedir) {
        return ChecklistFileChooser.showOpenDialog(parent, I18n.text("Save Checklist"), basedir);
    }

    private static File showOpenDialog(Component parent, String title, File basedir) {
        File fx;
        JFileChooser jfc = new JFileChooser();
        if (basedir != null && basedir.exists()) {
            fx = basedir;
        } else {
            fx = new File(ConfigFetch.getConfigFile());
            if (!(fx = new File(fx.getParentFile(), "checklists")).exists() && !(fx = new File(ConfigFetch.resolvePath("."))).exists()) {
                fx = new File(".");
            }
        }
        jfc.setCurrentDirectory(fx);
        jfc.setAccessory(new ChecklistPreview(jfc));
        jfc.setFileView(new NeptusFileView());
        jfc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = FileUtil.getFileExtension(f);
                if (extension != null) {
                    return "nchk".equalsIgnoreCase(extension) || "xml".equalsIgnoreCase(extension);
                }
                return false;
            }

            @Override
            public String getDescription() {
                return I18n.text("Checklist files") + " ('" + "nchk" + "', '" + "xml" + "')";
            }
        });
        int result = jfc.showDialog(parent == null ? new JFrame() : parent, title);
        if (result == 1) {
            return null;
        }
        return jfc.getSelectedFile();
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        File f = ChecklistFileChooser.showOpenDialog();
        NeptusLog.pub().info((Object)("<###> " + f));
    }
}

