/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Level;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.SystemImcMsgCommInfo;
import pt.lsts.neptus.gui.BlockingGlassPane;
import pt.lsts.neptus.gui.checklist.CheckItemPanel;
import pt.lsts.neptus.gui.checklist.ChecklistFileChooser;
import pt.lsts.neptus.gui.checklist.GeneratorChecklistPDF;
import pt.lsts.neptus.gui.checklist.MyJTaskPaneGroup;
import pt.lsts.neptus.gui.checklist.exec.CheckListExe;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.checklist.CheckItem;
import pt.lsts.neptus.types.checklist.ChecklistType;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.conf.GeneralPreferences;
import pt.lsts.neptus.util.output.OutputMonitor;
import pt.lsts.neptus.util.xsl.TransformFOP;

public class ChecklistPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final String DIRTY_PROPERTY = "user change";
    public static final String SAVEAS_PROPERTY = "file changed";
    public static Icon NEPTUS_ICON = new ImageIcon(ImageUtils.getImage("images/neptus-icon1.png"));
    public static Icon OK_IMAGE_ICON = new ImageIcon(ImageUtils.getScaledImage("images/checklists/selectedIcon.png", 22, 22));
    public static Icon NOT_OK_IMAGE_ICON = new ImageIcon(ImageUtils.getScaledImage("images/checklists/boxIcon.png", 22, 22));
    public static Icon ICON_PDF = new ImageIcon(ImageUtils.getImage("images/checklists/pdf.png"));
    public static Icon ICON_SAVEAS = new ImageIcon(ImageUtils.getImage("images/checklists/filesaveas.png"));
    public static Icon ICON_SAVE = new ImageIcon(ImageUtils.getImage("images/checklists/filesave.png"));
    public static Icon ICON_OPEN = new ImageIcon(ImageUtils.getImage("images/checklists/fileopen.png"));
    public static Icon ICON_NEW = new ImageIcon(ImageUtils.getImage("images/checklists/filenew.png"));
    public static Icon ICON_CANCEL = new ImageIcon(ImageUtils.getImage("images/checklists/cancel.png"));
    public static Icon ICON_RUN = new ImageIcon(ImageUtils.getImage("images/checklists/run.png"));
    public static String FLAT_TITLE;
    public static String NOT_FLAT_TITLE;
    private static final int MAX_NUMBER_OF_SHOWN_CHARS = 20;
    protected static Color BLUE_1;
    protected static Color GREEN_1;
    protected static Color RED_1;
    protected static Color ORANGE_1;
    private JFrame jFrame = null;
    private JInternalFrame jInternalFrame = null;
    private ChecklistType checklist = null;
    private String originalFilePath = "";
    private boolean isEditable = false;
    private boolean isFlat = true;
    private boolean userCancel = false;
    private boolean isChanged = false;
    private MyJTaskPaneGroup templateTaskPaneGroup = null;
    private MyJTaskPaneGroup selectedGroup = null;
    private JPanel headerPanel = null;
    private JPanel hNamePanel = null;
    private JLabel nameLabel = null;
    private JLabel nameText = null;
    private JPanel hVersionPanel = null;
    private JLabel versionLabel = null;
    private JTextField versionText = null;
    private JPanel hDescriptionPanel = null;
    private JLabel descLabel = null;
    private JScrollPane descScrollPane = null;
    private JTextArea descTextArea = null;
    private JPanel toolButtonsPanel = null;
    private JButton generatePDFButton = null;
    private JButton saveAsButton = null;
    private JButton saveButton = null;
    private JButton cancelButton = null;
    private JButton runButton = null;
    private JButton newButton = null;
    private JButton openButton = null;
    private JScrollPane checkTaskPaneScrollPane = null;
    private JXTaskPaneContainer checkTaskPane = null;
    private JPanel editPanel = null;
    private JLabel selectedGroupLabel = null;
    private JButton appendGroupButton = null;
    private JButton appendItemButton = null;
    private JPopupMenu checklistPopupMenu = null;
    private JMenuItem addChecklistMenuItem = null;
    private JCheckBoxMenuItem makeFlatChecklistCheckBoxMenuItem = null;
    private JMenuItem unCheckAllChecklistGroupsMenuItem = null;
    private JPopupMenu checkGroupPopupMenu = null;
    private JMenuItem editNameCheckGroupMenuItem = null;
    private JMenuItem removeCheckGroupMenuItem = null;
    private JMenuItem addCheckItemMenuItem = null;
    private JMenuItem moveUpCheckGroupMenuItem = null;
    private JMenuItem moveDownCheckGroupMenuItem = null;
    private JMenuItem insertCheckGroupMenuItem = null;
    private JMenuItem unCheckAllGroupItemsMenuItem = null;
    private JPopupMenu checkItemPopupMenu = null;
    private JMenuItem editNameCheckItemMenuItem = null;
    private JMenuItem editDateCheckItemMenuItem = null;
    private JMenuItem removeCheckItemMenuItem = null;
    private JMenuItem moveUpCheckItemMenuItem = null;
    private JMenuItem moveDownCheckItemMenuItem = null;
    private JMenuItem insertCheckItemMenuItem = null;
    private Vector<ChangeListener> changeListeners = new Vector();
    private static String ip;
    private static int port;

    public ChecklistPanel(ChecklistType cl) {
        FLAT_TITLE = I18n.text("Flat Checklist");
        NOT_FLAT_TITLE = I18n.text("Not Flat Checklist");
        this.checklist = cl;
        this.isFlat = this.checklist.isFlat();
        this.originalFilePath = this.checklist.getOriginalFilePath();
        if (this.originalFilePath.length() < 1) {
            this.setChanged(true);
        }
        this.initialize();
    }

    private void initialize() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(5);
        borderLayout.setVgap(5);
        this.setLayout(borderLayout);
        this.setSize(391, 550);
        this.add((Component)this.getHeaderPanel(), "North");
        this.add((Component)this.getCheckTaskPaneScrollPane(), "Center");
        this.add((Component)this.getEditPanel(), "South");
        this.getSaveButton().setEnabled(false);
        this.addPropertyChangeListener(DIRTY_PROPERTY, this);
        this.addPropertyChangeListener(SAVEAS_PROPERTY, this);
    }

    @Override
    public String getName() {
        if (this.nameText == null) {
            return "";
        }
        return this.nameText.getText();
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isDirty() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    private void fireChangeEvent(Component source) {
        this.firePropertyChange(DIRTY_PROPERTY, this.isChanged(), true);
    }

    private boolean isFlat() {
        return this.isFlat;
    }

    private void setFlat(boolean isFlat) {
        this.isFlat = isFlat;
    }

    private boolean makeItFlat() {
        if (this.isFlat()) {
            return true;
        }
        int countCG = this.checkTaskPane.getComponentCount();
        if (countCG == 0) {
            this.setFlat(true);
            return true;
        }
        if (countCG == 1) {
            Component[] compJTaskPaneGroup = this.getCheckTaskPane().getComponents();
            MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)compJTaskPaneGroup[0]);
            mtpg.setGroupName(FLAT_TITLE);
            this.setFlat(true);
            this.setSelectedGroup(mtpg);
            return true;
        }
        return false;
    }

    private boolean makeItNotFlat() {
        if (!this.isFlat()) {
            return true;
        }
        this.setFlat(false);
        Component[] compJTaskPaneGroup = this.getCheckTaskPane().getComponents();
        MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)compJTaskPaneGroup[0]);
        this.setSelectedGroup(mtpg);
        if (mtpg.getGroupName().equalsIgnoreCase(FLAT_TITLE)) {
            mtpg.setGroupName(NOT_FLAT_TITLE);
        }
        return true;
    }

    private JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel();
            this.headerPanel.setLayout(new BoxLayout(this.headerPanel, 1));
            this.headerPanel.add(this.getToolButtonsPanel());
            this.headerPanel.add(this.getHNamePanel());
            this.headerPanel.add(this.getHVersionPanel());
            this.headerPanel.add(this.getHDescriptionPanel());
        }
        return this.headerPanel;
    }

    private JScrollPane getCheckTaskPaneScrollPane() {
        if (this.checkTaskPaneScrollPane == null) {
            this.checkTaskPaneScrollPane = new JScrollPane();
            this.checkTaskPaneScrollPane.setHorizontalScrollBarPolicy(30);
            this.checkTaskPaneScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.checkTaskPaneScrollPane.setViewportView((Component)this.getCheckTaskPane());
            this.checkTaskPaneScrollPane.setVerticalScrollBarPolicy(22);
        }
        return this.checkTaskPaneScrollPane;
    }

    private void checkForChecklistChangeForSave() {
        if (this.isChanged()) {
            int response;
            if (this.getCheckTaskPane().getComponents().length == 0) {
                return;
            }
            if (this.isFlat && this.getCheckTaskPane().getComponents().length == 1) {
                MyJTaskPaneGroup jtpg = (MyJTaskPaneGroup)((Object)this.getCheckTaskPane().getComponents()[0]);
                if (jtpg.listCheckItemPanel.size() == 0) {
                    return;
                }
            }
            if ((response = JOptionPane.showConfirmDialog(this, "<html>" + I18n.textf("The checklist %checklist was not saved yet.", "<strong>" + this.getName() + "</strong>") + "<br>" + I18n.text("Do you want to save it now?") + "</html>", I18n.text("Save checklist?"), 0)) == 0) {
                this.save();
                this.userCancel = false;
            } else {
                this.userCancel = true;
            }
        } else {
            this.userCancel = true;
        }
    }

    private JFrame getJFrame(String title) {
        this.jFrame = title == null || title.isEmpty() ? new JFrame(I18n.textf("Checklist %name", this.nameText.getText())) : new JFrame(title);
        this.jFrame.getContentPane().add(this);
        this.jFrame.setSize(this.getWidth() + 5, this.getHeight() + 80);
        this.jFrame.setAlwaysOnTop(true);
        this.jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ChecklistPanel.this.checkForChecklistChangeForSave();
                ChecklistPanel.this.hideFrame();
            }
        });
        GuiUtils.centerOnScreen(this.jFrame);
        this.jFrame.setIconImage(ImageUtils.getImage("images/box_checked.png"));
        this.jFrame.setVisible(true);
        return this.jFrame;
    }

    public void setJInternalFrame(JInternalFrame internalFrame) {
        this.jInternalFrame = internalFrame;
        this.jInternalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
            }
        });
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeListeners.add(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeListeners.remove(cl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals(DIRTY_PROPERTY)) {
            boolean newValue = (Boolean)e.getNewValue();
            this.setChanged(newValue);
            if (!newValue) {
                this.getSaveButton().setEnabled(false);
            } else if (this.originalFilePath == null || this.originalFilePath.equalsIgnoreCase("")) {
                this.getSaveButton().setEnabled(false);
            } else {
                this.getSaveButton().setEnabled(true);
            }
        }
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener cl : this.changeListeners) {
            cl.stateChanged(evt);
        }
    }

    private JXTaskPaneContainer getCheckTaskPane() {
        if (this.checkTaskPane == null) {
            this.checkTaskPane = new JXTaskPaneContainer();
            this.checkTaskPane.setBackground(Color.white);
            this.checkTaskPane.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3 & e.getClickCount() == 1) {
                        ChecklistPanel.this.getChecklistPopupMenu().show((Component)e.getSource(), e.getX(), e.getY());
                    }
                }
            });
            this.checkTaskPane.addPropertyChangeListener(DIRTY_PROPERTY, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    boolean newValue = (Boolean)arg0.getNewValue();
                    ChecklistPanel.this.firePropertyChange(ChecklistPanel.DIRTY_PROPERTY, ChecklistPanel.this.isChanged(), newValue);
                }
            });
            if (this.isFlat) {
                MyJTaskPaneGroup tpg = this.createTemplateTaskPaneGroup();
                tpg.setGroupName(FLAT_TITLE);
                tpg.setCollapsed(false);
                LinkedHashMap<String, LinkedList<CheckItem>> cits = this.checklist.getGroupList();
                for (LinkedList<CheckItem> lli : cits.values()) {
                    for (CheckItem ci : lli) {
                        CheckItemPanel cip = new CheckItemPanel(ci);
                        this.addCheckItemMouseAdapter(cip);
                        tpg.add(cip);
                    }
                }
                this.checkTaskPane.add((Component)((Object)tpg));
                this.setSelectedGroup(tpg);
                this.getAppendItemButton().setEnabled(true);
            } else {
                LinkedHashMap<String, LinkedList<CheckItem>> cits = this.checklist.getGroupList();
                for (String group : cits.keySet()) {
                    MyJTaskPaneGroup tpg = this.createTemplateTaskPaneGroup();
                    tpg.setGroupName(group);
                    tpg.setCollapsed(true);
                    LinkedList<CheckItem> lli = cits.get(group);
                    for (CheckItem ci : lli) {
                        CheckItemPanel cip = new CheckItemPanel(ci);
                        this.addCheckItemMouseAdapter(cip);
                        tpg.add(cip);
                    }
                    this.checkTaskPane.add((Component)((Object)tpg));
                    this.setSelectedGroup(null);
                    this.getAppendItemButton().setEnabled(false);
                }
            }
        }
        return this.checkTaskPane;
    }

    private JScrollPane getDescScrollPane() {
        if (this.descScrollPane == null) {
            this.descScrollPane = new JScrollPane();
            this.descScrollPane.setPreferredSize(new Dimension(400, 100));
            this.descScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.descScrollPane.setHorizontalScrollBarPolicy(31);
            this.descScrollPane.setViewportView(this.getDescTextArea());
        }
        return this.descScrollPane;
    }

    private JTextArea getDescTextArea() {
        if (this.descTextArea == null) {
            this.descTextArea = new JTextArea();
            this.descTextArea.setLineWrap(true);
            this.descTextArea.setText(this.checklist.getDescription());
            this.descTextArea.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    ChecklistPanel.this.fireChangeEvent(ChecklistPanel.this.descTextArea);
                }
            });
        }
        return this.descTextArea;
    }

    private JPanel getHNamePanel() {
        if (this.hNamePanel == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setAlignment(0);
            this.hNamePanel = new JPanel();
            this.nameLabel = new JLabel();
            this.nameLabel.setText("<html><b>" + I18n.text("Name:"));
            this.nameText = new JLabel();
            this.nameText.setText(this.checklist.getName());
            this.hNamePanel.setLayout(flowLayout1);
            this.hNamePanel.add((Component)this.nameLabel, null);
            this.hNamePanel.add((Component)this.nameText, null);
        }
        return this.hNamePanel;
    }

    public void makeNameEditable() {
        this.nameText.setToolTipText(I18n.text("Right click to change (if edit mode)."));
        this.nameText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String inputValue;
                if (e.getButton() == 3 && (inputValue = JOptionPane.showInputDialog(ChecklistPanel.this, I18n.textf("Please input a new name for \"%name\"", ChecklistPanel.this.nameText.getText()), ChecklistPanel.this.nameText.getText())) != null && !inputValue.equalsIgnoreCase("")) {
                    ChecklistPanel.this.nameText.setText(inputValue);
                    ChecklistPanel.this.fireChangeEvent(ChecklistPanel.this.nameText);
                    if (ChecklistPanel.this.jFrame != null) {
                        ChecklistPanel.this.jFrame.setTitle(I18n.textf("Checklist %name", ChecklistPanel.this.getName()));
                    }
                }
            }
        });
    }

    private JPanel getHVersionPanel() {
        if (this.hVersionPanel == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setAlignment(0);
            this.hVersionPanel = new JPanel();
            this.versionLabel = new JLabel();
            this.versionLabel.setText("<html><b>" + I18n.text("Version:"));
            this.versionText = new JTextField(20);
            this.versionText.setText(this.checklist.getVersion());
            this.versionText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.versionText.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    ChecklistPanel.this.fireChangeEvent(ChecklistPanel.this.versionText);
                }
            });
            this.hVersionPanel.setLayout(flowLayout1);
            this.hVersionPanel.add((Component)this.versionLabel, null);
            this.hVersionPanel.add((Component)this.versionText, null);
        }
        return this.hVersionPanel;
    }

    private JPanel getHDescriptionPanel() {
        if (this.hDescriptionPanel == null) {
            BorderLayout borderLayout1 = new BorderLayout();
            borderLayout1.setHgap(5);
            borderLayout1.setVgap(5);
            this.hDescriptionPanel = new JPanel();
            this.descLabel = new JLabel();
            this.descLabel.setText("<html><b>" + I18n.text("Description:"));
            this.hDescriptionPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.hDescriptionPanel.setLayout(borderLayout1);
            this.hDescriptionPanel.add((Component)this.descLabel, "North");
            this.hDescriptionPanel.add((Component)this.getDescScrollPane(), "Center");
        }
        return this.hDescriptionPanel;
    }

    private JPanel getToolButtonsPanel() {
        if (this.toolButtonsPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(3);
            this.toolButtonsPanel = new JPanel();
            this.toolButtonsPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            this.toolButtonsPanel.setLayout(flowLayout);
            this.toolButtonsPanel.setSize(8, 8);
            this.toolButtonsPanel.add(new JLabel(NEPTUS_ICON));
            this.toolButtonsPanel.add(Box.createHorizontalStrut(10));
            this.toolButtonsPanel.add(this.getNewButton());
            this.toolButtonsPanel.add(this.getOpenButton());
            this.toolButtonsPanel.add(this.getSaveButton());
            this.toolButtonsPanel.add(this.getSaveAsButton());
            this.toolButtonsPanel.add(this.getGeneratePDFButton());
            this.toolButtonsPanel.add(this.getRunButton());
            this.toolButtonsPanel.add(this.getCancelButton());
        }
        return this.toolButtonsPanel;
    }

    private void iconifyToolButtons() {
        this.getOpenButton().setIcon(ICON_OPEN);
        this.getOpenButton().setPreferredSize(new Dimension(107, 40));
        this.getNewButton().setIcon(ICON_NEW);
        this.getNewButton().setPreferredSize(new Dimension(107, 40));
        this.getGeneratePDFButton().setIcon(ICON_PDF);
        this.getGeneratePDFButton().setPreferredSize(new Dimension(107, 40));
        this.getRunButton().setIcon(ICON_RUN);
        this.getRunButton().setPreferredSize(new Dimension(107, 40));
        this.getSaveAsButton().setIcon(ICON_SAVEAS);
        this.getSaveAsButton().setPreferredSize(new Dimension(107, 40));
        this.getSaveButton().setIcon(ICON_SAVE);
        this.getSaveButton().setPreferredSize(new Dimension(107, 40));
        this.getCancelButton().setIcon(ICON_CANCEL);
        this.getCancelButton().setPreferredSize(new Dimension(107, 40));
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText(I18n.text("Save"));
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChecklistPanel.this.userCancel = false;
                    ChecklistPanel.this.saveFile();
                }
            });
            this.saveButton.setPreferredSize(new Dimension(73, 26));
        }
        return this.saveButton;
    }

    public boolean save() {
        if (this.originalFilePath == null || this.originalFilePath.equalsIgnoreCase("")) {
            int response = JOptionPane.showConfirmDialog(this, "<html>" + I18n.textf("The checklist %name was not saved yet.", "<strong>" + this.getName() + "</strong>") + "<br>" + I18n.text("Do you want to save it now?") + "</html>", I18n.text("Save checklist?"), 1);
            if (response != 0) {
                return false;
            }
            return this.saveAsFile();
        }
        return this.saveFile();
    }

    public boolean saveAsFile() {
        File fx = this.originalFilePath == null || this.originalFilePath.equalsIgnoreCase("") ? ChecklistFileChooser.showSaveDialog(this, null) : ChecklistFileChooser.showSaveDialog(this, new File(this.originalFilePath));
        if (fx != null && !fx.getName().equalsIgnoreCase("")) {
            String ext = FileUtil.getFileExtension(fx);
            ext = "nchk".equalsIgnoreCase(ext) || "xml".equalsIgnoreCase(ext) ? "" : ".nchk";
            this.originalFilePath = fx.getAbsolutePath();
            this.originalFilePath = this.originalFilePath + ext;
            boolean ret = this.saveFile();
            if (ret) {
                this.getSaveButton().setEnabled(false);
                this.firePropertyChange(SAVEAS_PROPERTY, false, true);
            }
            return ret;
        }
        return false;
    }

    public boolean saveFile() {
        if (this.originalFilePath == null || this.originalFilePath.equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this, "<html>" + I18n.text("Checklist <b>was not</b> saved!") + "<br>" + I18n.textf("File name was not valid [\"%file\"].", this.originalFilePath) + "</html>");
            return false;
        }
        boolean ret = FileUtil.saveToFile(this.originalFilePath, FileUtil.getAsPrettyPrintFormatedXMLString(this.getChecklistType().asDocument()));
        if (ret) {
            this.checklist = this.getChecklistType();
            JOptionPane.showMessageDialog(this, "<html>" + I18n.text("Checklist saved!") + "<br>" + I18n.textf("To file \"%file\".", this.originalFilePath) + "</html>");
            this.getSaveButton().setEnabled(false);
            this.setChanged(false);
        }
        return ret;
    }

    public JButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new JButton();
            this.newButton.setVisible(false);
            this.newButton.setText(I18n.text("New"));
            this.newButton.setPreferredSize(new Dimension(73, 26));
            this.newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ChecklistPanel.this.isChanged()) {
                        ChecklistPanel.this.checkForChecklistChangeForSave();
                    }
                    BlockingGlassPane bgp = new BlockingGlassPane();
                    if (ChecklistPanel.this.jFrame != null) {
                        ChecklistPanel.this.jFrame.setGlassPane(bgp);
                    }
                    if (ChecklistPanel.this.jInternalFrame != null) {
                        ChecklistPanel.this.jInternalFrame.setGlassPane(bgp);
                    }
                    bgp.block(true);
                    ChecklistType clist = new ChecklistType();
                    clist.setName(I18n.text("New Checklist"));
                    ChecklistPanel.this.changeChecklist(clist);
                    bgp.block(false);
                }
            });
        }
        return this.newButton;
    }

    public JButton getOpenButton() {
        if (this.openButton == null) {
            this.openButton = new JButton();
            this.openButton.setText(I18n.text("Open"));
            this.openButton.setVisible(false);
            this.openButton.setPreferredSize(new Dimension(73, 26));
            this.openButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File fx;
                    if (ChecklistPanel.this.isChanged()) {
                        ChecklistPanel.this.checkForChecklistChangeForSave();
                    }
                    if ((fx = ChecklistPanel.this.originalFilePath == null || ChecklistPanel.this.originalFilePath.equalsIgnoreCase("") ? ChecklistFileChooser.showOpenDialog(ChecklistPanel.this, null) : ChecklistFileChooser.showOpenDialog(ChecklistPanel.this, new File(ChecklistPanel.this.originalFilePath))) != null && !fx.getName().equalsIgnoreCase("")) {
                        final File fxF = fx;
                        final BlockingGlassPane bgp = new BlockingGlassPane();
                        if (ChecklistPanel.this.jFrame != null) {
                            ChecklistPanel.this.jFrame.setGlassPane(bgp);
                        }
                        if (ChecklistPanel.this.jInternalFrame != null) {
                            ChecklistPanel.this.jInternalFrame.setGlassPane(bgp);
                        }
                        bgp.block(true);
                        SwingWorker<Void, ChecklistType> worker = new SwingWorker<Void, ChecklistType>(){

                            @Override
                            protected Void doInBackground() throws Exception {
                                ChecklistType clist = new ChecklistType(fxF.getAbsolutePath());
                                ArrayList<ChecklistType> al = new ArrayList<ChecklistType>();
                                al.add(clist);
                                this.process((List<ChecklistType>)al);
                                return null;
                            }

                            @Override
                            protected void process(List<ChecklistType> chunks) {
                                ChecklistPanel.this.changeChecklist(chunks.get(0));
                            }

                            @Override
                            protected void done() {
                                try {
                                    this.get();
                                }
                                catch (Exception e) {
                                    NeptusLog.pub().error((Object)e);
                                }
                                super.done();
                                bgp.block(false);
                            }
                        };
                        worker.execute();
                    }
                }
            });
        }
        return this.openButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(I18n.text("Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChecklistPanel.this.userCancel = true;
                    ChecklistPanel.this.hideFrame();
                }
            });
            this.cancelButton.setPreferredSize(new Dimension(73, 26));
        }
        return this.cancelButton;
    }

    public JButton getRunButton() {
        if (this.runButton == null) {
            this.runButton = new JButton();
            this.runButton.setText(I18n.text("Run"));
            this.runButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ChecklistPanel.this.isChanged()) {
                        ChecklistPanel.this.checkForChecklistChangeForSave();
                    }
                    ImcMsgManager.getManager().start();
                    LinkedHashMap list = ImcMsgManager.getManager().getCommInfo();
                    if (list.size() == 0) {
                        GuiUtils.errorMessage(ChecklistPanel.this, I18n.text("Comunications"), I18n.text("No System online"));
                        return;
                    }
                    SystemImcMsgCommInfo mv = (SystemImcMsgCommInfo)JOptionPane.showInputDialog(ChecklistPanel.this, I18n.text("Choose one of the available systems"), I18n.text("Select System"), 3, new ImageIcon(), list.values().toArray(new SystemImcMsgCommInfo[0]), list.values().toArray(new SystemImcMsgCommInfo[0]));
                    String system = mv.toString();
                    CheckListExe.showCheckListExeDialog(system, ChecklistPanel.this.getChecklistType().createCopy(), SwingUtilities.getWindowAncestor(ChecklistPanel.this), new File(ChecklistPanel.this.getChecklistType().getOriginalFilePath()).getParent());
                    NeptusLog.pub().info((Object)("RunChecklist: " + new File(ChecklistPanel.this.getChecklistType().getOriginalFilePath()).getParent()));
                    NeptusLog.pub().info((Object)("RunChecklist: " + ChecklistPanel.this.getChecklistType().getOriginalFilePath()));
                }
            });
            this.runButton.setPreferredSize(new Dimension(73, 26));
        }
        return this.runButton;
    }

    private MyJTaskPaneGroup createTemplateTaskPaneGroup() {
        this.templateTaskPaneGroup = new MyJTaskPaneGroup();
        this.templateTaskPaneGroup.setIcon(OK_IMAGE_ICON);
        this.templateTaskPaneGroup.setScrollOnExpand(true);
        this.templateTaskPaneGroup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)e.getSource();
                mtpg.requestFocusInWindow();
                if (e.getButton() == 3 & e.isControlDown()) {
                    mtpg.setCollapsed(false);
                    ChecklistPanel.this.editNameCheckGroupActionWorker(mtpg);
                } else if (e.getButton() == 3) {
                    mtpg.setCollapsed(false);
                    ChecklistPanel.this.getCheckGroupPopupMenu().show((Component)e.getSource(), e.getX(), e.getY());
                } else if (e.getButton() == 1 && e.getClickCount() > 1 && mtpg.getHeight() - e.getY() < 20) {
                    ChecklistPanel.this.addNewCheckItemWorker(mtpg, false, null);
                }
                if (mtpg.isCollapsed()) {
                    if (mtpg == ChecklistPanel.this.getSelectedGroup()) {
                        ChecklistPanel.this.getAppendItemButton().setEnabled(false);
                        ChecklistPanel.this.setSelectedGroup(null);
                    }
                } else {
                    ChecklistPanel.this.getAppendItemButton().setEnabled(true);
                    ChecklistPanel.this.setSelectedGroup(mtpg);
                }
            }
        });
        this.templateTaskPaneGroup.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                MyJTaskPaneGroup mtpg;
                if (e.getKeyCode() == 37) {
                    MyJTaskPaneGroup mtpg2 = (MyJTaskPaneGroup)e.getSource();
                    if (!mtpg2.isCollapsed()) {
                        mtpg2.setCollapsed(true);
                    }
                } else if (e.getKeyCode() == 39 && (mtpg = (MyJTaskPaneGroup)e.getSource()).isCollapsed()) {
                    mtpg.setCollapsed(false);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        return this.templateTaskPaneGroup;
    }

    private MyJTaskPaneGroup getSelectedGroup() {
        return this.selectedGroup;
    }

    private void setSelectedGroup(MyJTaskPaneGroup selectedGroup) {
        this.selectedGroup = selectedGroup;
        if (this.selectedGroup != null) {
            String tl = this.selectedGroup.getGroupName();
            if (this.isFlat()) {
                this.getSelectedGroupLabel().setText("");
            } else if (tl.length() <= 20) {
                this.getSelectedGroupLabel().setText("<html><b>" + tl);
            } else {
                this.getSelectedGroupLabel().setText("<html><b>" + tl.substring(0, 20) + "...");
            }
        } else {
            this.getSelectedGroupLabel().setText("");
        }
    }

    private void hideFrame() {
        if (this.jFrame != null) {
            this.jFrame.setVisible(false);
            this.jFrame.dispose();
        }
        if (this.jInternalFrame != null) {
            this.jInternalFrame.setVisible(false);
            this.jInternalFrame.doDefaultCloseAction();
            this.jInternalFrame.dispose();
        }
    }

    public ChecklistType getChecklistType() {
        if (this.userCancel) {
            return this.checklist;
        }
        ChecklistType newChecklist = new ChecklistType();
        newChecklist.setName(this.nameText.getText());
        newChecklist.setVersion(this.versionText.getText());
        newChecklist.setDescription(this.descTextArea.getText());
        newChecklist.setOriginalFilePath(this.originalFilePath);
        newChecklist.setFlat(this.isFlat);
        LinkedHashMap<String, LinkedList<CheckItem>> glists = newChecklist.getGroupList();
        if (this.isFlat) {
            MyJTaskPaneGroup jtpg;
            LinkedList<CheckItem> lkl = new LinkedList<CheckItem>();
            if (this.getCheckTaskPane().getComponentCount() > 0 && (jtpg = (MyJTaskPaneGroup)((Object)this.getCheckTaskPane().getComponents()[0])).getContentPane().getComponentCount() > 0 && !jtpg.listCheckItemPanel.isEmpty()) {
                for (CheckItemPanel checkItemPanel : jtpg.listCheckItemPanel) {
                    lkl.add(checkItemPanel.getCheckItem());
                }
            }
            glists.put("flat", lkl);
        } else if (this.getCheckTaskPane().getComponentCount() > 0) {
            Component[] compJTaskPaneGroup = this.getCheckTaskPane().getComponents();
            for (int i = 0; i < compJTaskPaneGroup.length; ++i) {
                MyJTaskPaneGroup jtpg = (MyJTaskPaneGroup)((Object)compJTaskPaneGroup[i]);
                LinkedList<CheckItem> linkedList = new LinkedList<CheckItem>();
                if (!jtpg.listCheckItemPanel.isEmpty()) {
                    for (CheckItemPanel checkItemPanel : jtpg.listCheckItemPanel) {
                        linkedList.add(checkItemPanel.getCheckItem());
                    }
                }
                glists.put(jtpg.getGroupName(), linkedList);
            }
        }
        return newChecklist;
    }

    public static ChecklistPanel showChecklistPanel(String title, ChecklistType cl) {
        ChecklistPanel csp = new ChecklistPanel(cl);
        csp.getJFrame(title);
        return csp;
    }

    public static ChecklistPanel showChecklistPanel(ChecklistType cl) {
        return ChecklistPanel.showChecklistPanel(null, cl);
    }

    public static ChecklistPanel showChecklistPanel(String url) {
        ChecklistType cl = new ChecklistType(url);
        return ChecklistPanel.showChecklistPanel(null, cl);
    }

    private JButton getGeneratePDFButton() {
        if (this.generatePDFButton == null) {
            this.generatePDFButton = new JButton();
            this.generatePDFButton.setText(I18n.text("To PDF"));
            this.generatePDFButton.setPreferredSize(new Dimension(73, 26));
            this.generatePDFButton.setEnabled(true);
            this.generatePDFButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int cho;
                    boolean ret = false;
                    ChecklistPanel.this.checkForChecklistChangeForSave();
                    if (ChecklistPanel.this.isChanged()) {
                        return;
                    }
                    ret = true;
                    if (!ret) {
                        JOptionPane.showMessageDialog(ChecklistPanel.this, "<html>" + I18n.text("PDF <b>was not</b> created to file.") + "</html>");
                        return;
                    }
                    final String xml = ChecklistPanel.this.originalFilePath;
                    File xmlFx = new File(xml);
                    xmlFx.getName();
                    String pdfFileName = ChecklistPanel.createPDFFileName(xmlFx.getName());
                    final File pdfFx = new File(xmlFx.getParent(), pdfFileName);
                    final String pdf = pdfFx.getAbsolutePath();
                    Object[] optionsNew = new Object[]{I18n.text("1 column"), I18n.text("2 column"), I18n.text("3 column")};
                    final int choNew = JOptionPane.showOptionDialog(ChecklistPanel.this, I18n.text("Choose one to continue"), I18n.text("Choose"), -1, 3, null, optionsNew, optionsNew[2]);
                    if (choNew == 3) {
                        Object[] options = new Object[]{I18n.text("1 column"), I18n.text("2 column")};
                        cho = JOptionPane.showOptionDialog(ChecklistPanel.this, I18n.text("Choose one to continue"), I18n.text("Choose"), -1, 3, null, options, options[0]);
                    } else {
                        cho = 0;
                    }
                    final BlockingGlassPane bgp = new BlockingGlassPane();
                    if (ChecklistPanel.this.jFrame != null) {
                        ChecklistPanel.this.jFrame.setGlassPane(bgp);
                    }
                    if (ChecklistPanel.this.jInternalFrame != null) {
                        ChecklistPanel.this.jInternalFrame.setGlassPane(bgp);
                    }
                    bgp.block(true);
                    SwingWorker<Integer, Void> worker = new SwingWorker<Integer, Void>(){

                        @Override
                        protected Integer doInBackground() throws Exception {
                            if (choNew == 3) {
                                boolean ret;
                                String xslt = ConfigFetch.resolvePathBasedOnConfigFile("conf/checklist-fo.xsl");
                                if (cho == 1) {
                                    xslt = ConfigFetch.resolvePathBasedOnConfigFile("conf/checklist-fo-2col.xsl");
                                }
                                return (ret = TransformFOP.convertXML2PDF(xml, xslt, pdf)) ? 1 : 0;
                            }
                            if (choNew == 0 || choNew == 1 || choNew == 2) {
                                boolean ret = GeneratorChecklistPDF.generateReport(ChecklistPanel.this.checklist, pdfFx, (short)(choNew + 1));
                                return ret ? 1 : 0;
                            }
                            return -1;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                NeptusLog.pub().error((Object)e);
                            }
                            super.done();
                            try {
                                switch ((Integer)this.get()) {
                                    case 1: {
                                        JOptionPane.showMessageDialog(ChecklistPanel.this, I18n.textf("PDF created with success to file \"%file\".", pdf), I18n.text("PDF Creation"), 1);
                                        final String pdfF = pdf;
                                        new Thread(){

                                            @Override
                                            public void run() {
                                                ChecklistPanel.this.openPDFInExternalViewer(pdfF);
                                            }
                                        }.start();
                                        break;
                                    }
                                    case 0: {
                                        JOptionPane.showMessageDialog(ChecklistPanel.this, "<html>" + I18n.text("PDF <b>was not</b> created to file.") + "</html>", I18n.text("PDF Creation"), 0);
                                        break;
                                    }
                                }
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog(ChecklistPanel.this, "<html>" + I18n.text("PDF <b>was not</b> created to file.") + "<br>" + I18n.textf("Error: %error", e.getMessage()) + "</html>", I18n.text("PDF Creation"), 0);
                                e.printStackTrace();
                            }
                            bgp.block(false);
                        }
                    };
                    worker.execute();
                }
            });
        }
        return this.generatePDFButton;
    }

    protected void openPDFInExternalViewer(String pdf) {
        try {
            if (ConfigFetch.getOS() == 0) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + pdf);
            } else {
                String[] readers = new String[]{"xpdf", "kpdf", "FoxitReader", "evince", "acroread"};
                String reader = null;
                for (int count = 0; count < readers.length && reader == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", readers[count]}).waitFor() != 0) continue;
                    reader = readers[count];
                }
                if (reader == null) {
                    throw new Exception("Could not find pdf reader");
                }
                Runtime.getRuntime().exec(new String[]{reader, pdf});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static String createPDFFileName(String name) {
        String ret = "";
        String ext = "";
        int xmlInt = -1;
        ext = FileUtil.getFileExtension(name);
        xmlInt = "".equalsIgnoreCase(ext) ? -1 : name.lastIndexOf("." + ext);
        if (xmlInt == -1) {
            ret = name + ".pdf";
            return ret;
        }
        String sub = name.substring(0, xmlInt);
        ret = sub + ".pdf";
        return ret;
    }

    private JButton getSaveAsButton() {
        if (this.saveAsButton == null) {
            this.saveAsButton = new JButton();
            this.saveAsButton.setText(I18n.text("Save as"));
            this.saveAsButton.setEnabled(true);
            this.saveAsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChecklistPanel.this.saveAsFile();
                }
            });
            this.saveAsButton.setPreferredSize(new Dimension(79, 26));
        }
        return this.saveAsButton;
    }

    private JPopupMenu getChecklistPopupMenu() {
        if (this.checklistPopupMenu == null) {
            this.checklistPopupMenu = new JPopupMenu();
            this.checklistPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    if (ChecklistPanel.this.isFlat()) {
                        ChecklistPanel.this.getMakeFlatChecklistCheckBoxMenuItem().setEnabled(false);
                        ChecklistPanel.this.getMakeFlatChecklistCheckBoxMenuItem().setSelected(true);
                        ChecklistPanel.this.getMakeFlatChecklistCheckBoxMenuItem().setEnabled(true);
                    } else {
                        ChecklistPanel.this.getMakeFlatChecklistCheckBoxMenuItem().setEnabled(false);
                        ChecklistPanel.this.getMakeFlatChecklistCheckBoxMenuItem().setSelected(false);
                        ChecklistPanel.this.getMakeFlatChecklistCheckBoxMenuItem().setEnabled(true);
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            this.checklistPopupMenu.add(this.getAddChecklistMenuItem());
            this.checklistPopupMenu.add(this.getMakeFlatChecklistCheckBoxMenuItem());
            this.checklistPopupMenu.add(this.getUnCheckAllChecklistGroupsMenuItem());
        }
        return this.checklistPopupMenu;
    }

    private JPopupMenu getCheckGroupPopupMenu() {
        if (this.checkGroupPopupMenu == null) {
            this.checkGroupPopupMenu = new JPopupMenu();
            this.checkGroupPopupMenu.add(this.getEditNameCheckGroupMenuItem());
            this.checkGroupPopupMenu.add(this.getRemoveCheckGroupMenuItem());
            this.checkGroupPopupMenu.addSeparator();
            this.checkGroupPopupMenu.add(this.getAddCheckItemMenuItem());
            this.checkGroupPopupMenu.addSeparator();
            this.checkGroupPopupMenu.add(this.getMoveUpCheckGroupMenuItem());
            this.checkGroupPopupMenu.add(this.getMoveDownCheckGroupMenuItem());
            this.checkGroupPopupMenu.addSeparator();
            this.checkGroupPopupMenu.add(this.getInsertCheckGroupMenuItem());
            this.checkGroupPopupMenu.addSeparator();
            this.checkGroupPopupMenu.add(this.getUnCheckAllGroupItemsMenuItem());
            this.checkGroupPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    JPopupMenu jpm = (JPopupMenu)e.getSource();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)jpm.getInvoker());
                    JXTaskPaneContainer jtp = (JXTaskPaneContainer)mtpg.getParent();
                    if (jtp.getComponentCount() <= 1) {
                        ChecklistPanel.this.getMoveUpCheckGroupMenuItem().setEnabled(false);
                        ChecklistPanel.this.getMoveDownCheckGroupMenuItem().setEnabled(false);
                    } else {
                        int zOrder = jtp.getComponentZOrder((Component)((Object)mtpg));
                        int totalItems = jtp.getComponentCount();
                        if (zOrder == 0) {
                            ChecklistPanel.this.getMoveUpCheckGroupMenuItem().setEnabled(false);
                        } else {
                            ChecklistPanel.this.getMoveUpCheckGroupMenuItem().setEnabled(true);
                        }
                        if (zOrder == totalItems - 1) {
                            ChecklistPanel.this.getMoveDownCheckGroupMenuItem().setEnabled(false);
                        } else {
                            ChecklistPanel.this.getMoveDownCheckGroupMenuItem().setEnabled(true);
                        }
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        return this.checkGroupPopupMenu;
    }

    private JMenuItem getAddChecklistMenuItem() {
        if (this.addChecklistMenuItem == null) {
            this.addChecklistMenuItem = new JMenuItem();
            this.addChecklistMenuItem.setText(I18n.text("Append New Group"));
            this.addChecklistMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChecklistPanel.this.addNewChecklistGroupActionWorker(false, null);
                }
            });
        }
        return this.addChecklistMenuItem;
    }

    private MyJTaskPaneGroup addNewChecklistGroupActionWorker(boolean insert, JXTaskPane insertTpg) {
        String inputValue = JOptionPane.showInputDialog(this, (Object)I18n.text("Please input a name for the new group"));
        if (inputValue != null && !inputValue.trim().equalsIgnoreCase("")) {
            boolean notUnique = this.checkForCheckGroupExistence(inputValue = inputValue.trim());
            if (notUnique) {
                JOptionPane.showMessageDialog(this, I18n.text("Group already exists!"));
                return null;
            }
            MyJTaskPaneGroup tpg = this.createTemplateTaskPaneGroup();
            tpg.setGroupName(inputValue);
            tpg.setCollapsed(false);
            if (!insert) {
                this.checkTaskPane.add((Component)((Object)tpg));
            } else {
                int zOrder = this.checkTaskPane.getComponentZOrder((Component)insertTpg);
                this.checkTaskPane.add((Component)((Object)tpg), zOrder);
            }
            this.fireChangeEvent((Component)this.checkTaskPane);
            this.checkTaskPane.revalidate();
            this.checkTaskPane.repaint();
            this.makeItNotFlat();
            return tpg;
        }
        JOptionPane.showMessageDialog(this, I18n.text("Not a valid name!"));
        return null;
    }

    private boolean checkForCheckGroupExistence(String nameValue) {
        int totalGroups = this.checkTaskPane.getComponentCount();
        if (totalGroups == 0) {
            return false;
        }
        Component[] components = this.checkTaskPane.getComponents();
        MyJTaskPaneGroup testSubj = new MyJTaskPaneGroup();
        testSubj.setGroupName(nameValue);
        for (int i = 0; i < totalGroups; ++i) {
            MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)components[i]);
            if (!testSubj.equals(mtpg)) continue;
            return true;
        }
        return false;
    }

    private JMenuItem getEditNameCheckGroupMenuItem() {
        if (this.editNameCheckGroupMenuItem == null) {
            this.editNameCheckGroupMenuItem = new JMenuItem();
            this.editNameCheckGroupMenuItem.setText(I18n.text("Edit Name (Ctrl + Right click)"));
            this.editNameCheckGroupMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem jmi = (JMenuItem)e.getSource();
                    JPopupMenu jpm = (JPopupMenu)jmi.getParent();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)jpm.getInvoker());
                    ChecklistPanel.this.editNameCheckGroupActionWorker(mtpg);
                }
            });
        }
        return this.editNameCheckGroupMenuItem;
    }

    private boolean editNameCheckGroupActionWorker(MyJTaskPaneGroup mtpg) {
        String inputValue = JOptionPane.showInputDialog(this, I18n.textf("Please input a new name for \"%group\"", mtpg.getGroupName()), mtpg.getGroupName());
        if (inputValue != null && !inputValue.trim().equalsIgnoreCase("")) {
            boolean notUnique = this.checkForCheckGroupExistence(inputValue);
            if (notUnique) {
                JOptionPane.showMessageDialog(this, I18n.text("Group already exists!"));
                return false;
            }
            mtpg.setGroupName(inputValue.trim());
            this.fireChangeEvent((Component)((Object)mtpg));
            this.checkTaskPane.revalidate();
            this.checkTaskPane.repaint();
            return true;
        }
        return false;
    }

    private JMenuItem getAddCheckItemMenuItem() {
        if (this.addCheckItemMenuItem == null) {
            this.addCheckItemMenuItem = new JMenuItem();
            this.addCheckItemMenuItem.setText(I18n.text("Append New Item (Double Click on the Bottom of the Group)"));
            this.addCheckItemMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem jmi = (JMenuItem)e.getSource();
                    JPopupMenu jpm = (JPopupMenu)jmi.getParent();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)jpm.getInvoker());
                    ChecklistPanel.this.addNewCheckItemWorker(mtpg, false, null);
                }
            });
        }
        return this.addCheckItemMenuItem;
    }

    private void addNewCheckItemWorker(MyJTaskPaneGroup mtpg, boolean insert, CheckItemPanel insertCip) {
        CheckItemPanel cip;
        String inputValue = JOptionPane.showInputDialog(this, (Object)I18n.text("Please input the item name"));
        if (inputValue != null && !inputValue.equalsIgnoreCase("")) {
            boolean notUnique = this.checkForCheckItemExistence(inputValue = inputValue.trim(), mtpg);
            if (notUnique) {
                JOptionPane.showMessageDialog(this, I18n.text("Item already exists!"));
                return;
            }
            CheckItem cit = new CheckItem();
            cit.setName(inputValue);
            cip = new CheckItemPanel(cit);
            this.addCheckItemMouseAdapter(cip);
            if (!insert) {
                mtpg.add(cip);
            } else {
                int zOrder = mtpg.getContentPane().getComponentZOrder(insertCip);
                mtpg.add(cip, zOrder);
            }
        } else {
            JOptionPane.showMessageDialog(this, I18n.text("Item name not valid!"));
            return;
        }
        this.fireChangeEvent(cip);
        mtpg.revalidate();
        mtpg.repaint();
    }

    private boolean checkForCheckItemExistence(String nameItemValue, MyJTaskPaneGroup mtpg) {
        int totalItems = mtpg.getContentPane().getComponentCount();
        if (totalItems == 0) {
            return false;
        }
        Component[] components = mtpg.getContentPane().getComponents();
        CheckItemPanel testSubj = new CheckItemPanel();
        testSubj.setName(nameItemValue);
        for (int i = 0; i < totalItems; ++i) {
            CheckItemPanel cip = (CheckItemPanel)components[i];
            if (!testSubj.equals(cip)) continue;
            return true;
        }
        return false;
    }

    private JMenuItem getRemoveCheckGroupMenuItem() {
        if (this.removeCheckGroupMenuItem == null) {
            this.removeCheckGroupMenuItem = new JMenuItem();
            this.removeCheckGroupMenuItem.setText(I18n.text("Remove Group"));
            this.removeCheckGroupMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem jmi = (JMenuItem)e.getSource();
                    JPopupMenu jpm = (JPopupMenu)jmi.getParent();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)jpm.getInvoker());
                    int option = JOptionPane.showConfirmDialog((Component)ChecklistPanel.this.checkTaskPane, "<html>" + I18n.textf("Are you sure you want to <b>delete</b><br><i>%group</i> group and all it's content?", mtpg.getGroupName()) + "<html>");
                    if (option == 0) {
                        JXTaskPaneContainer jtp = (JXTaskPaneContainer)mtpg.getParent();
                        jtp.remove((Component)((Object)mtpg));
                        ChecklistPanel.this.fireChangeEvent((Component)((Object)mtpg));
                        jtp.revalidate();
                        jtp.repaint();
                    }
                }
            });
            this.removeCheckGroupMenuItem.setEnabled(true);
        }
        return this.removeCheckGroupMenuItem;
    }

    private JCheckBoxMenuItem getMakeFlatChecklistCheckBoxMenuItem() {
        if (this.makeFlatChecklistCheckBoxMenuItem == null) {
            this.makeFlatChecklistCheckBoxMenuItem = new JCheckBoxMenuItem();
            this.makeFlatChecklistCheckBoxMenuItem.setText(FLAT_TITLE);
            this.makeFlatChecklistCheckBoxMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JCheckBoxMenuItem jmi = (JCheckBoxMenuItem)e.getSource();
                    if (jmi.isSelected()) {
                        if (ChecklistPanel.this.makeItFlat()) {
                            if (jmi.isEnabled()) {
                                ChecklistPanel.this.fireChangeEvent((Component)ChecklistPanel.this.checkTaskPane);
                            }
                        } else {
                            JOptionPane.showMessageDialog((Component)ChecklistPanel.this.checkTaskPane, "<html>" + I18n.text("<b>Was not</b> possible to flatten this checklist!") + "</html>", I18n.text("Flatten Checklist"), 0);
                        }
                    } else if (ChecklistPanel.this.makeItNotFlat()) {
                        if (jmi.isEnabled()) {
                            ChecklistPanel.this.fireChangeEvent((Component)ChecklistPanel.this.checkTaskPane);
                        }
                    } else {
                        JOptionPane.showMessageDialog((Component)ChecklistPanel.this.checkTaskPane, "<html>" + I18n.text("<b>Was not</b> possible to deflatten this checklist!") + "</html>", I18n.text("Deflatten Checklist"), 0);
                    }
                }
            });
        }
        return this.makeFlatChecklistCheckBoxMenuItem;
    }

    private JPopupMenu getCheckItemPopupMenu() {
        if (this.checkItemPopupMenu == null) {
            this.checkItemPopupMenu = new JPopupMenu();
            this.checkItemPopupMenu.add(this.getEditNameCheckItemMenuItem());
            this.checkItemPopupMenu.add(this.getEditDateCheckItemMenuItem());
            this.checkItemPopupMenu.add(this.getRemoveCheckItemMenuItem());
            this.checkItemPopupMenu.addSeparator();
            this.checkItemPopupMenu.add(this.getMoveUpCheckItemMenuItem());
            this.checkItemPopupMenu.add(this.getMoveDownCheckItemMenuItem());
            this.checkItemPopupMenu.addSeparator();
            this.checkItemPopupMenu.add(this.getInsertCheckItemMenuItem());
            this.checkItemPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    JPopupMenu jpm = (JPopupMenu)e.getSource();
                    CheckItemPanel cip = (CheckItemPanel)jpm.getInvoker();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)cip.getParentGroup());
                    if (mtpg.getContentPane().getComponentCount() <= 1) {
                        ChecklistPanel.this.getMoveUpCheckItemMenuItem().setEnabled(false);
                        ChecklistPanel.this.getMoveDownCheckItemMenuItem().setEnabled(false);
                    } else {
                        int zOrder = mtpg.getContentPane().getComponentZOrder(cip);
                        int totalItems = mtpg.getContentPane().getComponentCount();
                        if (zOrder == 0) {
                            ChecklistPanel.this.getMoveUpCheckItemMenuItem().setEnabled(false);
                        } else {
                            ChecklistPanel.this.getMoveUpCheckItemMenuItem().setEnabled(true);
                        }
                        if (zOrder == totalItems - 1) {
                            ChecklistPanel.this.getMoveDownCheckItemMenuItem().setEnabled(false);
                        } else {
                            ChecklistPanel.this.getMoveDownCheckItemMenuItem().setEnabled(true);
                        }
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        return this.checkItemPopupMenu;
    }

    private JMenuItem getRemoveCheckItemMenuItem() {
        if (this.removeCheckItemMenuItem == null) {
            this.removeCheckItemMenuItem = new JMenuItem();
            this.removeCheckItemMenuItem.setText(I18n.text("Remove Item"));
            this.removeCheckItemMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem jmi = (JMenuItem)e.getSource();
                    JPopupMenu jpm = (JPopupMenu)jmi.getParent();
                    CheckItemPanel cip = (CheckItemPanel)jpm.getInvoker();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)cip.getParentGroup());
                    mtpg.remove(cip);
                    ChecklistPanel.this.fireChangeEvent(cip);
                    mtpg.revalidate();
                    mtpg.repaint();
                }
            });
        }
        return this.removeCheckItemMenuItem;
    }

    private void addCheckItemMouseAdapter(CheckItemPanel cip) {
        cip.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CheckItemPanel cip = (CheckItemPanel)e.getSource();
                cip.requestFocusInWindow();
                ChecklistPanel.this.setSelectedGroup(CheckItemPanel.getMyJTaskPaneGroupFromItem(cip));
                if (e.getButton() == 3) {
                    ChecklistPanel.this.getCheckItemPopupMenu().show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        });
    }

    private JMenuItem getMoveUpCheckItemMenuItem() {
        if (this.moveUpCheckItemMenuItem == null) {
            this.moveUpCheckItemMenuItem = new JMenuItem();
            this.moveUpCheckItemMenuItem.setText(I18n.text("Move Item Up"));
            this.moveUpCheckItemMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem jmi = (JMenuItem)e.getSource();
                    JPopupMenu jpm = (JPopupMenu)jmi.getParent();
                    CheckItemPanel cip = (CheckItemPanel)jpm.getInvoker();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)cip.getParentGroup());
                    int zOrder = mtpg.getContentPane().getComponentZOrder(cip);
                    mtpg.remove(cip);
                    mtpg.add(cip, zOrder - 1);
                    ChecklistPanel.this.fireChangeEvent(cip);
                    mtpg.revalidate();
                    mtpg.repaint();
                }
            });
        }
        return this.moveUpCheckItemMenuItem;
    }

    private JMenuItem getMoveDownCheckItemMenuItem() {
        if (this.moveDownCheckItemMenuItem == null) {
            this.moveDownCheckItemMenuItem = new JMenuItem();
            this.moveDownCheckItemMenuItem.setText(I18n.text("Move Item Down"));
            this.moveDownCheckItemMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem jmi = (JMenuItem)e.getSource();
                    JPopupMenu jpm = (JPopupMenu)jmi.getParent();
                    CheckItemPanel cip = (CheckItemPanel)jpm.getInvoker();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)cip.getParentGroup());
                    int zOrder = mtpg.getContentPane().getComponentZOrder(cip);
                    mtpg.remove(cip);
                    mtpg.add(cip, zOrder + 1);
                    ChecklistPanel.this.fireChangeEvent(cip);
                    mtpg.revalidate();
                    mtpg.repaint();
                }
            });
        }
        return this.moveDownCheckItemMenuItem;
    }

    private JMenuItem getMoveUpCheckGroupMenuItem() {
        if (this.moveUpCheckGroupMenuItem == null) {
            this.moveUpCheckGroupMenuItem = new JMenuItem();
            this.moveUpCheckGroupMenuItem.setText(I18n.text("Move Group Up"));
            this.moveUpCheckGroupMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem jmi = (JMenuItem)e.getSource();
                    JPopupMenu jpm = (JPopupMenu)jmi.getParent();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)jpm.getInvoker());
                    JXTaskPaneContainer jtp = (JXTaskPaneContainer)mtpg.getParent();
                    int zOrder = jtp.getComponentZOrder((Component)((Object)mtpg));
                    jtp.remove((Component)((Object)mtpg));
                    jtp.add((Component)((Object)mtpg), zOrder - 1);
                    ChecklistPanel.this.fireChangeEvent((Component)((Object)mtpg));
                    jtp.revalidate();
                    jtp.repaint();
                }
            });
        }
        return this.moveUpCheckGroupMenuItem;
    }

    private JMenuItem getMoveDownCheckGroupMenuItem() {
        if (this.moveDownCheckGroupMenuItem == null) {
            this.moveDownCheckGroupMenuItem = new JMenuItem();
            this.moveDownCheckGroupMenuItem.setText(I18n.text("Move Group Down"));
            this.moveDownCheckGroupMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem jmi = (JMenuItem)e.getSource();
                    JPopupMenu jpm = (JPopupMenu)jmi.getParent();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)jpm.getInvoker());
                    JXTaskPaneContainer jtp = (JXTaskPaneContainer)mtpg.getParent();
                    int zOrder = jtp.getComponentZOrder((Component)((Object)mtpg));
                    jtp.remove((Component)((Object)mtpg));
                    jtp.add((Component)((Object)mtpg), zOrder + 1);
                    ChecklistPanel.this.fireChangeEvent((Component)((Object)mtpg));
                    jtp.revalidate();
                    jtp.repaint();
                }
            });
        }
        return this.moveDownCheckGroupMenuItem;
    }

    private JMenuItem getInsertCheckItemMenuItem() {
        if (this.insertCheckItemMenuItem == null) {
            this.insertCheckItemMenuItem = new JMenuItem();
            this.insertCheckItemMenuItem.setText(I18n.text("Insert New Item Before"));
            this.insertCheckItemMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem jmi = (JMenuItem)e.getSource();
                    JPopupMenu jpm = (JPopupMenu)jmi.getParent();
                    CheckItemPanel cip = (CheckItemPanel)jpm.getInvoker();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)cip.getParentGroup());
                    ChecklistPanel.this.addNewCheckItemWorker(mtpg, true, cip);
                }
            });
        }
        return this.insertCheckItemMenuItem;
    }

    private JMenuItem getInsertCheckGroupMenuItem() {
        if (this.insertCheckGroupMenuItem == null) {
            this.insertCheckGroupMenuItem = new JMenuItem();
            this.insertCheckGroupMenuItem.setText(I18n.text("Insert New Group Before"));
            this.insertCheckGroupMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem jmi = (JMenuItem)e.getSource();
                    JPopupMenu jpm = (JPopupMenu)jmi.getParent();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)jpm.getInvoker());
                    ChecklistPanel.this.addNewChecklistGroupActionWorker(true, mtpg);
                }
            });
        }
        return this.insertCheckGroupMenuItem;
    }

    private JMenuItem getEditNameCheckItemMenuItem() {
        if (this.editNameCheckItemMenuItem == null) {
            this.editNameCheckItemMenuItem = new JMenuItem();
            this.editNameCheckItemMenuItem.setText(I18n.text("Edit Item Name"));
            this.editNameCheckItemMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem jmi = (JMenuItem)e.getSource();
                    JPopupMenu jpm = (JPopupMenu)jmi.getParent();
                    CheckItemPanel cip = (CheckItemPanel)jpm.getInvoker();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)cip.getParentGroup());
                    ChecklistPanel.this.editNameCheckItemActionWorker(cip, mtpg);
                }
            });
        }
        return this.editNameCheckItemMenuItem;
    }

    private boolean editNameCheckItemActionWorker(CheckItemPanel cip, MyJTaskPaneGroup mtpg) {
        String inputValue = JOptionPane.showInputDialog(this, I18n.textf("Please input a new name for \"%name\"", cip.getName()), cip.getName());
        if (inputValue != null && !inputValue.trim().equalsIgnoreCase("")) {
            boolean notUnique = this.checkForCheckItemExistence(inputValue, mtpg);
            if (notUnique) {
                JOptionPane.showMessageDialog(this, I18n.text("Item already exists!"));
                return false;
            }
            cip.setName(inputValue.trim());
            this.fireChangeEvent(cip);
            cip.revalidate();
            cip.repaint();
            return true;
        }
        return false;
    }

    private JMenuItem getEditDateCheckItemMenuItem() {
        if (this.editDateCheckItemMenuItem == null) {
            this.editDateCheckItemMenuItem = new JMenuItem();
            this.editDateCheckItemMenuItem.setEnabled(false);
            this.editDateCheckItemMenuItem.setText(I18n.text("Edit Item Check Date"));
        }
        return this.editDateCheckItemMenuItem;
    }

    private JMenuItem getUnCheckAllChecklistGroupsMenuItem() {
        if (this.unCheckAllChecklistGroupsMenuItem == null) {
            this.unCheckAllChecklistGroupsMenuItem = new JMenuItem();
            this.unCheckAllChecklistGroupsMenuItem.setText(I18n.text("Uncheck All Checklist"));
            this.unCheckAllChecklistGroupsMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component[] compJTaskPaneGroup;
                    for (Component comp : compJTaskPaneGroup = ChecklistPanel.this.getCheckTaskPane().getComponents()) {
                        MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)comp);
                        for (Component cp : mtpg.listCheckItemPanel) {
                            CheckItemPanel cip = (CheckItemPanel)cp;
                            cip.setChecked(false);
                        }
                    }
                }
            });
        }
        return this.unCheckAllChecklistGroupsMenuItem;
    }

    private JMenuItem getUnCheckAllGroupItemsMenuItem() {
        if (this.unCheckAllGroupItemsMenuItem == null) {
            this.unCheckAllGroupItemsMenuItem = new JMenuItem();
            this.unCheckAllGroupItemsMenuItem.setText(I18n.text("Uncheck All Group"));
            this.unCheckAllGroupItemsMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem jmi = (JMenuItem)e.getSource();
                    JPopupMenu jpm = (JPopupMenu)jmi.getParent();
                    MyJTaskPaneGroup mtpg = (MyJTaskPaneGroup)((Object)jpm.getInvoker());
                    for (Component cp : mtpg.listCheckItemPanel) {
                        CheckItemPanel cip = (CheckItemPanel)cp;
                        cip.setChecked(false);
                    }
                }
            });
        }
        return this.unCheckAllGroupItemsMenuItem;
    }

    private JPanel getEditPanel() {
        if (this.editPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.editPanel = new JPanel();
            this.editPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            this.editPanel.setLayout(flowLayout);
            this.editPanel.setSize(8, 8);
            this.editPanel.add((Component)this.getSelectedGroupLabel(), null);
            this.editPanel.add((Component)this.getAppendGroupButton(), null);
            this.editPanel.add((Component)this.getAppendItemButton(), null);
        }
        return this.editPanel;
    }

    private JLabel getSelectedGroupLabel() {
        if (this.selectedGroupLabel == null) {
            this.selectedGroupLabel = new JLabel();
            this.selectedGroupLabel.setForeground(BLUE_1.darker().darker().darker());
        }
        return this.selectedGroupLabel;
    }

    private JButton getAppendGroupButton() {
        if (this.appendGroupButton == null) {
            this.appendGroupButton = new JButton();
            this.appendGroupButton.setText(I18n.text("append group"));
            this.appendGroupButton.setToolTipText(I18n.text("Append group"));
            this.appendGroupButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChecklistPanel.this.addNewChecklistGroupActionWorker(false, null);
                }
            });
            this.appendGroupButton.setPreferredSize(new Dimension(113, 21));
            this.appendGroupButton.setBackground(BLUE_1);
        }
        return this.appendGroupButton;
    }

    private JButton getAppendItemButton() {
        if (this.appendItemButton == null) {
            this.appendItemButton = new JButton();
            this.appendItemButton.setText(I18n.text("append item"));
            this.appendItemButton.setToolTipText(I18n.text("Append item"));
            this.appendItemButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ChecklistPanel.this.getSelectedGroup() != null) {
                        ChecklistPanel.this.addNewCheckItemWorker(ChecklistPanel.this.getSelectedGroup(), false, null);
                    } else {
                        ChecklistPanel.this.getAppendItemButton().setEnabled(false);
                    }
                }
            });
            this.appendItemButton.setPreferredSize(new Dimension(113, 21));
            this.appendItemButton.setBackground(BLUE_1);
            this.appendItemButton.setEnabled(false);
            this.appendItemButton.setVisible(true);
        }
        return this.appendItemButton;
    }

    private void changeChecklist(ChecklistType clist) {
        this.checklist = clist;
        this.isFlat = this.checklist.isFlat();
        this.originalFilePath = this.checklist.getOriginalFilePath();
        if (this.originalFilePath.length() < 1) {
            this.setChanged(true);
        } else {
            this.setChanged(false);
        }
        this.nameText.setText(this.checklist.getName());
        this.versionText.setText(this.checklist.getVersion());
        this.getDescTextArea().setText(this.checklist.getDescription());
        this.checkTaskPane = null;
        this.getCheckTaskPaneScrollPane().setViewportView((Component)this.getCheckTaskPane());
        if (this.jFrame != null) {
            this.jFrame.setTitle("Checklist " + this.getName());
        }
        this.setChanged(false);
        this.getSaveButton().setEnabled(false);
    }

    public static JDialog getIPDialog(Window w) {
        final JDialog jd = new JDialog(w);
        jd.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        jd.setTitle(I18n.text("IP Port selection"));
        jd.setSize(200, 95);
        jd.setResizable(false);
        JLabel labelIP = new JLabel(I18n.text("IP"));
        labelIP.setHorizontalTextPosition(4);
        JLabel labelPort = new JLabel(I18n.text("Port"));
        labelPort.setHorizontalTextPosition(4);
        final JTextField textIP = new JTextField();
        textIP.setText(ip);
        final JFormattedTextField textPort = new JFormattedTextField(GuiUtils.getNeptusIntegerFormat());
        textPort.setValue(port);
        JButton buttonOK = new JButton();
        buttonOK.setText(I18n.text("OK"));
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ip = textIP.getText();
                port = ((Number)textPort.getValue()).intValue();
                jd.dispose();
            }
        });
        JPanel panelaux = new JPanel();
        panelaux.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2));
        panel.add(labelPort);
        panel.add(textPort);
        panelaux.add((Component)panel, "Center");
        panelaux.add((Component)buttonOK, "South");
        jd.setContentPane(panelaux);
        return jd;
    }

    private static Options getCommandLineOptions() {
        Options options = new Options();
        options.addOption("h", I18n.text("help"), false, I18n.text("this help"));
        OptionBuilder.withLongOpt((String)"checklist");
        OptionBuilder.withDescription((String)I18n.text("checklist file"));
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"f"));
        options.addOption("g", "generate-pdf", false, I18n.text("generate pdf and don't open the interface"));
        OptionBuilder.withLongOpt((String)"output-pdf");
        OptionBuilder.withDescription((String)I18n.text("output pdf file"));
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)"pdf-columns");
        OptionBuilder.withDescription((String)I18n.text("generate pdf with n column (1, 2, or 3) defaults to 1"));
        OptionBuilder.withArgName((String)"n");
        OptionBuilder.withValueSeparator((char)'=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"c"));
        return options;
    }

    private static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar neptus-check.jar", "Neptus Checklist v" + ConfigFetch.getVersionSimpleString() + "\nCopyright (c) 2004-2014 - Universidade do Porto - LSTS. All rights reserved.\n\n" + I18n.text("Options:") + "\n", options, I18n.textf("Report bugs to %email", "Paulo Dias <pdias@fe.up.pt>"), true);
    }

    public static void main(String ... args) {
        GeneralPreferences.initialize();
        try {
            PosixParser parser = new PosixParser();
            Options options = ChecklistPanel.getCommandLineOptions();
            CommandLine line = null;
            try {
                line = parser.parse(options, args);
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (line == null || line.hasOption("help")) {
                ChecklistPanel.printUsage(options);
                System.exit(0);
            }
            OutputMonitor.setDisable(true);
            NeptusLog.wasteRoot().setLevel(Level.OFF);
            NeptusLog.pubRoot().setLevel(Level.FATAL);
            ConfigFetch.initialize();
            if (ConfigFetch.isOSEqual((short)1)) {
                GuiUtils.setLookAndFeel();
            } else {
                GuiUtils.setSystemLookAndFeel();
            }
            ChecklistPanel clp = null;
            if (args.length < 1) {
                ChecklistType ck = new ChecklistType();
                ck.setName(I18n.text("New Checklist"));
                clp = ChecklistPanel.showChecklistPanel(I18n.text("New Checklist"), ck);
            } else {
                String path = null;
                String out = null;
                boolean genPDF = false;
                int columns = 1;
                if (line.hasOption("checklist")) {
                    path = line.getOptionValue("checklist");
                }
                if (line.hasOption("generate-pdf")) {
                    try {
                        genPDF = true;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!line.hasOption("checklist")) {
                        ChecklistPanel.printUsage(options);
                        System.exit(0);
                    }
                    if (line.hasOption("pdf-columns")) {
                        try {
                            columns = Integer.parseInt(line.getOptionValue("pdf-columns"));
                            columns = Math.min(Math.max(columns, 1), 3);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (line.hasOption("output-pdf")) {
                        try {
                            out = line.getOptionValue("output-pdf");
                        }
                        catch (Exception e) {
                            out = null;
                        }
                    }
                }
                File fx = new File(path);
                if (!genPDF) {
                    if (!fx.getAbsoluteFile().exists()) {
                        ChecklistType ck = new ChecklistType();
                        ck.setName(I18n.text("New Checklist"));
                        clp = ChecklistPanel.showChecklistPanel(I18n.text("New Checklist"), ck);
                    } else {
                        clp = ChecklistPanel.showChecklistPanel(fx.getAbsolutePath());
                    }
                } else {
                    if (!fx.getAbsoluteFile().exists()) {
                        NeptusLog.pub().info((Object)"Checklist file not found!");
                        System.exit(1);
                    }
                    try {
                        File pdfFx;
                        boolean ret;
                        ChecklistType checklist = new ChecklistType(fx.getAbsolutePath());
                        String pdfFileName = ChecklistPanel.createPDFFileName(fx.getName());
                        if (out != null) {
                            pdfFileName = out;
                            new File(pdfFileName).getParentFile().mkdirs();
                        }
                        System.exit((ret = GeneratorChecklistPDF.generateReport(checklist, pdfFx = new File(fx.getParent(), pdfFileName), (short)columns)) ? 0 : 1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
            }
            clp.setEditable(true);
            clp.jFrame.setIconImages(ConfigFetch.getIconImagesForFrames());
            clp.jFrame.setDefaultCloseOperation(3);
            clp.jFrame.setSize(790, 580);
            GuiUtils.centerOnScreen(clp.jFrame);
            clp.getCancelButton().setVisible(false);
            clp.getRunButton().setVisible(false);
            clp.getNewButton().setVisible(true);
            clp.getOpenButton().setVisible(true);
            clp.getOpenButton().requestFocusInWindow();
            clp.getEditPanel().add(new JLabel(" | \u00a9 From Neptus " + ConfigFetch.getVersionSimpleString()));
            clp.makeNameEditable();
            clp.iconifyToolButtons();
            clp.jFrame.setAlwaysOnTop(false);
        }
        catch (Error | Exception e) {
            e.printStackTrace();
        }
    }

    static {
        BLUE_1 = new Color(181, 198, 216);
        GREEN_1 = new Color(151, 206, 93);
        RED_1 = new Color(246, 198, 181);
        ORANGE_1 = new Color(230, 158, 35);
        ip = "127.0.0.1";
        port = 6001;
    }
}

