/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedHashMap;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.io.SAXReader;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;

class ChecklistPreview
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -1591236595011124495L;
    private File file = null;
    private JLabel id = new JLabel(" ");

    public ChecklistPreview(JFileChooser fc) {
        this.setPreferredSize(new Dimension(120, 120));
        this.setLayout(new BorderLayout());
        this.add((Component)this.id, "North");
        fc.addPropertyChangeListener(this);
    }

    private LinkedHashMap<String, String> loadHeader(File f) {
        final LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        final SAXReader reader = new SAXReader();
        reader.addHandler("/checklist", new ElementHandler(){

            public void onEnd(ElementPath arg0) {
            }

            public void onStart(ElementPath arg0) {
                Element elem = arg0.getElement(0);
                String nameStr = elem.attributeValue("name");
                header.put("name", nameStr);
                reader.removeHandler("/checklist");
            }
        });
        reader.addHandler("/checklist/description", new ElementHandler(){

            public void onEnd(ElementPath arg0) {
                header.put("description", arg0.getCurrent().getText());
                reader.removeHandler("/checklist/description");
            }

            public void onStart(ElementPath arg0) {
            }
        });
        try {
            reader.read(f);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
        return header;
    }

    public void loadFile() {
        if (this.file == null) {
            this.id.setText("");
            return;
        }
        try {
            if (this.file.exists()) {
                LinkedHashMap<String, String> header = this.loadHeader(this.file);
                if (header.values().size() != 2) {
                    this.id.setText("<html><font color='red'>" + I18n.text("Not a valid checklist") + "</font></html>");
                } else {
                    this.id.setText("<html><font color='blue'>" + I18n.text("Name") + ": </font>" + header.get("name") + "<hr><font color='blue'>" + I18n.text("Description") + ":</font><br>" + header.get("description") + "</html>");
                }
            } else {
                this.id.setText(" ");
            }
        }
        catch (Exception e) {
            this.id.setText("<html><font color='red'>" + I18n.text("Not a valid checklist") + "</font></html>");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("SelectedFileChangedProperty")) {
            this.file = (File)e.getNewValue();
            if (this.isShowing()) {
                this.loadFile();
                this.repaint();
            }
        }
    }
}

