/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.MultiColumnText;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.LinkedList;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import pt.lsts.neptus.gui.checklist.ChecklistPanel;
import pt.lsts.neptus.gui.checklist.PageEvents;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.checklist.CheckAutoSubItem;
import pt.lsts.neptus.types.checklist.CheckAutoUserActionItem;
import pt.lsts.neptus.types.checklist.CheckAutoUserLogItem;
import pt.lsts.neptus.types.checklist.CheckAutoVarIntervalItem;
import pt.lsts.neptus.types.checklist.CheckItem;
import pt.lsts.neptus.types.checklist.ChecklistType;
import pt.lsts.neptus.util.BarCodesUtil;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.SvgUtil;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class GeneratorChecklistPDF {
    protected static org.w3c.dom.Document logoDoc = null;

    public static org.w3c.dom.Document getLogoDoc() {
        if (logoDoc == null) {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
            String data = FileUtil.getFileAsString(FileUtil.getResourceAsFile("/images/neptus_logo_ns.svg"));
            try {
                logoDoc = f.createDocument(null, (Reader)new StringReader(data));
                logoDoc = SvgUtil.cleanInkscapeSVG(logoDoc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return logoDoc;
    }

    public static boolean generateReport(ChecklistType clist, File destination) {
        return GeneratorChecklistPDF.generateReport(clist, destination, (short)3);
    }

    public static boolean generateReport(ChecklistType clist, File destination, short columns) {
        columns = (short)Math.max(columns, 1);
        columns = (short)Math.min(columns, 3);
        Rectangle pageSize = PageSize.A4;
        try {
            FileOutputStream out = new FileOutputStream(destination);
            Document doc = new Document(pageSize);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)out);
            writer.setViewerPreferences(2);
            writer.setPageEvent((PdfPageEvent)new PageEvents(clist));
            doc.setMargins(54.0f, 54.0f, 54.0f, 54.0f);
            doc.open();
            doc.addTitle(I18n.textf("Checklist - %name", clist.getName()));
            doc.addCreationDate();
            doc.addCreator("Neptus " + ConfigFetch.getNeptusVersion());
            doc.addProducer();
            doc.addAuthor(System.getProperty("user.name"));
            Color BLUE_1 = new Color(31, 73, 125);
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            BaseFont bfz = BaseFont.createFont((String)"ZapfDingbats", (String)"Cp1252", (boolean)false);
            Font font14BoldBlue = new Font(bf, 14.0f, 1, BLUE_1);
            Font font10BoldBlue = new Font(bf, 10.0f, 1, BLUE_1);
            Font font9BoldBlue = new Font(bf, 9.0f, 1, BLUE_1);
            Font font8BoldDarkGray = new Font(bf, 8.0f, 1, Color.DARK_GRAY);
            Font font8NormalBlack = new Font(bf, 8.0f, 0, Color.BLACK);
            Font font8NormalGray = new Font(bf, 8.0f, 0, Color.GRAY);
            Font font8NormalLightGray = new Font(bf, 8.0f, 0, Color.LIGHT_GRAY.darker());
            Font font7 = new Font(bf, 7.0f, 0);
            Font fontZ14 = new Font(bfz, 14.0f, 0);
            Paragraph titleP = new Paragraph();
            titleP.setSpacingBefore(10.0f);
            titleP.setSpacingAfter(10.0f);
            Phrase title = new Phrase();
            title.setFont(font14BoldBlue);
            title.add((Object)clist.getName());
            title.add((Object)Chunk.NEWLINE);
            if (clist.getVersion() != null && !"".equalsIgnoreCase(clist.getVersion())) {
                title.setFont(font10BoldBlue);
                title.add((Object)I18n.textf("Version: %version", clist.getVersion()));
                title.add((Object)Chunk.NEWLINE);
            }
            String text = clist.getName() + " | " + I18n.textf("Version: %version", clist.getVersion()) + " | " + I18n.textf("By: %info", System.getProperty("user.name") + " | " + "@" + DateTimeUtil.dateTimeFormater.format(new Date(System.currentTimeMillis())) + " | " + ConfigFetch.getVersionSimpleString());
            BufferedImage imgB = BarCodesUtil.createQRCodeImage(text, 50, 50);
            Image img = Image.getInstance((java.awt.Image)imgB, null);
            titleP.add((Object)img);
            titleP.add((Object)title);
            doc.add((Element)titleP);
            if (clist.getDescription() != null && !clist.getDescription().isEmpty()) {
                Paragraph descP = new Paragraph();
                descP.setSpacingBefore(10.0f);
                descP.setSpacingAfter(5.0f);
                descP.setAlignment(3);
                Phrase desc = new Phrase();
                desc.setFont(font10BoldBlue);
                desc.add((Object)I18n.text("Description:"));
                desc.add((Object)Chunk.NEWLINE);
                descP.add((Object)desc);
                doc.add((Element)descP);
                Paragraph descP2 = new Paragraph();
                descP2.setSpacingBefore(0.0f);
                descP2.setSpacingAfter(10.0f);
                descP2.setAlignment(3);
                descP2.setLeading(11.0f);
                Phrase descText = new Phrase();
                descText.setFont(font8NormalGray);
                descText.add((Object)clist.getDescription().replaceAll("\n\n", "\n"));
                descText.add((Object)Chunk.NEWLINE);
                descP2.add((Object)descText);
                doc.add((Element)descP2);
            }
            MultiColumnText mct = new MultiColumnText();
            mct.addRegularColumns(doc.left(), doc.right(), 10.0f, (int)columns);
            for (String grpName : clist.getGroupList().keySet()) {
                if (!clist.isFlat()) {
                    Paragraph grpP = new Paragraph();
                    grpP.setSpacingBefore(8.0f);
                    Phrase grpText = new Phrase();
                    grpText.setFont(font9BoldBlue);
                    grpText.add((Object)grpName);
                    grpText.add((Object)Chunk.NEWLINE);
                    grpP.add((Object)grpText);
                    mct.addElement((Element)grpP);
                }
                LinkedList<CheckItem> gplist = clist.getGroupList().get(grpName);
                for (CheckItem ci : gplist) {
                    Paragraph ciP = new Paragraph();
                    ciP.setLeading(15.0f);
                    Phrase ciText = new Phrase();
                    Chunk cv = ci.isSkiped() ? new Chunk('n') : (ci.isChecked() ? new Chunk('4') : new Chunk('o'));
                    fontZ14.setColor(Color.DARK_GRAY);
                    ciText.setFont(fontZ14);
                    ciText.add((Object)cv);
                    ciText.setFont(font8NormalBlack);
                    ciText.add((Object)" ");
                    ciText.add((Object)ci.getName());
                    ciP.add((Object)ciText);
                    if (ci.isChecked() && !ci.isSkiped()) {
                        Phrase dateF = new Phrase(8.0f);
                        font7.setColor(Color.GRAY);
                        dateF.setFont(font7);
                        if (columns > 2) {
                            dateF.add((Object)Chunk.NEWLINE);
                        }
                        dateF.add((Object)(" (" + ci.getDateChecked() + ")"));
                        ciP.add((Object)dateF);
                    }
                    ciP.add((Object)Chunk.NEWLINE);
                    mct.addElement((Element)ciP);
                    if (!"".equalsIgnoreCase(ci.getNote())) {
                        Paragraph noteP = new Paragraph();
                        noteP.setSpacingBefore(3.0f);
                        noteP.setIndentationLeft(10.0f);
                        noteP.setAlignment(3);
                        noteP.setLeading(9.0f);
                        Phrase noteF = new Phrase();
                        noteF.setFont(font8BoldDarkGray);
                        noteF.add((Object)(I18n.text("Note:") + " "));
                        noteF.setFont(font8NormalLightGray);
                        noteF.add((Object)ci.getNote().replaceAll("\n\n", "\n"));
                        noteP.add((Object)noteF);
                        mct.addElement((Element)noteP);
                    }
                    if (ci.getAutoSubItems().isEmpty()) continue;
                    PdfPTable table = new PdfPTable(1);
                    for (CheckAutoSubItem si : ci.getAutoSubItems()) {
                        PdfPCell uaCell;
                        Phrase uaF;
                        CheckAutoSubItem it;
                        if ("userAction".equals(si.getSubItemType())) {
                            it = (CheckAutoUserActionItem)si;
                            uaF = new Phrase();
                            uaF.setFont(font8BoldDarkGray);
                            uaF.add((Object)(I18n.text("Action:") + " "));
                            uaF.setFont(font8NormalLightGray);
                            uaF.add((Object)((CheckAutoUserActionItem)it).getAction());
                            uaCell = new PdfPCell((Phrase)new Paragraph(uaF));
                            uaCell.setBorderWidthLeft(6.0f);
                            uaCell.setBorderWidthBottom(0.0f);
                            uaCell.setBorderWidthRight(0.0f);
                            uaCell.setBorderWidthTop(0.0f);
                            if (!ci.isSkiped()) {
                                if (it.isChecked()) {
                                    uaCell.setBorderColorLeft(ChecklistPanel.BLUE_1);
                                } else {
                                    uaCell.setBorderColorLeft(ChecklistPanel.RED_1);
                                }
                            }
                            table.addCell(uaCell);
                            continue;
                        }
                        if ("userLog".equals(si.getSubItemType())) {
                            it = (CheckAutoUserLogItem)si;
                            uaF = new Phrase();
                            uaF.setFont(font8BoldDarkGray);
                            uaF.add((Object)(((CheckAutoUserLogItem)it).getLogRequest() + ": "));
                            uaF.setFont(font8NormalLightGray);
                            uaF.add((Object)((CheckAutoUserLogItem)it).getLogMessage());
                            uaCell = new PdfPCell((Phrase)new Paragraph(uaF));
                            uaCell.setBorderWidthLeft(6.0f);
                            uaCell.setBorderWidthBottom(0.0f);
                            uaCell.setBorderWidthRight(0.0f);
                            uaCell.setBorderWidthTop(0.0f);
                            if (!ci.isSkiped()) {
                                if (it.isChecked()) {
                                    uaCell.setBorderColorLeft(ChecklistPanel.BLUE_1);
                                } else {
                                    uaCell.setBorderColorLeft(ChecklistPanel.RED_1);
                                }
                            }
                            table.addCell(uaCell);
                            continue;
                        }
                        if (!"variableTestRange".equals(si.getSubItemType())) continue;
                        it = (CheckAutoVarIntervalItem)si;
                        uaF = new Phrase();
                        uaF.setFont(font8BoldDarkGray);
                        uaF.add((Object)(((CheckAutoVarIntervalItem)it).getVarName() + "="));
                        uaF.setFont(font8NormalLightGray);
                        uaF.add((Object)("" + ((CheckAutoVarIntervalItem)it).getVarValue()));
                        uaCell = new PdfPCell((Phrase)new Paragraph(uaF));
                        uaCell.setBorderWidthLeft(6.0f);
                        uaCell.setBorderWidthBottom(0.0f);
                        uaCell.setBorderWidthRight(0.0f);
                        uaCell.setBorderWidthTop(0.0f);
                        if (!ci.isSkiped()) {
                            if (it.isChecked()) {
                                uaCell.setBorderColorLeft(ChecklistPanel.BLUE_1);
                            } else {
                                uaCell.setBorderColorLeft(ChecklistPanel.RED_1);
                            }
                        }
                        table.addCell(uaCell);
                    }
                    table.setWidthPercentage(95.0f);
                    table.setHorizontalAlignment(2);
                    table.setSpacingBefore(8.0f);
                    table.setSpacingAfter(8.0f);
                    mct.addElement((Element)table);
                }
            }
            doc.add((Element)mct);
            doc.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            GuiUtils.errorMessage(I18n.text("Error generating report"), e.getMessage());
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        ConfigFetch.initialize();
        GeneratorChecklistPDF.generateReport(new ChecklistType("checklists/check3.nchk"), new File("checklists/check2_test.pdf"));
        GeneratorChecklistPDF.generateReport(new ChecklistType("checklists/check4.nchk"), new File("checklists/check2_test1.pdf"));
    }
}

