/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import pt.lsts.neptus.gui.checklist.CheckItemPanel;
import pt.lsts.neptus.gui.checklist.ChecklistPanel;

class MyJTaskPaneGroup
extends JXTaskPane
implements PropertyChangeListener {
    private static final long serialVersionUID = -770514691508885176L;
    public static final String CHILD_ITEM_CHECKED_PROPERTY = "child item checked change";
    public static final String INFO_SEPARATOR = "  \u00a0 (";
    public LinkedList<Component> listCheckItemPanel = new LinkedList();

    public MyJTaskPaneGroup() {
        this.addPropertyChangeListener(this);
    }

    public String getGroupName() {
        String ret = this.getTitle();
        int index = ret.lastIndexOf(INFO_SEPARATOR);
        if (index != -1) {
            ret = ret.substring(0, index);
        }
        return ret;
    }

    public void setGroupName(String groupName) {
        this.setTitle(groupName);
        this.fixTitle();
    }

    private void fixTitle() {
        int[] ret = this.computeItemsTotalAndChecked();
        this.setTitle(this.getGroupName() + INFO_SEPARATOR + ret[1] + "/" + ret[0] + ")");
    }

    public Component add(Component arg0) {
        this.listCheckItemPanel.add(arg0);
        Component addComp = super.add(arg0);
        this.fixIcon();
        return addComp;
    }

    public Component add(Component arg0, int arg1) {
        this.listCheckItemPanel.add(arg1, arg0);
        Component addComp = super.add(arg0, arg1);
        this.fixIcon();
        return addComp;
    }

    public void remove(Component arg0) {
        this.listCheckItemPanel.remove(arg0);
        super.remove(arg0);
        this.fixIcon();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof MyJTaskPaneGroup) {
            MyJTaskPaneGroup comp = (MyJTaskPaneGroup)arg0;
            return this.getGroupName().equals(comp.getGroupName());
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("user change")) {
            boolean newValue = (Boolean)e.getNewValue();
            ((JXTaskPaneContainer)this.getParent()).firePropertyChange("user change", !newValue, newValue);
        } else if (prop.equals(CHILD_ITEM_CHECKED_PROPERTY)) {
            boolean newValue = (Boolean)e.getNewValue();
            if (newValue) {
                this.fixIcon();
            } else {
                this.setIcon(ChecklistPanel.NOT_OK_IMAGE_ICON);
                this.fixTitle();
                this.revalidate();
                this.repaint();
            }
        }
    }

    public void fixIcon() {
        boolean result = this.computeItemsLogicalAND();
        if (result) {
            this.setIcon(ChecklistPanel.OK_IMAGE_ICON);
        } else {
            this.setIcon(ChecklistPanel.NOT_OK_IMAGE_ICON);
        }
        this.fixTitle();
        this.revalidate();
        this.repaint();
    }

    public boolean computeItemsLogicalAND() {
        Component cp;
        CheckItemPanel cip;
        Component[] comps = this.getContentPane().getComponents();
        boolean logAnd = true;
        Component[] arr$ = comps;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (logAnd &= (cip = (CheckItemPanel)(cp = arr$[i$])).isChecked()); ++i$) {
        }
        return logAnd;
    }

    public int[] computeItemsTotalAndChecked() {
        Component[] comps = this.getContentPane().getComponents();
        int count = 0;
        int checked = 0;
        for (Component cp : comps) {
            CheckItemPanel cip = (CheckItemPanel)cp;
            ++count;
            if (!cip.isChecked()) continue;
            ++checked;
        }
        return new int[]{count, checked};
    }
}

