/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist;

import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.util.Date;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.checklist.ChecklistType;
import pt.lsts.neptus.util.DateTimeUtil;

class PageEvents
extends PdfPageEventHelper {
    protected ChecklistType clist = null;
    protected PdfTemplate total;
    protected BaseFont helv;

    public PageEvents(ChecklistType clist) {
        this.clist = clist;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.total = writer.getDirectContent().createTemplate(100.0f, 100.0f);
        this.total.setBoundingBox(new Rectangle(-20.0f, -20.0f, 100.0f, 100.0f));
        try {
            this.helv = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void onEndPage(PdfWriter writer, Document document) {
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        cb.setColorFill(Color.gray);
        String text = I18n.text("Document generated by") + " Neptus ";
        float textBase = document.bottom() - 20.0f;
        float textSize = this.helv.getWidthPoint(text, 8.0f);
        cb.beginText();
        cb.setFontAndSize(this.helv, 8.0f);
        cb.setTextMatrix(document.left(), textBase);
        cb.showText(text);
        cb.endText();
        cb.addTemplate(this.total, document.left() + textSize, textBase);
        text = "" + writer.getPageNumber();
        textSize = this.helv.getWidthPoint(text, 8.0f);
        cb.beginText();
        float adjust = this.helv.getWidthPoint("0", 8.0f);
        cb.setTextMatrix(document.right() - textSize - adjust, textBase);
        cb.showText(text);
        cb.endText();
        cb.addTemplate(this.total, document.right() - adjust, textBase);
        text = this.clist != null ? this.clist.getName() : "";
        textBase = document.top() + 20.0f;
        textSize = this.helv.getWidthPoint(text, 8.0f);
        cb.beginText();
        cb.setFontAndSize(this.helv, 8.0f);
        cb.setTextMatrix(document.left(), textBase);
        cb.showText(text);
        cb.endText();
        cb.addTemplate(this.total, document.left() + textSize, textBase);
        text = "" + DateTimeUtil.dateTimeFormaterNoSegs.format(new Date());
        textBase = document.top() + 20.0f;
        textSize = this.helv.getWidthPoint(text, 8.0f);
        cb.beginText();
        cb.setFontAndSize(this.helv, 8.0f);
        cb.setTextMatrix(document.right() - textSize, textBase);
        cb.showText(text);
        cb.endText();
        cb.addTemplate(this.total, document.right(), textBase);
        cb.setColorStroke(Color.GRAY);
        cb.setLineWidth(1.0f);
        cb.moveTo(document.left(), document.top() + 20.0f - 2.0f);
        cb.lineTo(document.right(), document.top() + 20.0f - 2.0f);
        cb.stroke();
        cb.setColorStroke(Color.GRAY);
        cb.setLineWidth(1.0f);
        cb.moveTo(document.left(), document.bottom() - 20.0f + 10.0f);
        cb.lineTo(document.right(), document.bottom() - 20.0f + 10.0f);
        cb.stroke();
        cb.restoreState();
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
    }
}

