/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pt.lsts.neptus.gui.checklist.AutoItemsList;
import pt.lsts.neptus.gui.checklist.CheckSubItem;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.checklist.CheckAutoSubItem;
import pt.lsts.neptus.types.checklist.CheckAutoUserActionItem;

public class UserActionItem
extends JPanel
implements CheckSubItem {
    public static final String TYPE_ID = "userAction";
    private AutoItemsList parent = null;
    private JTextField userMsgActionText = null;
    private JButton remove = null;
    private JCheckBox check = null;

    public UserActionItem(AutoItemsList p, CheckAutoUserActionItem cauai) {
        this(p);
        this.fillFromCheckAutoUserActionItem(cauai);
    }

    public UserActionItem(AutoItemsList p) {
        this.parent = p;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.userMsgActionText = new JTextField();
        this.userMsgActionText.setColumns(20);
        this.userMsgActionText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                UserActionItem.this.parent.fireChangeEvent(UserActionItem.this);
            }
        });
        this.add(new JLabel(I18n.text("User Action:")));
        this.add(this.userMsgActionText);
        this.remove = new JButton(ICON_CLOSE);
        this.remove.setMargin(new Insets(0, 0, 0, 0));
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserActionItem.this.parent.removeUserActionItem(UserActionItem.this);
            }
        });
        this.add(new JLabel(" " + I18n.text("Checked:")));
        this.add(this.getCheck());
        this.add(this.remove);
    }

    private JCheckBox getCheck() {
        if (this.check == null) {
            this.check = new JCheckBox("check");
            this.check.setOpaque(false);
            this.check.setText(" ");
            this.check.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    UserActionItem.this.parent.fireChangeEvent(UserActionItem.this);
                }
            });
        }
        return this.check;
    }

    private void fillFromCheckAutoUserActionItem(CheckAutoUserActionItem cauai) {
        this.check.setSelected(cauai.isChecked());
        this.userMsgActionText.setText(cauai.getAction());
    }

    @Override
    public CheckAutoSubItem getCheckAutoSubItem() {
        CheckAutoUserActionItem ret = new CheckAutoUserActionItem();
        ret.setAction(this.userMsgActionText.getText());
        ret.setChecked(this.getCheck().isSelected());
        return ret;
    }
}

