/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pt.lsts.neptus.gui.checklist.AutoItemsList;
import pt.lsts.neptus.gui.checklist.CheckSubItem;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.checklist.CheckAutoSubItem;
import pt.lsts.neptus.types.checklist.CheckAutoUserLogItem;

public class UserCommentItem
extends JPanel
implements CheckSubItem {
    private static final long serialVersionUID = 4053699765892712805L;
    public static final String TYPE_ID = "userLog";
    private AutoItemsList parent = null;
    private JTextField logRequest = null;
    private JTextField logMessage = null;
    private JButton remove = null;
    private JCheckBox check = null;

    public UserCommentItem(AutoItemsList p, CheckAutoUserLogItem cauli) {
        this(p);
        this.fillFromCheckAutoUserLogItem(cauli);
    }

    public UserCommentItem(AutoItemsList p) {
        this.parent = p;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.logRequest = new JTextField();
        this.logRequest.setColumns(20);
        this.logRequest.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                UserCommentItem.this.parent.fireChangeEvent(UserCommentItem.this);
            }
        });
        this.add(new JLabel(I18n.text("User Comment:") + " "));
        this.add(this.logRequest);
        this.logMessage = new JTextField();
        this.logMessage.setColumns(20);
        this.logMessage.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                UserCommentItem.this.parent.fireChangeEvent(UserCommentItem.this);
            }
        });
        this.add(new JLabel(" " + I18n.text("Comment:") + " "));
        this.add(this.logMessage);
        this.remove = new JButton(ICON_CLOSE);
        this.remove.setMargin(new Insets(0, 0, 0, 0));
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserCommentItem.this.parent.removeUserCommentItem(UserCommentItem.this);
            }
        });
        this.add(new JLabel(" " + I18n.text("Checked:")));
        this.add(this.getCheck());
        this.add(this.remove);
    }

    private JCheckBox getCheck() {
        if (this.check == null) {
            this.check = new JCheckBox("check");
            this.check.setOpaque(false);
            this.check.setText(" ");
            this.check.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    UserCommentItem.this.parent.fireChangeEvent(UserCommentItem.this);
                }
            });
        }
        return this.check;
    }

    private void fillFromCheckAutoUserLogItem(CheckAutoUserLogItem cauli) {
        this.check.setSelected(cauli.isChecked());
        this.logRequest.setText(cauli.getLogRequest());
        this.logMessage.setText(cauli.getLogMessage());
    }

    @Override
    public CheckAutoSubItem getCheckAutoSubItem() {
        CheckAutoUserLogItem ret = new CheckAutoUserLogItem();
        ret.setChecked(this.getCheck().isSelected());
        ret.setLogMessage(this.logMessage.getText());
        ret.setLogRequest(this.logRequest.getText());
        return ret;
    }
}

