/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pt.lsts.neptus.gui.checklist.AutoItemsList;
import pt.lsts.neptus.gui.checklist.CheckSubItem;
import pt.lsts.neptus.types.checklist.CheckAutoSubItem;
import pt.lsts.neptus.types.checklist.CheckAutoVarIntervalItem;
import pt.lsts.neptus.util.GuiUtils;

public class VariableIntervalItem
extends JPanel
implements CheckSubItem {
    public static final String TYPE_ID = "variableTestRange";
    private JTextField variableName = null;
    private JTextField variablePath = null;
    private JFormattedTextField lastValue = null;
    private JFormattedTextField startInterval = null;
    private JFormattedTextField endInterval = null;
    private JCheckBox outInterval = null;
    private JCheckBox check = null;
    private JButton remove = null;
    private JLabel startInc = null;
    private JLabel endInc = null;
    private AutoItemsList parent = null;

    public VariableIntervalItem(AutoItemsList p, CheckAutoVarIntervalItem cavii) {
        this(p);
        this.fillFromCheckAutoVarIntervalItem(cavii);
    }

    public VariableIntervalItem(AutoItemsList p) {
        this.parent = p;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.variableName = new JTextField();
        this.variableName.setColumns(10);
        this.variableName.setSize(100, 20);
        this.variableName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VariableIntervalItem.this.parent.fireChangeEvent(VariableIntervalItem.this);
            }
        });
        this.variablePath = new JTextField();
        this.variablePath.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VariableIntervalItem.this.parent.fireChangeEvent(VariableIntervalItem.this);
            }
        });
        this.lastValue = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat());
        this.lastValue.setColumns(3);
        this.lastValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VariableIntervalItem.this.parent.fireChangeEvent(VariableIntervalItem.this);
            }
        });
        this.startInterval = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat());
        this.startInterval.setColumns(3);
        this.startInterval.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VariableIntervalItem.this.parent.fireChangeEvent(VariableIntervalItem.this);
            }
        });
        this.endInterval = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat());
        this.endInterval.setColumns(3);
        this.endInterval.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VariableIntervalItem.this.parent.fireChangeEvent(VariableIntervalItem.this);
            }
        });
        this.outInterval = new JCheckBox();
        this.outInterval.setOpaque(false);
        this.outInterval.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VariableIntervalItem.this.parent.fireChangeEvent(VariableIntervalItem.this);
            }
        });
        this.remove = new JButton(ICON_CLOSE);
        this.remove.setMargin(new Insets(0, 0, 0, 0));
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableIntervalItem.this.parent.removeVarIntervalItem(VariableIntervalItem.this);
            }
        });
        this.add(new JLabel("Variable Description:"));
        this.add(this.variableName);
        this.add(new JLabel(" Path:"));
        this.add(this.variablePath);
        this.add(new JLabel("  Interval:"));
        this.add(this.getStartInc());
        this.add(this.startInterval);
        this.add(new JLabel(";"));
        this.add(this.endInterval);
        this.add(this.getEndInc());
        this.add(new JLabel("  (Not in"));
        this.add(this.outInterval);
        this.add(new JLabel(") Registered Value"));
        this.add(this.lastValue);
        this.add(Box.createHorizontalGlue());
        this.add(new JLabel(" Checked:"));
        this.add(this.getCheck());
        this.add(this.remove);
    }

    private JLabel getStartInc() {
        if (this.startInc == null) {
            this.startInc = new JLabel("[");
            this.startInc.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    VariableIntervalItem.this.setStartInclusion(!VariableIntervalItem.this.isStartInclusion());
                    VariableIntervalItem.this.parent.fireChangeEvent(VariableIntervalItem.this);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
        }
        return this.startInc;
    }

    private JLabel getEndInc() {
        if (this.endInc == null) {
            this.endInc = new JLabel("]");
            this.endInc.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    VariableIntervalItem.this.setEndInclusion(!VariableIntervalItem.this.isEndInclusion());
                    VariableIntervalItem.this.parent.fireChangeEvent(VariableIntervalItem.this);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
        }
        return this.endInc;
    }

    public boolean isStartInclusion() {
        return this.startInc.getText().equals("[");
    }

    public void setStartInclusion(boolean startInclusion) {
        if (startInclusion) {
            this.startInc.setText("[");
        } else {
            this.startInc.setText("]");
        }
    }

    public boolean isEndInclusion() {
        return this.endInc.getText().equals("]");
    }

    public void setEndInclusion(boolean endInclusion) {
        if (endInclusion) {
            this.endInc.setText("]");
        } else {
            this.endInc.setText("[");
        }
    }

    private JCheckBox getCheck() {
        if (this.check == null) {
            this.check = new JCheckBox("check");
            this.check.setOpaque(false);
            this.check.setText(" ");
            this.check.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    VariableIntervalItem.this.parent.fireChangeEvent(VariableIntervalItem.this);
                }
            });
        }
        return this.check;
    }

    public double getRegisteredValue() {
        if (this.lastValue.getValue() == null || this.lastValue.getValue().toString().equals("")) {
            return Double.NaN;
        }
        return ((Number)this.lastValue.getValue()).doubleValue();
    }

    public double getStartInterval() {
        if (this.endInterval.getValue() == null || this.startInterval.getValue().toString().equals("")) {
            return Double.NEGATIVE_INFINITY;
        }
        return ((Number)this.startInterval.getValue()).doubleValue();
    }

    public double getEndInterval() {
        if (this.endInterval.getValue() == null || this.endInterval.getValue().toString().equals("")) {
            return Double.POSITIVE_INFINITY;
        }
        return ((Number)this.endInterval.getValue()).doubleValue();
    }

    public String getVariableName() {
        return this.variableName.getText();
    }

    public String getVariablePath() {
        return this.variablePath.getText();
    }

    public boolean isOutInterval() {
        return this.outInterval.isSelected();
    }

    public boolean isChecked() {
        return this.check.isSelected();
    }

    private void fillFromCheckAutoVarIntervalItem(CheckAutoVarIntervalItem cavii) {
        this.variableName.setText(cavii.getVarName());
        this.variablePath.setText(cavii.getVarPath());
        this.startInterval.setValue(cavii.getStartInterval());
        this.endInterval.setValue(cavii.getEndInterval());
        this.outInterval.setSelected(cavii.isOutInterval());
        this.check.setSelected(cavii.isChecked());
        this.lastValue.setValue(cavii.getVarValue());
        this.setStartInclusion(cavii.isStartInclusion());
        this.setEndInclusion(cavii.isEndInclusion());
    }

    @Override
    public CheckAutoSubItem getCheckAutoSubItem() {
        CheckAutoVarIntervalItem ret = new CheckAutoVarIntervalItem();
        ret.setEndInterval(this.getEndInterval());
        ret.setStartInterval(this.getStartInterval());
        ret.setVarName(this.getVariableName());
        ret.setVarPath(this.getVariablePath());
        ret.setOutInterval(this.isOutInterval());
        ret.setChecked(this.isChecked());
        ret.setVarValue(this.getRegisteredValue());
        ret.setStartInclusion(this.isStartInclusion());
        ret.setEndInclusion(this.isEndInclusion());
        return ret;
    }
}

