/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist.exec;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import pt.lsts.neptus.gui.checklist.CheckItemPanel;
import pt.lsts.neptus.gui.checklist.exec.CheckSubItemExe;
import pt.lsts.neptus.types.checklist.CheckAutoUserActionItem;
import pt.lsts.neptus.util.ImageUtils;

public class CheckActionItem
extends CheckSubItemExe {
    private static final long serialVersionUID = 1L;
    private CheckAutoUserActionItem checkSubItem;
    private JTextArea actionTextArea = null;
    private JCheckBox check = null;
    private Color bg = null;

    public CheckActionItem(CheckAutoUserActionItem casi) {
        this.checkSubItem = casi;
        this.initialize();
    }

    private void initialize() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setMaximumSize(new Dimension(2000, 80));
        this.setMinimumSize(new Dimension(0, 80));
        this.setLayout(new BorderLayout());
        this.bg = this.getBackground();
        if (this.checkSubItem.isChecked()) {
            this.setBackground(CheckItemPanel.CHECK_COLOR);
        }
        this.add((Component)this.getActionTextArea(), "Center");
        this.add((Component)this.getCheck(), "East");
    }

    private JTextArea getActionTextArea() {
        if (this.actionTextArea == null) {
            this.actionTextArea = new JTextArea();
            this.actionTextArea.setLineWrap(true);
            this.actionTextArea.setEditable(false);
            this.actionTextArea.setOpaque(false);
            this.actionTextArea.setText(this.checkSubItem.getAction());
        }
        return this.actionTextArea;
    }

    private JCheckBox getCheck() {
        if (this.check == null) {
            this.check = new JCheckBox();
            this.check.setOpaque(false);
            this.check.setSelected(this.checkSubItem.isChecked());
            this.check.setMargin(new Insets(2, 20, 2, 20));
            this.check.setIcon(ImageUtils.getIcon("images/checklists/boxIcon.png"));
            this.check.setSelectedIcon(ImageUtils.getIcon("images/checklists/selectedIcon.png"));
            this.check.setDisabledIcon(ImageUtils.getIcon("images/checklists/disabledIcon.png"));
            this.check.setDisabledSelectedIcon(ImageUtils.getIcon("images/checklists/disabledSelectedIcon.png"));
            this.check.setPressedIcon(ImageUtils.getIcon("images/checklists/disabledIcon.png"));
            this.check.setRolloverIcon(ImageUtils.getIcon("images/checklists/boxIcon.png"));
            this.check.setRolloverSelectedIcon(ImageUtils.getIcon("images/checklists/selectedIcon.png"));
            this.check.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CheckActionItem.this.checkSubItem.setChecked(CheckActionItem.this.check.isSelected());
                    if (CheckActionItem.this.check.isSelected()) {
                        CheckActionItem.this.setBackground(CheckItemPanel.CHECK_COLOR);
                    } else {
                        CheckActionItem.this.setBackground(CheckActionItem.this.bg);
                    }
                    CheckActionItem.this.warnCheckSubItemProviders();
                }
            });
        }
        return this.check;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isCheck() {
        return this.checkSubItem.isChecked();
    }
}

