/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist.exec;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.ChronometerPanel;
import pt.lsts.neptus.gui.checklist.CheckItemPanel;
import pt.lsts.neptus.gui.checklist.GeneratorChecklistPDF;
import pt.lsts.neptus.gui.checklist.exec.CheckActionItem;
import pt.lsts.neptus.gui.checklist.exec.CheckLogItem;
import pt.lsts.neptus.gui.checklist.exec.CheckSubItemExe;
import pt.lsts.neptus.gui.checklist.exec.CheckSubItemProvider;
import pt.lsts.neptus.gui.checklist.exec.CheckVariableItem;
import pt.lsts.neptus.gui.swing.JRoundButton;
import pt.lsts.neptus.types.checklist.CheckAutoSubItem;
import pt.lsts.neptus.types.checklist.CheckAutoUserActionItem;
import pt.lsts.neptus.types.checklist.CheckAutoUserLogItem;
import pt.lsts.neptus.types.checklist.CheckAutoVarIntervalItem;
import pt.lsts.neptus.types.checklist.CheckItem;
import pt.lsts.neptus.types.checklist.ChecklistType;
import pt.lsts.neptus.util.DateTimeUtil;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class CheckListExe
extends JDialog
implements CheckSubItemProvider {
    private static final long serialVersionUID = 2800023006457068275L;
    private ChecklistType checklist = null;
    private JPanel top = null;
    private JButton showDescription = null;
    private JPanel textPanelDescription = null;
    private JDialog messagesFrame = null;
    private JTextPane msgTextArea = null;
    private JLabel currentGroupTitle = null;
    private JButton skipGroup = null;
    private JPanel itemTitlePanel = null;
    private JTextArea currentItemText = null;
    private JLabel currentItemTitle = null;
    private JScrollPane jScrollPane = null;
    private JRoundButton skipItem = null;
    private JRoundButton forceRetreatItem = null;
    private JRoundButton forceAdvanceItem = null;
    private ChronometerPanel chronometer = null;
    private boolean checkFlag = true;
    private JPanel endPanel = null;
    private JPanel listSubItems = null;
    private JScrollPane listSubScroll = null;
    private JPanel jPanel = null;
    private int currentItem = 0;
    private int currentGroup = 0;
    private String workingDir = null;
    private String system = null;
    long initItemTime;
    private Vector<CheckSubItemExe> autoSubItems = new Vector();

    public CheckListExe(String system, ChecklistType ct, Window w, String wd) {
        super(w);
        this.system = system;
        this.checklist = ct;
        this.workingDir = wd;
        this.initialize();
        this.repaintCheck();
        if (this.getCurrentItem() != null) {
            if (!this.getCurrentItem().isChecked()) {
                this.loadCurrent();
            } else {
                this.advance();
            }
        }
    }

    private void initialize() {
        this.setTitle("Running :" + this.checklist.getName());
        this.setIconImage(ImageUtils.getImage("images/buttons/checklist.png"));
        this.createDescriptionFrame();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                CheckListExe.this.closeCurrentItem();
                CheckListExe.this.dispose();
            }
        });
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.getTop(), "North");
        contentPane.add((Component)this.getJPanel(), "Center");
        this.chronometer = new ChronometerPanel();
        this.chronometer.hideButtons();
        this.chronometer.start();
        this.chronometer.setPreferredSize(new Dimension(100, 20));
        contentPane.add((Component)this.chronometer, "South");
        this.setContentPane(contentPane);
    }

    private JPanel getTop() {
        if (this.top == null) {
            this.top = new JPanel();
            this.top.setLayout(new BorderLayout());
            this.showDescription = new JButton(new ImageIcon(ImageUtils.getScaledImage("images/buttons/info.png", 16, 16)));
            this.showDescription.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiUtils.centerParent(CheckListExe.this.messagesFrame, CheckListExe.this);
                    CheckListExe.this.messagesFrame.setVisible(true);
                }
            });
            this.top.add((Component)this.showDescription, "West");
            this.skipGroup = new JButton(new ImageIcon(ImageUtils.getScaledImage("images/buttons/forward.png", 16, 16)));
            this.skipGroup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CheckListExe.this.skipGroup();
                }
            });
            this.skipGroup.setToolTipText("Skip Group");
            this.skipGroup.setText("Skip Group");
            this.top.add((Component)this.skipGroup, "East");
            JPanel aux = new JPanel(new BorderLayout());
            aux.add((Component)new JLabel("  Group : "), "West");
            aux.add((Component)this.getCurrentGroupTitle(), "Center");
            this.top.add((Component)aux, "Center");
            this.top.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.top.setMaximumSize(new Dimension(2000, 50));
        }
        if (this.checklist.isFlat()) {
            this.currentGroupTitle.setText("Flat Checklist (no groups)");
            this.skipGroup.setEnabled(false);
        } else {
            this.currentGroupTitle.setText((String)this.checklist.getGroupList().keySet().toArray()[this.currentGroup]);
        }
        this.currentGroupTitle.setFont(new Font("Arial", 1, 20));
        return this.top;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setOpaque(false);
            this.jPanel.add((Component)this.getCurrentItemTitle(), "North");
            this.jPanel.add((Component)this.getItemTitlePanel(), "South");
            this.jPanel.add((Component)this.getListSubScroll(), "Center");
            this.jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        }
        return this.jPanel;
    }

    private JPanel getItemTitlePanel() {
        if (this.itemTitlePanel == null) {
            this.itemTitlePanel = new JPanel();
            this.itemTitlePanel.setLayout(new BorderLayout());
            this.itemTitlePanel.setOpaque(false);
            this.itemTitlePanel.setVisible(true);
            JPanel panelAux = new JPanel();
            panelAux.setLayout(new BorderLayout());
            panelAux.add((Component)this.getSkipItem(), "North");
            JPanel panelAux2 = new JPanel();
            panelAux2.setLayout(new BorderLayout());
            panelAux2.add((Component)this.getForceRetreatItem(), "West");
            panelAux2.add((Component)this.getForceAdvanceItem(), "East");
            panelAux.add((Component)panelAux2, "South");
            this.itemTitlePanel.add((Component)panelAux, "East");
            this.itemTitlePanel.add((Component)this.getJScrollPane(), "Center");
            this.itemTitlePanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        return this.itemTitlePanel;
    }

    private JRoundButton getSkipItem() {
        if (this.skipItem == null) {
            this.skipItem = new JRoundButton(new ImageIcon(ImageUtils.getScaledImage("images/buttons/forward.png", 16, 16)));
            this.skipItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CheckListExe.this.skipItem();
                }
            });
            this.skipItem.setToolTipText("Skip Item");
        }
        return this.skipItem;
    }

    private JRoundButton getForceAdvanceItem() {
        if (this.forceAdvanceItem == null) {
            this.forceAdvanceItem = new JRoundButton(new ImageIcon(ImageUtils.getScaledImage("images/buttons/forward_orange.png", 16, 16)));
            this.forceAdvanceItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CheckListExe.this.forceAdvanceItem();
                }
            });
            this.forceAdvanceItem.setToolTipText("Force to Advance Item");
        }
        return this.forceAdvanceItem;
    }

    private JRoundButton getForceRetreatItem() {
        if (this.forceRetreatItem == null) {
            this.forceRetreatItem = new JRoundButton(new ImageIcon(ImageUtils.getScaledImage("images/buttons/retreat_orange.png", 16, 16)));
            this.forceRetreatItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CheckListExe.this.forceRetreatItem();
                }
            });
            this.forceRetreatItem.setToolTipText("Force to retreat Item");
        }
        return this.forceRetreatItem;
    }

    private JLabel getCurrentItemTitle() {
        if (this.currentItemTitle == null) {
            this.currentItemTitle = new JLabel();
        }
        String currGroup = (String)this.checklist.getGroupList().keySet().toArray()[this.currentGroup];
        CheckItem ci = (CheckItem)this.checklist.getGroupList().get(currGroup).toArray()[this.currentItem];
        this.currentItemTitle.setText(ci.getName());
        this.currentItemTitle.setFont(new Font("Arial", 1, 15));
        return this.currentItemTitle;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setPreferredSize(new Dimension(300, 50));
            this.jScrollPane.setViewportView(this.getCurrentItemText());
        }
        return this.jScrollPane;
    }

    private JLabel getCurrentGroupTitle() {
        if (this.currentGroupTitle == null) {
            this.currentGroupTitle = new JLabel();
        }
        return this.currentGroupTitle;
    }

    private JTextArea getCurrentItemText() {
        if (this.currentItemText == null) {
            this.currentItemText = new JTextArea();
            this.currentItemText.setLineWrap(true);
            this.currentItemText.setBorder(new LineBorder(Color.BLACK));
            this.currentItemText.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (CheckListExe.this.getCurrentItem() != null) {
                        CheckListExe.this.getCurrentItem().setNote(CheckListExe.this.currentItemText.getText());
                    }
                }
            });
        }
        if (this.getCurrentItem() != null) {
            this.currentItemText.setText(this.getCurrentItem().getNote());
        }
        for (Container cmp = this.currentItemText; cmp != null; cmp = cmp.getParent()) {
            ((Component)cmp).doLayout();
            ((Component)cmp).invalidate();
            ((Component)cmp).validate();
        }
        return this.currentItemText;
    }

    public static void showCheckListExeDialog(String system, ChecklistType ct, Window w, String wd) {
        CheckListExe gctrans = new CheckListExe(system, ct, w, wd);
        gctrans.setModal(false);
        gctrans.setSize(new Dimension(700, 500));
        GuiUtils.centerParent(gctrans, w);
        gctrans.setVisible(true);
    }

    public void createDescriptionFrame() {
        if (this.messagesFrame == null) {
            this.messagesFrame = new JDialog(this);
            this.messagesFrame.setIconImage(ImageUtils.getImage("images/buttons/info.png"));
            this.messagesFrame.setName("Checklist Description");
            this.messagesFrame.setTitle("Checklist Description");
            this.messagesFrame.setSize(500, 300);
            this.messagesFrame.getContentPane().setLayout(new BorderLayout());
            this.messagesFrame.getContentPane().add((Component)this.getTextPanelDescription(), "Center");
        }
    }

    public JPanel getTextPanelDescription() {
        if (this.textPanelDescription == null) {
            this.textPanelDescription = new JPanel();
            this.textPanelDescription.repaint();
            this.textPanelDescription.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane();
            this.msgTextArea = new JTextPane();
            this.msgTextArea.setEditable(true);
            this.msgTextArea.setText(this.checklist.getDescription());
            this.msgTextArea.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (CheckListExe.this.getCurrentItem() != null) {
                        CheckListExe.this.checklist.setDescription(CheckListExe.this.msgTextArea.getText());
                    }
                }
            });
            jScrollPane.setViewportView(this.msgTextArea);
            this.textPanelDescription.add((Component)jScrollPane, "Center");
            jScrollPane.setVisible(true);
        }
        return this.textPanelDescription;
    }

    private JScrollPane getListSubScroll() {
        if (this.listSubScroll == null) {
            this.listSubScroll = new JScrollPane();
            this.listSubScroll.setOpaque(false);
            this.listSubScroll.setVerticalScrollBarPolicy(20);
            this.listSubScroll.setHorizontalScrollBarPolicy(31);
            this.listSubScroll.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this.listSubScroll.setPreferredSize(new Dimension(300, 50));
            this.listSubScroll.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.listSubScroll.setViewportView(this.getListSubItems());
        }
        return this.listSubScroll;
    }

    public JPanel getListSubItems() {
        if (this.listSubItems == null) {
            this.listSubItems = new JPanel();
            this.listSubItems.setLayout(new BoxLayout(this.listSubItems, 1));
        }
        return this.listSubItems;
    }

    private void loadCurrent() {
        if (this.currentItem == 0 && this.currentGroup == 0) {
            this.forceRetreatItem.setEnabled(false);
        } else {
            this.forceRetreatItem.setEnabled(true);
        }
        this.initItemTime = System.currentTimeMillis();
        if (this.checklist.isFlat()) {
            this.currentGroupTitle.setText("Flat Checklist (no groups)");
            this.skipGroup.setEnabled(false);
        } else {
            this.currentGroupTitle.setText((String)this.checklist.getGroupList().keySet().toArray()[this.currentGroup]);
        }
        String currGroup = (String)this.checklist.getGroupList().keySet().toArray()[this.currentGroup];
        CheckItem ci = (CheckItem)this.checklist.getGroupList().get(currGroup).toArray()[this.currentItem];
        this.currentItemTitle.setText(ci.getName());
        if (this.getCurrentItem().getNote() != null) {
            this.currentItemText.setText(this.getCurrentItem().getNote());
        }
        for (Container cmp = this.currentItemText; cmp != null; cmp = cmp.getParent()) {
            ((Component)cmp).doLayout();
            ((Component)cmp).invalidate();
            ((Component)cmp).validate();
        }
        if (this.getCurrentItem().getAutoSubItems().isEmpty()) {
            CheckAutoUserActionItem casi = new CheckAutoUserActionItem();
            casi.setAction(ci.getName() + this.getCurrentItem().getNote());
            this.addSubItem(casi);
        } else {
            for (CheckAutoSubItem casi : this.getCurrentItem().getAutoSubItems()) {
                this.addSubItem(casi);
            }
        }
        this.jScrollPane.findComponentAt(0, 0);
        this.jScrollPane.findComponentAt(new Point(1, 1));
        this.repaintCheck();
    }

    private void addSubItem(CheckAutoSubItem casi) {
        CheckSubItemExe si;
        if (casi.getSubItemType().equals("variableTestRange")) {
            si = new CheckVariableItem(this.system, (CheckAutoVarIntervalItem)casi);
            si.addCheckSubItemProvider(this);
            this.listSubItems.add(si);
            this.autoSubItems.add(si);
        }
        if (casi.getSubItemType().equals("userAction")) {
            si = new CheckActionItem((CheckAutoUserActionItem)casi);
            si.addCheckSubItemProvider(this);
            this.listSubItems.add(si);
            this.autoSubItems.add(si);
        }
        if (casi.getSubItemType().equals("userLog")) {
            si = new CheckLogItem((CheckAutoUserLogItem)casi);
            si.addCheckSubItemProvider(this);
            this.listSubItems.add(si);
            this.autoSubItems.add(si);
        }
    }

    private void closeCurrentItem() {
        for (CheckSubItemExe casi : this.autoSubItems) {
            casi.close();
        }
        this.autoSubItems.clear();
        this.listSubItems.removeAll();
        this.repaintCheck();
    }

    public void checkedAdvance() {
        boolean okFlag = true;
        for (CheckSubItemExe casi : this.autoSubItems) {
            if (casi.isCheck()) continue;
            okFlag = false;
        }
        if (okFlag) {
            this.getCurrentItem().setChecked(true);
            long time = System.currentTimeMillis();
            this.getCurrentItem().setDateChecked(CheckItemPanel.dateXMLFormater.format(new Date(time)));
            this.advance();
        } else {
            this.getCurrentItem().setChecked(false);
        }
    }

    public void Retreat() {
        this.closeCurrentItem();
        if (this.currentItem > 0) {
            --this.currentItem;
        } else if (this.currentGroup > 0) {
            --this.currentGroup;
            this.currentItem = this.getCurrentItemLength() - 1;
        }
        this.loadCurrent();
    }

    public void advance() {
        this.closeCurrentItem();
        boolean flagMissCheck = false;
        boolean flagEnd = false;
        while (!flagMissCheck) {
            ++this.currentItem;
            if (this.currentItem < this.getCurrentItemLength()) {
                if (this.getCurrentItem().isChecked()) continue;
                flagMissCheck = true;
                continue;
            }
            this.currentItem = 0;
            ++this.currentGroup;
            if (this.currentGroup >= this.getGroupLength()) {
                flagMissCheck = true;
                flagEnd = true;
                continue;
            }
            if (this.getCurrentItem().isChecked()) continue;
            flagMissCheck = true;
        }
        if (!flagEnd) {
            this.loadCurrent();
        } else {
            this.end();
        }
    }

    private JPanel getEndPanel() {
        if (this.endPanel == null) {
            this.endPanel = new JPanel();
            JButton close = new JButton("Close");
            close = this.checkFlag ? new JButton(new ImageIcon(ImageUtils.getScaledImage("images/buttons/checklist.png", 16, 16))) : new JButton(new ImageIcon(ImageUtils.getScaledImage("images/buttons/close.png", 16, 16)));
            close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean ret;
                    CheckListExe.this.chronometer.stop();
                    String saux = DateTimeUtil.dateTimeFileNameFormater.format(new Date(System.currentTimeMillis()));
                    String aux2 = CheckListExe.this.checklist.getName().replace('.', '\u0000');
                    aux2 = aux2.replace('<', '_');
                    aux2 = aux2.replace('>', '_');
                    aux2 = aux2.replace('\\', '_');
                    aux2 = aux2.replace('*', '_');
                    aux2 = aux2.replace(':', '_');
                    aux2 = aux2.replace('|', '_');
                    aux2 = aux2.replace('?', '_');
                    aux2 = aux2.replace('.', '_');
                    aux2 = aux2.replace('/', '_');
                    aux2 = aux2.replace('\"', '_');
                    if (CheckListExe.this.workingDir == null) {
                        CheckListExe.this.workingDir = ".";
                    }
                    if (ret = FileUtil.saveToFile(aux2 = CheckListExe.this.workingDir + "/" + aux2 + " " + saux + "." + "nchk", FileUtil.getAsPrettyPrintFormatedXMLString(CheckListExe.this.checklist.asDocument()))) {
                        JOptionPane.showMessageDialog(CheckListExe.this, "<html>Checklist saved!!<br>To file \"" + aux2 + "\".</html>");
                    }
                    CheckListExe.this.dispose();
                }
            });
            close.setToolTipText("Close Checklist Execution");
            close.setText("Close");
            final JButton produceReport = new JButton(new ImageIcon(ImageUtils.getScaledImage("images/buttons/report.png", 16, 16)));
            produceReport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block9: {
                        boolean ret = false;
                        String saux = DateTimeUtil.dateTimeFileNameFormater.format(new Date(System.currentTimeMillis()));
                        String aux2 = CheckListExe.this.checklist.getName().replace('.', '\u0000');
                        aux2 = aux2.replace('<', '_');
                        aux2 = aux2.replace('>', '_');
                        aux2 = aux2.replace('\\', '_');
                        aux2 = aux2.replace('*', '_');
                        aux2 = aux2.replace(':', '_');
                        aux2 = aux2.replace('|', '_');
                        aux2 = aux2.replace('?', '_');
                        aux2 = aux2.replace('.', '_');
                        aux2 = aux2.replace('/', '_');
                        aux2 = aux2.replace('\"', '_');
                        if (CheckListExe.this.workingDir == null) {
                            CheckListExe.this.workingDir = ".";
                        }
                        String pdf = aux2 = CheckListExe.this.workingDir + "/" + aux2 + " " + saux + ".pdf";
                        File pdfFx = new File(aux2);
                        Object[] optionsNew = new Object[]{"1 column", "2 column", "3 column"};
                        int choNew = JOptionPane.showOptionDialog(produceReport, "Choose one to continue", "Choose", -1, 3, null, optionsNew, optionsNew[2]);
                        if (choNew == 0 || choNew == 1 || choNew == 2) {
                            ret = GeneratorChecklistPDF.generateReport(CheckListExe.this.checklist, pdfFx, (short)(choNew + 1));
                        }
                        if (ret) {
                            JOptionPane.showMessageDialog(produceReport, "PDF created with success to file \"" + pdf + "\".");
                            try {
                                if (ConfigFetch.getOS() == 0) {
                                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + pdf);
                                    break block9;
                                }
                                String[] readers = new String[]{"acroread", "xpdf"};
                                String reader = null;
                                for (int count = 0; count < readers.length && reader == null; ++count) {
                                    if (Runtime.getRuntime().exec(new String[]{"which", readers[count]}).waitFor() != 0) continue;
                                    reader = readers[count];
                                }
                                if (reader == null) {
                                    throw new Exception("Could not find pdf reader");
                                }
                                Runtime.getRuntime().exec(new String[]{reader, pdf});
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            JOptionPane.showMessageDialog(produceReport, "<html>PDF <b>was not</b> created to file.</html>");
                        }
                    }
                }
            });
            produceReport.setToolTipText("Produce PDF Report");
            produceReport.setText("Produce PDF Report");
            JButton runUnCheck = new JButton("run Uncheck items");
            runUnCheck = new JButton(new ImageIcon(ImageUtils.getScaledImage("images/buttons/rev.png", 16, 16)));
            runUnCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CheckListExe.this.skipGroup.setEnabled(true);
                    CheckListExe.this.skipItem.setEnabled(true);
                    CheckListExe.this.forceAdvanceItem.setEnabled(true);
                    CheckListExe.this.currentItemText.setEnabled(true);
                    CheckListExe.this.currentItem = 0;
                    CheckListExe.this.currentGroup = 0;
                    CheckListExe.this.chronometer.resume();
                    CheckListExe.this.closeCurrentItem();
                    if (CheckListExe.this.getCurrentItem() != null) {
                        if (!CheckListExe.this.getCurrentItem().isChecked()) {
                            CheckListExe.this.loadCurrent();
                        } else {
                            CheckListExe.this.advance();
                        }
                    }
                }
            });
            runUnCheck.setToolTipText("Re Check");
            runUnCheck.setText("Run again on unchecked Items");
            runUnCheck.setMargin(new Insets(20, 2, 20, 2));
            JPanel panelAux = new JPanel();
            panelAux.setLayout(new BoxLayout(panelAux, 1));
            if (!this.checkFlag) {
                panelAux.add(runUnCheck);
            }
            panelAux.add(produceReport);
            panelAux.add(close);
            JLabel msg = new JLabel("");
            msg.setHorizontalAlignment(0);
            if (this.checkFlag) {
                msg.setText("Check Ok   ");
                msg.setForeground(new Color(0, 128, 0));
            } else {
                msg.setText("Check Incomplete   ");
                msg.setForeground(Color.RED);
            }
            msg.setFont(new Font("Arial", 1, 30));
            this.endPanel.add((Component)msg, "Center");
            this.endPanel.add((Component)panelAux, "South");
        }
        return this.endPanel;
    }

    private void end() {
        this.chronometer.pause();
        this.skipGroup.setEnabled(false);
        this.skipItem.setEnabled(false);
        this.forceAdvanceItem.setEnabled(false);
        this.forceRetreatItem.setEnabled(false);
        this.currentItemText.setEnabled(false);
        this.currentItemText.setText("Time :" + this.chronometer.getFormattedTime());
        this.listSubItems.add(this.getEndPanel());
        this.repaintCheck();
        NeptusLog.pub().info((Object)"<###>Check List Ended");
    }

    private void skipItem() {
        this.getCurrentItem().setSkiped(true);
        this.advance();
    }

    private void skipGroup() {
        LinkedList<CheckItem> list = this.checklist.getGroupList().get(this.getCurrentGroup());
        for (CheckItem ci : list) {
            ci.setChecked(true);
        }
        this.currentItem = this.getCurrentItemLength();
        this.advance();
    }

    private void forceAdvanceItem() {
        this.checkFlag = false;
        this.getCurrentItem().setSkiped(false);
        this.advance();
    }

    private void forceRetreatItem() {
        this.getCurrentItem().setSkiped(false);
        this.Retreat();
    }

    public void repaintCheck() {
        this.listSubItems.doLayout();
        this.listSubItems.invalidate();
        this.listSubItems.validate();
        for (Container cmp = this.listSubItems.getParent(); cmp != null; cmp = cmp.getParent()) {
            ((Component)cmp).doLayout();
            ((Component)cmp).invalidate();
            ((Component)cmp).validate();
        }
        this.listSubItems.repaint();
    }

    public String getCurrentGroup() {
        if (this.checklist.isFlat()) {
            return "flat";
        }
        return (String)this.checklist.getGroupList().keySet().toArray()[this.currentGroup];
    }

    public int getGroupLength() {
        if (this.checklist.isFlat()) {
            return 1;
        }
        return this.checklist.getGroupList().keySet().toArray().length;
    }

    public CheckItem getCurrentItem() {
        String currGroup = this.getCurrentGroup();
        NeptusLog.pub().info((Object)("<###>CurrentGroup : " + this.currentGroup + "   item :" + this.currentItem));
        NeptusLog.pub().info((Object)("<###>getCurrentGroup() : " + this.getCurrentGroup()));
        NeptusLog.pub().info((Object)("<###>checklist.getGroupList() : " + this.checklist.getGroupList()));
        NeptusLog.pub().info((Object)("<###>(CheckItem) checklist.getGroupList().get(currGroup) : " + this.checklist.getGroupList()));
        NeptusLog.pub().info((Object)("<###>contain: : " + this.checklist.getGroupList().containsKey(currGroup)));
        NeptusLog.pub().info((Object)("<###>contain: : " + this.checklist.getGroupList().keySet().toArray()[0]));
        CheckItem ci = (CheckItem)this.checklist.getGroupList().get(currGroup).toArray()[this.currentItem];
        return ci;
    }

    public int getCurrentItemLength() {
        String currGroup = this.getCurrentGroup();
        return this.checklist.getGroupList().get(currGroup).toArray().length;
    }

    @Override
    public void checkSubItemChange(CheckSubItemExe cbie) {
        this.checkedAdvance();
    }
}

