/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist.exec;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import pt.lsts.neptus.gui.checklist.CheckItemPanel;
import pt.lsts.neptus.gui.checklist.exec.CheckSubItemExe;
import pt.lsts.neptus.types.checklist.CheckAutoUserLogItem;
import pt.lsts.neptus.util.ImageUtils;

public class CheckLogItem
extends CheckSubItemExe {
    private static final long serialVersionUID = 1L;
    private CheckAutoUserLogItem checkSubItem;
    private JTextArea logRequestTextArea = null;
    private JTextArea logMessageTextArea = null;
    private JScrollPane listSubScroll = null;
    private JPanel logPanel = null;
    private JCheckBox check = null;
    private Color bg = null;

    public CheckLogItem(CheckAutoUserLogItem casi) {
        this.checkSubItem = casi;
        this.initialize();
    }

    private void initialize() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setMaximumSize(new Dimension(2000, 100));
        this.setMinimumSize(new Dimension(300, 100));
        this.setLayout(new BorderLayout());
        this.bg = this.getBackground();
        if (this.checkSubItem.isChecked()) {
            this.setBackground(CheckItemPanel.CHECK_COLOR);
        }
        this.add((Component)this.getLogPanel(), "Center");
        this.add((Component)this.getCheck(), "East");
    }

    private JPanel getLogPanel() {
        if (this.logPanel == null) {
            this.logPanel = new JPanel();
            this.logPanel.setLayout(new BorderLayout());
            this.logPanel.setOpaque(false);
            this.logPanel.add((Component)this.getLogRequestTextArea(), "North");
            this.logPanel.add((Component)this.getListSubScroll(), "Center");
        }
        return this.logPanel;
    }

    private JTextArea getLogRequestTextArea() {
        if (this.logRequestTextArea == null) {
            this.logRequestTextArea = new JTextArea();
            this.logRequestTextArea.setLineWrap(true);
            this.logRequestTextArea.setEditable(false);
            this.logRequestTextArea.setOpaque(false);
            this.logRequestTextArea.setText(this.checkSubItem.getLogRequest());
        }
        return this.logRequestTextArea;
    }

    private JScrollPane getListSubScroll() {
        if (this.listSubScroll == null) {
            this.listSubScroll = new JScrollPane();
            this.listSubScroll.setOpaque(false);
            this.listSubScroll.setVerticalScrollBarPolicy(20);
            this.listSubScroll.setHorizontalScrollBarPolicy(31);
            this.listSubScroll.setPreferredSize(new Dimension(300, 50));
            this.listSubScroll.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.listSubScroll.setViewportView(this.getLogMessageTextArea());
        }
        return this.listSubScroll;
    }

    private JTextArea getLogMessageTextArea() {
        if (this.logMessageTextArea == null) {
            this.logMessageTextArea = new JTextArea();
            this.logMessageTextArea.setLineWrap(true);
            this.logMessageTextArea.setEditable(true);
            this.logMessageTextArea.setText(this.checkSubItem.getLogMessage());
            this.logMessageTextArea.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    CheckLogItem.this.checkSubItem.setLogMessage(CheckLogItem.this.logMessageTextArea.getText());
                }
            });
        }
        return this.logMessageTextArea;
    }

    private JCheckBox getCheck() {
        if (this.check == null) {
            this.check = new JCheckBox();
            this.check.setOpaque(false);
            this.check.setSelected(this.checkSubItem.isChecked());
            this.check.setMargin(new Insets(2, 20, 2, 20));
            this.check.setIcon(ImageUtils.getIcon("images/checklists/boxIcon.png"));
            this.check.setSelectedIcon(ImageUtils.getIcon("images/checklists/selectedIcon.png"));
            this.check.setDisabledIcon(ImageUtils.getIcon("images/checklists/disabledIcon.png"));
            this.check.setDisabledSelectedIcon(ImageUtils.getIcon("images/checklists/disabledSelectedIcon.png"));
            this.check.setPressedIcon(ImageUtils.getIcon("images/checklists/disabledIcon.png"));
            this.check.setRolloverIcon(ImageUtils.getIcon("images/checklists/boxIcon.png"));
            this.check.setRolloverSelectedIcon(ImageUtils.getIcon("images/checklists/selectedIcon.png"));
            this.check.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CheckLogItem.this.checkSubItem.setChecked(CheckLogItem.this.check.isSelected());
                    if (CheckLogItem.this.check.isSelected()) {
                        CheckLogItem.this.checkSubItem.setLogMessage(CheckLogItem.this.logMessageTextArea.getText());
                        CheckLogItem.this.setBackground(CheckItemPanel.CHECK_COLOR);
                    } else {
                        CheckLogItem.this.setBackground(CheckLogItem.this.bg);
                    }
                    CheckLogItem.this.warnCheckSubItemProviders();
                }
            });
            this.check.setSize(30, 30);
        }
        return this.check;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isCheck() {
        return this.checkSubItem.isChecked();
    }
}

