/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.checklist.exec;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.manager.imc.EntitiesResolver;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.gui.checklist.CheckItemPanel;
import pt.lsts.neptus.gui.checklist.exec.CheckSubItemExe;
import pt.lsts.neptus.messages.listener.MessageInfo;
import pt.lsts.neptus.messages.listener.MessageListener;
import pt.lsts.neptus.types.checklist.CheckAutoVarIntervalItem;

public class CheckVariableItem
extends CheckSubItemExe
implements MessageListener<MessageInfo, IMCMessage> {
    private static final long serialVersionUID = 1L;
    private CheckAutoVarIntervalItem checkSubItem;
    private String system;
    String[] path;

    public CheckVariableItem(String system, CheckAutoVarIntervalItem ci) {
        this.checkSubItem = ci;
        this.system = system;
        this.initialize();
        this.path = this.checkSubItem.getVarPath().split(".");
    }

    private void initialize() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setMaximumSize(new Dimension(2000, 150));
        this.setMinimumSize(new Dimension(0, 150));
        if (this.checkSubItem.isChecked()) {
            this.setBackground(CheckItemPanel.CHECK_COLOR);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel(this.checkSubItem.getVarName()));
        ImcMsgManager.getManager().addListener(this, this.system);
    }

    @Override
    public void close() {
        super.close();
        ImcMsgManager.getManager().removeListener(this);
    }

    public void setValue(double value) {
    }

    @Override
    public boolean isCheck() {
        return this.checkSubItem.isChecked();
    }

    public void onMessage(MessageInfo info, IMCMessage msg) {
        String entityName;
        if (msg.getAbbrev().equals(this.path[0]) && ((entityName = EntitiesResolver.resolveName(this.system, msg.getHeader().getInteger("src_ent"))).equals(this.path[1]) || this.path[1].equals("*"))) {
            this.setValue(msg.getDouble(this.path[2]));
        }
    }
}

