/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.beans.editor.FixedButton;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pt.lsts.neptus.gui.swing.AnglePanel;

public class AngleEditorRads
extends AbstractPropertyEditor {
    protected JTextField textField = new JTextField();
    private JButton button = new FixedButton();
    private double angleRads = 0.0;
    protected boolean showDegrees = false;
    private Class<? extends Object> valueClass = null;

    public AngleEditorRads() {
        this.textField.setEditable(false);
        this.editor = new JPanel(new BorderLayout(0, 0));
        ((JPanel)this.editor).add((Component)this.textField, "Center");
        ((JPanel)this.editor).add((Component)this.button, "East");
        this.textField.setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double oldAngle = AngleEditorRads.this.angleRads;
                double newAngle = AnglePanel.angleDialogRads(AngleEditorRads.this.textField, AngleEditorRads.this.angleRads);
                AngleEditorRads.this.setValue(newAngle);
                AngleEditorRads.this.firePropertyChange(oldAngle, newAngle);
                AngleEditorRads.this.textField.setText("" + (AngleEditorRads.this.showDegrees ? Math.toDegrees(newAngle) : newAngle) + (AngleEditorRads.this.showDegrees ? "\u00b0" : " rad"));
            }
        });
    }

    public String getAsText() {
        return "" + (this.showDegrees ? Math.toDegrees(this.angleRads) : this.angleRads) + (this.showDegrees ? "\u00b0" : " rad");
    }

    public Object getValue() {
        if (this.valueClass == Float.class) {
            return new Float(this.angleRads);
        }
        return new Double(this.angleRads);
    }

    public void setValue(Object arg0) {
        if (arg0 instanceof Number) {
            if (this.valueClass == null) {
                this.valueClass = arg0.getClass();
            }
            this.angleRads = ((Number)arg0).doubleValue();
            this.textField.setText("" + (this.showDegrees ? Math.toDegrees(this.angleRads) : this.angleRads) + (this.showDegrees ? "\u00b0 deg" : " rad"));
        }
    }
}

