/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor;

import com.l2fprod.common.beans.editor.StringConverterPropertyEditor;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.util.converter.ConverterRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.params.SystemProperty;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.MathMiscUtils;

public class ArrayListEditor<E extends ArrayList<T>, T>
extends StringConverterPropertyEditor {
    public static final String REAL_PATTERN = "([+-])?\\d+(\\.\\d*)?(E([+-])?\\d{1,2})?";
    public static final String INTEGER_PATTERN = "([+-])?\\d+";
    public static final String STRING_LIST_PATTERN = "([^,])+";
    public static final String IP_ADDRESS_PATTERN = "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    public static final String IP_PORT_RANGE_PATTERN = "(?:6553[0-5]|655[0-2][0-9]|65[0-4][0-9][0-9]|6[0-4][0-9][0-9][0-9]|((([0-5]?[0-9])?[0-9])?[0-9][0-9])|[1-9])";
    public static final String IP_ADDRESSWITH_PORT_PATTERN = "((?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(:(?:6553[0-5]|655[0-2][0-9]|65[0-4][0-9][0-9]|6[0-4][0-9][0-9][0-9]|((([0-5]?[0-9])?[0-9])?[0-9][0-9])|[1-9]))?)";
    public static final int UNLIMITED_SIZE = -1;
    protected ArrayList<T> arrayList = new ArrayList();
    protected final Class<T> classType;
    protected int minSize = 0;
    protected int maxSize = -1;
    protected T minValue = null;
    protected T maxValue = null;
    private Pattern pattern;
    protected String elementPattern;
    private Color errorColor = new Color(255, 108, 108);
    private Border defaultBorder = null;
    private Border errorBorder = null;

    private ArrayListEditor(Class<T> classType, int size) {
        this(classType, size, size);
    }

    private ArrayListEditor(Class<T> classType, int minSize, int maxSize, T minValue, T maxValue) {
        this(classType, minSize, maxSize);
        if (classType == Double.class) {
            if (minValue == null) {
                minValue = new Double(Double.MIN_VALUE);
            }
            if (maxValue == null) {
                maxValue = new Double(Double.MAX_VALUE);
            }
            if ((Double)minValue > (Double)maxValue) {
                minValue = maxValue;
            }
        } else if (classType == Float.class) {
            if (minValue == null) {
                minValue = new Float(Float.MIN_VALUE);
            }
            if (maxValue == null) {
                maxValue = new Float(Float.MAX_VALUE);
            }
            if (((Float)minValue).floatValue() > ((Float)maxValue).floatValue()) {
                minValue = maxValue;
            }
        } else if (classType == Long.class) {
            if (minValue == null) {
                minValue = new Long(Long.MIN_VALUE);
            }
            if (maxValue == null) {
                maxValue = new Long(Long.MAX_VALUE);
            }
            if ((Long)minValue > (Long)maxValue) {
                minValue = maxValue;
            }
        } else if (classType == Integer.class) {
            if (minValue == null) {
                minValue = new Integer(Integer.MIN_VALUE);
            }
            if (maxValue == null) {
                maxValue = new Integer(Integer.MAX_VALUE);
            }
            if ((Integer)minValue > (Integer)maxValue) {
                minValue = maxValue;
            }
        } else if (classType == Short.class) {
            if (minValue == null) {
                minValue = new Short(Short.MIN_VALUE);
            }
            if (maxValue == null) {
                maxValue = new Short(Short.MAX_VALUE);
            }
            if ((Short)minValue > (Short)maxValue) {
                minValue = maxValue;
            }
        } else if (classType == Byte.class) {
            if (minValue == null) {
                minValue = new Byte(-128);
            }
            if (maxValue == null) {
                maxValue = new Byte(127);
            }
            if ((Byte)minValue > (Byte)maxValue) {
                minValue = maxValue;
            }
        } else {
            maxValue = null;
            minValue = null;
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    private ArrayListEditor(Class<T> classType, int minSize, int maxSize) {
        this.classType = classType;
        if (classType == Double.class || classType == Float.class) {
            this.elementPattern = REAL_PATTERN;
        } else if (classType == Long.class || classType == Integer.class || classType == Short.class) {
            this.elementPattern = INTEGER_PATTERN;
        } else if (classType == String.class) {
            this.elementPattern = STRING_LIST_PATTERN;
        }
        if (minSize < 0) {
            minSize = 0;
        }
        if (maxSize <= 0) {
            maxSize = -1;
        }
        if (minSize > maxSize) {
            minSize = 0;
        }
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.init();
    }

    public static ArrayListEditor<ArrayList<Double>, Double> forgeDouble(int size) {
        return new ArrayListEditor<ArrayList<Double>, Double>(Double.class, size);
    }

    public static ArrayListEditor<ArrayList<Double>, Double> forgeDouble(int minSize, int maxSize) {
        return new ArrayListEditor<ArrayList<Double>, Double>(Double.class, minSize, maxSize);
    }

    public static ArrayListEditor<ArrayList<Double>, Double> forgeDouble(int minSize, int maxSize, double minValue, double maxValue) {
        return new ArrayListEditor<ArrayList<Double>, Double>(Double.class, minSize, maxSize, minValue, maxValue);
    }

    public static ArrayListEditor<ArrayList<Float>, Float> forgeFloat(int size) {
        return new ArrayListEditor<ArrayList<Float>, Float>(Float.class, size);
    }

    public static ArrayListEditor<ArrayList<Float>, Float> forgeFloat(int minSize, int maxSize) {
        return new ArrayListEditor<ArrayList<Float>, Float>(Float.class, minSize, maxSize);
    }

    public static ArrayListEditor<ArrayList<Integer>, Integer> forgeInteger(int size) {
        return new ArrayListEditor<ArrayList<Integer>, Integer>(Integer.class, size);
    }

    public static ArrayListEditor<ArrayList<Integer>, Integer> forgeInteger(int minSize, int maxSize) {
        return new ArrayListEditor<ArrayList<Integer>, Integer>(Integer.class, minSize, maxSize);
    }

    public static ArrayListEditor<ArrayList<Long>, Long> forgeLong(int size) {
        return new ArrayListEditor<ArrayList<Long>, Long>(Long.class, size);
    }

    public static ArrayListEditor<ArrayList<Long>, Long> forgeLong(int minSize, int maxSize) {
        return new ArrayListEditor<ArrayList<Long>, Long>(Long.class, minSize, maxSize);
    }

    public static ArrayListEditor<ArrayList<Long>, Long> forgeLong(int minSize, int maxSize, long minValue, long maxValue) {
        return new ArrayListEditor<ArrayList<Long>, Long>(Long.class, minSize, maxSize, minValue, maxValue);
    }

    public static ArrayListEditor<ArrayList<Short>, Short> forgeShort(int size) {
        return new ArrayListEditor<ArrayList<Short>, Short>(Short.class, size);
    }

    public static ArrayListEditor<ArrayList<Short>, Short> forgeShort(int minSize, int maxSize) {
        return new ArrayListEditor<ArrayList<Short>, Short>(Short.class, minSize, maxSize);
    }

    public static ArrayListEditor<ArrayList<String>, String> forgeString(int size) {
        return new ArrayListEditor<ArrayList<String>, String>(String.class, size);
    }

    public static ArrayListEditor<ArrayList<String>, String> forgeString(int minSize, int maxSize) {
        return new ArrayListEditor<ArrayList<String>, String>(String.class, minSize, maxSize);
    }

    public static ArrayListEditor<ArrayList<String>, String> forgeString(int size, String regexp) {
        return ArrayListEditor.forgeString(size, size, regexp);
    }

    public static ArrayListEditor<ArrayList<String>, String> forgeString(int minSize, int maxSize, final String regexp) {
        return new ArrayListEditor<ArrayList<String>, String>(String.class, minSize, maxSize){
            {
                super(x0, x1, x2);
                this.elementPattern = regexp == null || regexp.length() == 0 ? ArrayListEditor.STRING_LIST_PATTERN : regexp;
            }
        };
    }

    protected void init() {
        ((JTextField)this.editor).addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                boolean checkOk = true;
                String txt = ((JTextField)ArrayListEditor.this.editor).getText();
                try {
                    ArrayListEditor.this.convertFromString(txt);
                }
                catch (Exception e1) {
                    checkOk = false;
                }
                if (!checkOk) {
                    if (ArrayListEditor.this.errorBorder == null) {
                        ArrayListEditor.this.errorBorder = BorderFactory.createLineBorder(ArrayListEditor.this.errorColor, 2);
                        ArrayListEditor.this.defaultBorder = ((JTextField)ArrayListEditor.this.editor).getBorder();
                    }
                    ((JTextField)ArrayListEditor.this.editor).setBorder(ArrayListEditor.this.errorBorder);
                    UIManager.getLookAndFeel().provideErrorFeedback(ArrayListEditor.this.editor);
                } else {
                    ((JTextField)ArrayListEditor.this.editor).setBorder(ArrayListEditor.this.defaultBorder);
                }
            }
        });
    }

    public ArrayList<T> getValue() {
        this.arrayList = (ArrayList)super.getValue();
        return this.arrayList;
    }

    protected T convertElement(String text) {
        return null;
    }

    protected Object convertFromString(String text) {
        Matcher m;
        boolean checkOk;
        if (this.pattern == null) {
            String pat = "";
            pat = this.maxSize == 1 ? "(" + this.elementPattern + ")" + (this.minSize == 0 ? "{0,1}" : "") : (this.maxSize > 1 && this.minSize == this.maxSize ? "(" + this.elementPattern + ")" + "(\\ *,\\ *(" + this.elementPattern + ")\\ *){" + (this.maxSize - 1) + "}" : (this.maxSize > 1 && this.minSize != this.maxSize ? "(" + this.elementPattern + ")" + "(\\ *,\\ *(" + this.elementPattern + ")\\ *){" + this.minSize + "," + (this.maxSize - 1) + "}" : "(" + this.elementPattern + ")" + "(\\ *,\\ *" + this.elementPattern + "\\ *)*"));
            this.pattern = Pattern.compile(pat, 2);
        }
        if (!(checkOk = (m = this.pattern.matcher(((JTextField)this.editor).getText())).matches())) {
            throw new NumberFormatException();
        }
        ArrayList<T> valuesList = new ArrayList<T>();
        String[] tokens = text.split(",");
        boolean changeContent = false;
        for (String tk : tokens) {
            Object tokenObjVal = this.convertElement(tk = tk.trim());
            if (tokenObjVal == null) {
                if (this.classType == String.class) {
                    tokenObjVal = tk;
                } else if (this.classType == Double.class) {
                    tokenObjVal = ConverterRegistry.instance().convert(Double.class, (Object)tk);
                } else if (this.classType == Float.class) {
                    tokenObjVal = ConverterRegistry.instance().convert(Float.class, (Object)tk);
                } else if (this.classType == Long.class) {
                    tokenObjVal = ConverterRegistry.instance().convert(Long.class, (Object)tk);
                } else if (this.classType == Integer.class) {
                    tokenObjVal = ConverterRegistry.instance().convert(Integer.class, (Object)tk);
                } else if (this.classType == Short.class) {
                    tokenObjVal = ConverterRegistry.instance().convert(Short.class, (Object)tk);
                }
            }
            if (tokenObjVal != null && Number.class.isAssignableFrom(this.classType)) {
                Object valueToReq = tokenObjVal;
                if (this.minValue != null && this.maxValue != null) {
                    if (((Number)valueToReq).doubleValue() < ((Number)this.minValue).doubleValue()) {
                        valueToReq = this.minValue;
                        changeContent = true;
                    }
                    if (((Number)valueToReq).doubleValue() > ((Number)this.maxValue).doubleValue()) {
                        valueToReq = this.maxValue;
                        changeContent = true;
                    }
                }
            }
            if (tokenObjVal == null) continue;
            valuesList.add(tokenObjVal);
        }
        if (this.maxSize > -1 && valuesList.size() > this.maxSize) {
            throw new NumberFormatException();
        }
        if (valuesList.size() < this.minSize) {
            throw new NumberFormatException();
        }
        if (changeContent) {
            ((JTextField)this.editor).setText(this.convertToString(valuesList));
        }
        return valuesList;
    }

    protected String convertToString(Object value) {
        return Arrays.toString(((ArrayList)value).toArray(new Object[0])).replace("[", "").replace("]", "");
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        JLabel titleLabel = new JLabel("<html><b>Test</b></html>");
        panel.add((Component)titleLabel, "w 100%, wrap");
        final PropertySheetPanel psp = new PropertySheetPanel();
        psp.setSortingCategories(true);
        psp.setSortingProperties(false);
        psp.setDescriptionVisible(true);
        psp.setMode(1);
        psp.setToolBarVisible(false);
        final PropertyEditorRegistry per = new PropertyEditorRegistry();
        psp.setEditorFactory((PropertyEditorFactory)per);
        panel.add((Component)psp, "w 100%, h 100%, wrap");
        final Random rnd = new Random(System.currentTimeMillis());
        JButton refreshButton = new JButton(new AbstractAction(I18n.text("add")){
            int c;
            {
                super(x0);
                this.c = 0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                ++this.c;
                SystemProperty property = new SystemProperty();
                property.setName("prop D " + this.c);
                property.setDisplayName(property.getName());
                ArrayList<Object> value = new ArrayList<Object>();
                for (i = 0; i < this.c; ++i) {
                    double v = MathMiscUtils.round(rnd.nextDouble(), 1);
                    value.add(v);
                }
                property.setValue(value);
                psp.addProperty((Property)property);
                per.registerEditor((Property)property, ArrayListEditor.forgeDouble(this.c));
                psp.revalidate();
                property = new SystemProperty();
                property.setName("prop L " + this.c);
                property.setDisplayName(property.getName());
                value = new ArrayList();
                for (i = 0; i < this.c; ++i) {
                    long v = rnd.nextLong();
                    value.add(v);
                }
                property.setValue(value);
                psp.addProperty((Property)property);
                per.registerEditor((Property)property, ArrayListEditor.forgeLong(this.c));
                psp.revalidate();
                property = new SystemProperty();
                property.setName("prop Short " + this.c);
                property.setDisplayName(property.getName());
                value = new ArrayList();
                for (i = 0; i < this.c; ++i) {
                    short v = (short)rnd.nextInt();
                    value.add(v);
                }
                property.setValue(value);
                psp.addProperty((Property)property);
                per.registerEditor((Property)property, ArrayListEditor.forgeShort(this.c));
                psp.revalidate();
                property = new SystemProperty();
                property.setName("prop String " + this.c);
                property.setDisplayName(property.getName());
                value = new ArrayList();
                for (i = 0; i < this.c; ++i) {
                    char v = (char)rnd.nextInt();
                    value.add("" + v);
                }
                property.setValue(value);
                psp.addProperty((Property)property);
                per.registerEditor((Property)property, ArrayListEditor.forgeString(this.c > 2 ? -1 : this.c));
                psp.revalidate();
                property = new SystemProperty();
                property.setName("prop String regexp " + this.c);
                property.setDisplayName(property.getName());
                value = new ArrayList();
                for (i = 0; i < this.c; ++i) {
                    String ip = "";
                    for (int j = 0; j < 4; ++j) {
                        int v = (int)(Math.abs(rnd.nextDouble()) * 255.0);
                        ip = ip + (ip.length() > 0 ? "." : "") + v;
                    }
                    value.add(ip);
                }
                property.setValue(value);
                psp.addProperty((Property)property);
                String ipAddRegexp = ArrayListEditor.IP_ADDRESS_PATTERN;
                String portAddRexexp = "(:(?:6553[0-5]|655[0-2][0-9]|65[0-4][0-9][0-9]|6[0-4][0-9][0-9][0-9]|((([0-5]?[0-9])?[0-9])?[0-9][0-9])|[1-9]))?";
                per.registerEditor((Property)property, ArrayListEditor.forgeString(this.c > 2 ? -1 : this.c, ipAddRegexp + portAddRexexp));
                psp.revalidate();
            }
        });
        panel.add((Component)refreshButton, "split");
        JButton dumpButton = new JButton(new AbstractAction(I18n.text("dump")){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder sb = new StringBuilder();
                sb.append("\n\nProperties {\n");
                for (Property prop : psp.getProperties()) {
                    sb.append("\t\"" + prop.getName() + "\": \"");
                    sb.append(Arrays.toString(((ArrayList)prop.getValue()).toArray(new Object[0])));
                    sb.append("\",\n");
                }
                sb.append("}");
                NeptusLog.pub().info((Object)("<###> " + sb.toString()));
            }
        });
        panel.add(dumpButton);
        GuiUtils.testFrame(panel, "Test", 600, 600);
    }
}

