/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import pt.lsts.neptus.i18n.I18n;

public class ComboEditor<T>
extends AbstractPropertyEditor {
    protected JComboBox<T> combo;
    private T oldValue = null;
    protected Vector<String> stringValues = new Vector();

    public ComboEditor(T[] options) {
        this(options, null);
    }

    public ComboEditor(T[] options, String[] stringValues) {
        if (stringValues != null && options.length == stringValues.length) {
            for (String str : stringValues) {
                this.stringValues.add(str);
            }
        }
        this.combo = new JComboBox<T>(options){

            @Override
            public void setSelectedItem(Object anObject) {
                ComboEditor.this.oldValue = this.getSelectedItem();
                super.setSelectedItem(anObject);
            }
        };
        this.combo.setRenderer(new ListCellRenderer<T>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
                String str = I18n.text(value.toString());
                if (!ComboEditor.this.stringValues.isEmpty()) {
                    for (int i = 0; i < ComboEditor.this.combo.getItemCount(); ++i) {
                        if (!ComboEditor.this.combo.getItemAt(i).equals(value)) continue;
                        str = ComboEditor.this.stringValues.get(i);
                        break;
                    }
                }
                JLabel label = new JLabel(str);
                label.setOpaque(true);
                if (isSelected) {
                    label.setBackground(list.getSelectionBackground());
                    label.setForeground(list.getSelectionForeground());
                } else {
                    label.setBackground(list.getBackground());
                    label.setForeground(list.getForeground());
                }
                return label;
            }
        });
        this.combo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ComboEditor.this.firePropertyChange(ComboEditor.this.oldValue, ComboEditor.this.combo.getSelectedItem());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        this.combo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ComboEditor.this.firePropertyChange(ComboEditor.this.oldValue, ComboEditor.this.combo.getSelectedItem());
                }
            }
        });
        this.editor = this.combo;
    }

    public T getValue() {
        return (T)this.combo.getSelectedItem();
    }

    public void setValue(Object arg0) {
        this.combo.setSelectedItem(arg0);
    }
}

