/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import pt.lsts.neptus.i18n.I18n;

public class EnumEditor
extends AbstractPropertyEditor {
    private Class<? extends Enum> clazz;
    private JComboBox<String> combo;
    private String oldValue = null;

    public EnumEditor(Class<? extends Enum> clazz) {
        this.clazz = clazz;
        Enum[] enums = clazz.getEnumConstants();
        String[] options = new String[enums.length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = enums[i].name().startsWith("_") ? enums[i].name().substring(1) : enums[i].name();
        }
        this.combo = new JComboBox<String>(options){

            @Override
            public void setSelectedItem(Object anObject) {
                EnumEditor.this.oldValue = (String)this.getSelectedItem();
                super.setSelectedItem(anObject);
            }
        };
        this.combo.setRenderer(new ComboRenderer());
        this.combo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                EnumEditor.this.firePropertyChange(EnumEditor.this.oldValue, EnumEditor.this.combo.getSelectedItem());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        this.combo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EnumEditor.this.firePropertyChange(EnumEditor.this.oldValue, EnumEditor.this.combo.getSelectedItem());
                }
            }
        });
        this.editor = this.combo;
    }

    public Object getValue() {
        try {
            return Enum.valueOf(this.clazz, this.combo.getSelectedItem().toString());
        }
        catch (Exception e) {
            return Enum.valueOf(this.clazz, "_" + this.combo.getSelectedItem());
        }
    }

    public void setValue(Object value) {
        this.combo.setSelectedItem(((Enum)value).name());
    }

    private class ComboRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        public ComboRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value != null) {
                this.setText(I18n.text(value));
            }
            return this;
        }
    }
}

