/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.gui.SelectAllFocusListener;
import pt.lsts.neptus.gui.tablelayout.TableLayout;
import pt.lsts.neptus.util.GuiUtils;

public class ImcId16Editor
extends AbstractPropertyEditor {
    ImcId16 oldValue;
    public JPanel imcId16Editor = new JPanel();
    JTextField[] fields = new JTextField[2];

    public ImcId16Editor() {
        this.imcId16Editor.setLayout(new TableLayout(new double[]{0.22, 0.04, 0.22}, new double[]{-1.0}));
        for (int i = 0; i < 2; ++i) {
            this.fields[i] = this.buildField(i);
            this.imcId16Editor.add((Component)this.fields[i], i * 2 + ",0");
        }
        this.imcId16Editor.add((Component)this.createLabel(), "1,0");
        this.editor = this.imcId16Editor;
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    ImcId16Editor.this.fields[0].requestFocus();
                    e.consume();
                }
                if (ImcId16Editor.this.imcId16Editor.getParent() != null) {
                    for (KeyListener ml : ImcId16Editor.this.imcId16Editor.getParent().getKeyListeners()) {
                        ml.keyPressed(e);
                    }
                }
            }
        });
    }

    public JTextField buildField(int n) {
        final JTextField field = new JTextField("00", 2);
        field.setBorder(BorderFactory.createEmptyBorder());
        field.setHorizontalAlignment(0);
        field.addFocusListener(new SelectAllFocusListener());
        field.addFocusListener(new FocusAdapter(){
            String oldText = "";

            @Override
            public void focusGained(FocusEvent e) {
                this.oldText = field.getText();
                super.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    Integer i = Integer.parseInt(field.getText(), 16);
                    if (i < 0 || i > 255) {
                        field.setText(this.oldText);
                    }
                }
                catch (Exception ex) {
                    field.setText(this.oldText);
                }
                super.focusLost(e);
            }
        });
        field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    if (ImcId16Editor.this.fields[0].isFocusOwner()) {
                        ImcId16Editor.this.fields[1].requestFocus();
                    }
                    if (ImcId16Editor.this.fields[1].isFocusOwner()) {
                        ImcId16Editor.this.fields[0].requestFocus();
                    }
                    e.consume();
                }
                if (ImcId16Editor.this.imcId16Editor.getParent() != null) {
                    for (KeyListener ml : ImcId16Editor.this.imcId16Editor.getParent().getKeyListeners()) {
                        ml.keyPressed(e);
                    }
                }
            }
        });
        return field;
    }

    public JLabel createLabel() {
        JLabel lbl = new JLabel(":");
        lbl.setHorizontalAlignment(0);
        lbl.setOpaque(true);
        lbl.setBackground(Color.white);
        return lbl;
    }

    public Object getValue() {
        String s = this.fields[0].getText();
        for (int i = 1; i < 2; ++i) {
            try {
                s = s + ":" + this.fields[i].getText();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ImcId16(s);
    }

    public void setValue(Object arg0) {
        this.oldValue = (ImcId16)arg0;
        for (int i = 0; i < 2; ++i) {
            String bb = Long.toHexString(this.oldValue.getByte(i));
            if (bb.length() == 1) {
                bb = "0" + bb;
            }
            this.fields[i].setText(bb);
        }
    }

    public static void main(String[] args) {
        ImcId16Editor test = new ImcId16Editor();
        test.imcId16Editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                NeptusLog.pub().info((Object)("<###> " + e.getKeyCode()));
            }
        });
        test.setValue(new ImcId16("ed:01"));
        GuiUtils.testFrame(test.imcId16Editor, "sdsd");
        NeptusLog.pub().info((Object)("<###> " + test.getValue()));
    }
}

