/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.beans.editor.FixedButton;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.fileeditor.SyntaxDocument;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.StringProperty;

public class LongStringPropertyEditor
extends AbstractPropertyEditor {
    protected JTextField textField = new JTextField();
    private JButton button = new FixedButton();
    private String value = "";
    private boolean canceled;

    public LongStringPropertyEditor(String value) {
        this();
        this.value = value;
    }

    public LongStringPropertyEditor() {
        this.textField.setEditable(false);
        this.editor = new JPanel(new BorderLayout(0, 0));
        ((JPanel)this.editor).add((Component)this.textField, "Center");
        ((JPanel)this.editor).add((Component)this.button, "East");
        this.textField.setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LongStringPropertyEditor.this.value = LongStringPropertyEditor.this.showStringDialog("Text Editor", LongStringPropertyEditor.this.value, true, SwingUtilities.getWindowAncestor(LongStringPropertyEditor.this.textField));
                LongStringPropertyEditor.this.textField.setText(LongStringPropertyEditor.this.value);
            }
        });
    }

    public Object getValue() {
        return new StringProperty(this.value);
    }

    public void setValue(Object arg0) {
        this.value = arg0.toString();
    }

    String showStringDialog(String title, String previousValue, boolean editable, Component component) {
        this.canceled = true;
        JEditorPane msgTextArea = null;
        JScrollPane jScrollPane = null;
        jScrollPane = new JScrollPane();
        msgTextArea = SyntaxDocument.getCustomEditor(new String[0], new String[0], "#", "");
        msgTextArea.setEditable(editable);
        jScrollPane.setViewportView(msgTextArea);
        jScrollPane.setVisible(true);
        if (previousValue == null) {
            previousValue = "";
        }
        msgTextArea.setText(previousValue);
        final JDialog dialog = component instanceof JFrame ? new JDialog((JFrame)component) : (component instanceof JDialog ? new JDialog((JDialog)component) : new JDialog());
        dialog.setTitle(title);
        dialog.setSize(640, 480);
        dialog.setLayout(new BorderLayout());
        dialog.setModal(true);
        dialog.setAlwaysOnTop(true);
        GuiUtils.centerOnScreen(dialog);
        dialog.setResizable(true);
        dialog.setAlwaysOnTop(true);
        dialog.add((Component)jScrollPane, "Center");
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new BorderLayout());
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LongStringPropertyEditor.this.canceled = false;
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        buttons.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        buttons.add(cancel);
        toolbar.add((Component)buttons, "East");
        dialog.add((Component)toolbar, "South");
        dialog.setVisible(true);
        if (this.canceled) {
            return previousValue;
        }
        return msgTextArea.getText();
    }
}

