/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class NeptusDoubleEditor
extends AbstractPropertyEditor {
    private Object lastGoodValue;
    protected DecimalFormat format = new DecimalFormat("0.0########");

    public NeptusDoubleEditor() {
        this.format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
        this.format.setGroupingUsed(false);
        this.editor = new JTextField();
        ((JTextField)this.editor).setBorder(LookAndFeelTweaks.EMPTY_BORDER);
    }

    public Object getValue() {
        String text = ((JTextField)this.editor).getText();
        if (text == null || text.trim().length() == 0) {
            return this.getDefaultValue();
        }
        StringBuffer number = new StringBuffer();
        number.ensureCapacity(text.length());
        int c = text.length();
        for (int i = 0; i < c; ++i) {
            char character = text.charAt(i);
            if ('.' == character || '-' == character || 'E' == character || Character.isDigit(character)) {
                number.append(character);
                continue;
            }
            if (' ' != character) break;
        }
        try {
            this.lastGoodValue = Double.parseDouble(number.toString());
        }
        catch (Exception e) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.editor);
        }
        return this.lastGoodValue;
    }

    public void setValue(Object value) {
        if (value instanceof Number) {
            ((JTextField)this.editor).setText(this.format.format(((Number)value).doubleValue()));
        } else {
            ((JTextField)this.editor).setText("" + this.getDefaultValue());
        }
        this.lastGoodValue = value;
    }

    private Object getDefaultValue() {
        return 0.0;
    }
}

