/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pt.lsts.neptus.NeptusLog;

public class NeptusNumericEditor
extends AbstractPropertyEditor {
    protected JTextField textField = new JTextField();
    protected static NumberFormat nf = new DecimalFormat("###.##");

    public NeptusNumericEditor() {
        NeptusLog.pub().info((Object)"<###>Created a numericeditor!");
        this.textField.setLocale(Locale.US);
        this.editor = new JPanel(new BorderLayout(0, 0));
        ((JPanel)this.editor).add((Component)this.textField, "Center");
        this.textField.setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        this.textField.addFocusListener(new FocusAdapter(){
            private Double oldVal = null;

            @Override
            public void focusGained(FocusEvent arg0) {
                try {
                    this.oldVal = Double.parseDouble(NeptusNumericEditor.this.textField.getText());
                }
                catch (Exception e) {
                    this.oldVal = new Double(0.0);
                    NeptusNumericEditor.this.textField.setText("0");
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                try {
                    Double newVal = Double.parseDouble(NeptusNumericEditor.this.textField.getText());
                    NeptusNumericEditor.this.firePropertyChange(this.oldVal, newVal);
                }
                catch (Exception e) {
                    NeptusNumericEditor.this.textField.setText(this.oldVal.toString());
                }
            }
        });
    }

    public Object getValue() {
        return Double.parseDouble(this.textField.getText());
    }

    public void setValue(Object arg0) {
        if (arg0 instanceof Double) {
            nf.setGroupingUsed(false);
            this.textField.setText(nf.format(arg0));
        }
    }

    public static void main(String[] args) {
    }
}

