/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor;

import com.l2fprod.common.beans.editor.NumberPropertyEditor;
import com.l2fprod.common.util.converter.ConverterRegistry;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import pt.lsts.neptus.gui.editor.ValidationEnableInterface;

public class NumberEditor<T extends Number>
extends NumberPropertyEditor
implements ValidationEnableInterface {
    protected final Class<T> classType;
    protected boolean enableValidation = true;
    protected T minValue = null;
    protected T maxValue = null;
    private Pattern pattern;
    protected String elementPattern;
    private Color errorColor = new Color(255, 108, 108);
    private Border defaultBorder = null;
    private Border errorBorder = null;
    private Timer timer = null;
    private TimerTask validatorTask = null;

    public NumberEditor(Class<T> type, T minValue, T maxValue) {
        this(type);
        if (type == Double.class) {
            if (minValue == null) {
                minValue = new Double(Double.MIN_VALUE);
            }
            if (maxValue == null) {
                maxValue = new Double(Double.MAX_VALUE);
            }
            if (((Number)minValue).doubleValue() > ((Number)maxValue).doubleValue()) {
                minValue = maxValue;
            }
        } else if (type == Float.class) {
            if (minValue == null) {
                minValue = new Float(Float.MIN_VALUE);
            }
            if (maxValue == null) {
                maxValue = new Float(Float.MAX_VALUE);
            }
            if (((Number)minValue).floatValue() > ((Number)maxValue).floatValue()) {
                minValue = maxValue;
            }
        } else if (type == Long.class) {
            if (minValue == null) {
                minValue = new Long(Long.MIN_VALUE);
            }
            if (maxValue == null) {
                maxValue = new Long(Long.MAX_VALUE);
            }
            if (((Number)minValue).longValue() > ((Number)maxValue).longValue()) {
                minValue = maxValue;
            }
        } else if (type == Integer.class) {
            if (minValue == null) {
                minValue = new Integer(Integer.MIN_VALUE);
            }
            if (maxValue == null) {
                maxValue = new Integer(Integer.MAX_VALUE);
            }
            if (((Number)minValue).intValue() > ((Number)maxValue).intValue()) {
                minValue = maxValue;
            }
        } else if (type == Short.class) {
            if (minValue == null) {
                minValue = new Short(Short.MIN_VALUE);
            }
            if (maxValue == null) {
                maxValue = new Short(Short.MAX_VALUE);
            }
            if (((Number)minValue).shortValue() > ((Number)maxValue).shortValue()) {
                minValue = maxValue;
            }
        } else if (type == Byte.class) {
            if (minValue == null) {
                minValue = new Byte(-128);
            }
            if (maxValue == null) {
                maxValue = new Byte(127);
            }
            if (((Number)minValue).byteValue() > ((Number)maxValue).byteValue()) {
                minValue = maxValue;
            }
        } else {
            maxValue = null;
            minValue = null;
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public NumberEditor(Class<T> type) {
        super(type);
        this.classType = type;
        this.elementPattern = this.classType == Double.class || this.classType == Float.class ? "([+-])?\\d+(\\.\\d*)?(E([+-])?\\d{1,2})?" : (this.classType == Byte.class ? "[01]+" : "([+-])?\\d+");
        ((JTextField)this.editor).addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    this.validateValue();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                NumberEditor.this.revokeScheduleValidatorTask();
                NumberEditor.this.scheduleValidatorTask();
            }

            private void validateValue() {
                boolean checkOk = true;
                String txt = ((JTextField)NumberEditor.this.editor).getText().trim();
                try {
                    NumberEditor.this.convertFromString(txt);
                }
                catch (Exception e1) {
                    checkOk = false;
                }
                if (!checkOk) {
                    if (NumberEditor.this.errorBorder == null) {
                        NumberEditor.this.errorBorder = BorderFactory.createLineBorder(NumberEditor.this.errorColor, 2);
                        NumberEditor.this.defaultBorder = ((JTextField)NumberEditor.this.editor).getBorder();
                    }
                    ((JTextField)NumberEditor.this.editor).setBorder(NumberEditor.this.errorBorder);
                    UIManager.getLookAndFeel().provideErrorFeedback(NumberEditor.this.editor);
                } else {
                    ((JTextField)NumberEditor.this.editor).setBorder(NumberEditor.this.defaultBorder);
                }
            }
        });
        ((JTextField)this.editor).addFocusListener(new FocusAdapter(){
            private T oldVal = null;

            @Override
            public void focusGained(FocusEvent fe) {
                try {
                    this.oldVal = NumberEditor.this.convertFromString(((JTextField)NumberEditor.this.editor).getText());
                }
                catch (Exception e) {
                    this.oldVal = null;
                }
            }

            @Override
            public void focusLost(FocusEvent fe) {
                try {
                    Number newVal = NumberEditor.this.convertFromString(((JTextField)NumberEditor.this.editor).getText());
                    NumberEditor.this.firePropertyChange(this.oldVal, newVal);
                }
                catch (Exception e) {
                    ((JTextField)NumberEditor.this.editor).setText(NumberEditor.this.convertToString(this.oldVal));
                }
            }
        });
    }

    public Object getValue() {
        return this.convertFromString(this.convertToString(super.getValue()));
    }

    private void scheduleValidatorTask() {
        if (this.validatorTask == null) {
            if (this.timer == null) {
                this.timer = new Timer(this.getClass().getSimpleName() + " keyboard entry value validator for " + this.classType.getSimpleName() + " [" + this.minValue + ", " + this.maxValue + "]", true);
            }
            this.validatorTask = this.createValidatorTimerTask();
            this.timer.schedule(this.validatorTask, 700L);
        }
    }

    private void revokeScheduleValidatorTask() {
        if (this.validatorTask != null) {
            this.validatorTask.cancel();
            try {
                if (this.validatorTask != null) {
                    this.validatorTask.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.validatorTask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private TimerTask createValidatorTimerTask() {
        return new TimerTask(){

            @Override
            public void run() {
                boolean checkOk = true;
                String txt = ((JTextField)NumberEditor.this.editor).getText();
                try {
                    NumberEditor.this.convertFromString(txt);
                }
                catch (Exception e1) {
                    checkOk = false;
                }
                if (!checkOk) {
                    if (NumberEditor.this.errorBorder == null) {
                        NumberEditor.this.errorBorder = BorderFactory.createLineBorder(NumberEditor.this.errorColor, 2);
                        NumberEditor.this.defaultBorder = ((JTextField)NumberEditor.this.editor).getBorder();
                    }
                    ((JTextField)NumberEditor.this.editor).setBorder(NumberEditor.this.errorBorder);
                    UIManager.getLookAndFeel().provideErrorFeedback(NumberEditor.this.editor);
                } else {
                    ((JTextField)NumberEditor.this.editor).setBorder(NumberEditor.this.defaultBorder);
                }
                if (NumberEditor.this.timer != null) {
                    NumberEditor.this.timer.cancel();
                    NumberEditor.this.timer = null;
                }
            }
        };
    }

    private T convertFromString(String txt) throws NumberFormatException {
        Matcher m;
        boolean checkOk;
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.elementPattern, 2);
        }
        if (!(checkOk = (m = this.pattern.matcher(txt)).matches())) {
            throw new NumberFormatException();
        }
        Number valueToReq = (Number)ConverterRegistry.instance().convert(this.classType, (Object)txt);
        if (this.enableValidation && this.minValue != null && this.maxValue != null) {
            if (valueToReq.doubleValue() < ((Number)this.minValue).doubleValue()) {
                ((JTextField)this.editor).setText(this.convertToString(this.minValue));
                valueToReq = this.minValue;
            }
            if (valueToReq.doubleValue() > ((Number)this.maxValue).doubleValue()) {
                ((JTextField)this.editor).setText(this.convertToString(this.maxValue));
                valueToReq = this.maxValue;
            }
        }
        return (T)valueToReq;
    }

    protected String convertToString(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return "" + value;
        }
        if (value instanceof Long || value instanceof Integer) {
            return "" + value;
        }
        return (String)ConverterRegistry.instance().convert(String.class, value);
    }

    @Override
    public boolean isEnableValidation() {
        return this.enableValidation;
    }

    @Override
    public void setEnableValidation(boolean enableValidation) {
        this.enableValidation = enableValidation;
    }
}

