/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pt.lsts.neptus.fileeditor.SyntaxDocument;
import pt.lsts.neptus.util.GuiUtils;

public class Script {
    public String source;
    public static boolean flag_exit;

    public Script() {
    }

    public Script(String scr) {
        this.source = scr;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public static Script showScriptDialog(String title, Script previousScript, Component component) {
        return Script.showLocationDialog(title, previousScript, true, component);
    }

    public static Script showLocationDialog(String title, Script previousScript, boolean editable, Component component) {
        JEditorPane msgTextArea = null;
        JScrollPane jScrollPane = null;
        jScrollPane = new JScrollPane();
        msgTextArea = SyntaxDocument.getJavaScriptEditorPane();
        msgTextArea.setEditable(editable);
        jScrollPane.setViewportView(msgTextArea);
        jScrollPane.setVisible(true);
        if ("".equals(previousScript.getSource()) || previousScript.getSource() == null) {
            msgTextArea.setText("/*********************************************************\n  To use variables from the system state just reference them \n  using \"#USE [VARIABLE]\".\n\n  To use environment persistent variables just reference them \n  using \"#ENV [VARIABLE]\".\n**********************************************************/\n\n\n msg.setMsg('0 is green in the alarms leds'); //return message\n\n 0;   // return value and exit");
        } else {
            msgTextArea.setText(previousScript.getSource());
        }
        final JDialog dialog = component instanceof JFrame ? new JDialog((JFrame)component) : (component instanceof JDialog ? new JDialog((JDialog)component) : new JDialog());
        dialog.setTitle(title);
        dialog.setSize(640, 480);
        dialog.setLayout(new BorderLayout());
        dialog.setModal(true);
        dialog.setAlwaysOnTop(true);
        GuiUtils.centerOnScreen(dialog);
        dialog.setResizable(true);
        dialog.setAlwaysOnTop(true);
        dialog.add((Component)jScrollPane, "Center");
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new BorderLayout());
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        Script.setFlag_exit(false);
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GuiUtils.htmlMessage(dialog, "Script Editor", "How to use scripts.", "<html><h1>Script Editor</h1><br><h2>Environment variables</h2><blockquote>You can use <em>'#ENV variableName'</em> to declare a presistent varable. Or simply use in the code <em>'env.initEnv('variableName')'</em>.</blockquote><h2>Variable Tree variables</h2><blockquote>You can use <em>'#USE variableName'</em> to declare them.</blockquote>");
            }
        });
        buttons.add(help);
        help.setEnabled(false);
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Script.setFlag_exit(false);
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        buttons.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Script.setFlag_exit(true);
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        buttons.add(cancel);
        toolbar.add((Component)buttons, "East");
        dialog.add((Component)toolbar, "South");
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Script.setFlag_exit(true);
            }
        });
        dialog.setVisible(true);
        if (Script.isFlag_exit()) {
            return previousScript;
        }
        return new Script(msgTextArea.getText());
    }

    public String toString() {
        return this.source;
    }

    public static boolean isFlag_exit() {
        return flag_exit;
    }

    public static void setFlag_exit(boolean flag_exit2) {
        flag_exit = flag_exit2;
    }

    public static void main(String[] args) {
        Script.showScriptDialog("", new Script(), null);
    }
}

