/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor;

import com.l2fprod.common.beans.editor.StringConverterPropertyEditor;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class StringPatternEditor
extends StringConverterPropertyEditor {
    private Pattern pattern;
    protected String elementPattern;
    private Color errorColor = new Color(255, 108, 108);
    private Border defaultBorder = null;
    private Border errorBorder = null;

    public StringPatternEditor(String regex) throws IllegalArgumentException, PatternSyntaxException {
        this.elementPattern = regex;
        this.pattern = Pattern.compile(this.elementPattern, 2);
        this.init();
    }

    protected void init() {
        ((JTextField)this.editor).addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                boolean checkOk = true;
                String txt = ((JTextField)StringPatternEditor.this.editor).getText();
                try {
                    StringPatternEditor.this.convertFromString(txt);
                }
                catch (Exception e1) {
                    checkOk = false;
                }
                if (!checkOk) {
                    if (StringPatternEditor.this.errorBorder == null) {
                        StringPatternEditor.this.errorBorder = BorderFactory.createLineBorder(StringPatternEditor.this.errorColor, 2);
                        StringPatternEditor.this.defaultBorder = ((JTextField)StringPatternEditor.this.editor).getBorder();
                    }
                    ((JTextField)StringPatternEditor.this.editor).setBorder(StringPatternEditor.this.errorBorder);
                } else {
                    ((JTextField)StringPatternEditor.this.editor).setBorder(StringPatternEditor.this.defaultBorder);
                }
            }
        });
        ((JTextField)this.editor).addFocusListener(new FocusAdapter(){
            private String oldVal = null;

            @Override
            public void focusGained(FocusEvent fe) {
                try {
                    this.oldVal = (String)StringPatternEditor.this.convertFromString(((JTextField)StringPatternEditor.this.editor).getText());
                }
                catch (Exception e) {
                    this.oldVal = null;
                }
            }

            @Override
            public void focusLost(FocusEvent fe) {
                try {
                    String newVal = (String)StringPatternEditor.this.convertFromString(((JTextField)StringPatternEditor.this.editor).getText());
                    StringPatternEditor.this.firePropertyChange(this.oldVal, newVal);
                }
                catch (Exception e) {
                    ((JTextField)StringPatternEditor.this.editor).setText(StringPatternEditor.this.convertToString(this.oldVal));
                }
            }
        });
    }

    protected Object convertFromString(String value) {
        Matcher m;
        boolean checkOk;
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.elementPattern, 2);
        }
        if (!(checkOk = (m = this.pattern.matcher(((JTextField)this.editor).getText())).matches())) {
            throw new NumberFormatException();
        }
        return checkOk ? value : null;
    }

    protected String convertToString(Object value) {
        return value.toString();
    }
}

