/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.BorderLayout;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;

public class UnixTimeEditor
extends AbstractPropertyEditor {
    JPanel panel = new JPanel(new BorderLayout());
    JSpinner.DateEditor deditor;
    JSpinner timeSpinner = new JSpinner(new SpinnerDateModel());

    public UnixTimeEditor() {
        this.deditor = new JSpinner.DateEditor(this.timeSpinner, "yyyy-MMM-dd HH:mm:ss");
        this.timeSpinner.setEditor(this.deditor);
        this.timeSpinner.setValue(new Date());
        this.editor = this.timeSpinner;
    }

    public Object getValue() {
        return ((Date)this.timeSpinner.getValue()).getTime() / 1000L;
    }

    public void setValue(Object value) {
        this.timeSpinner.setValue(new Date((Long)value * 1000L));
    }

    public static void main(String[] args) {
        final DefaultProperty p = PropertiesEditor.getPropertyInstance("test", Long.class, System.currentTimeMillis() / 1000L, true);
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)p, UnixTimeEditor.class);
        PropertiesEditor.editProperties(new PropertiesProvider(){

            @Override
            public DefaultProperty[] getProperties() {
                return new DefaultProperty[]{p};
            }

            @Override
            public String getPropertiesDialogTitle() {
                return "testing";
            }

            @Override
            public void setProperties(Property[] properties) {
                NeptusLog.pub().info((Object)("<###> " + properties[0]));
            }

            @Override
            public String[] getPropertiesErrors(Property[] properties) {
                return null;
            }
        }, true);
    }
}

