/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pt.lsts.neptus.console.plugins.containers.GroupLayoutContainer;
import pt.lsts.neptus.fileeditor.SyntaxDocument;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.StreamUtil;
import pt.lsts.neptus.util.XMLUtil;

public class XMLPropertyEditor
extends AbstractPropertyEditor {
    protected String title = "XML";
    protected String rootElement = "";
    protected JButton button;
    protected String xmlStr = "";
    protected String helpText = I18n.text("Container using GroupLayout\n(see 'http://download.oracle.com/javase/tutorial/uiswing/layout/group.html'\nand 'http://download.oracle.com/javase/tutorial/uiswing/layout/groupExample.html')\n\n\nDefinition:\n===========\n\n");
    protected String contentType = "text/plain";
    protected String smallMsg = I18n.text("This follows the Java Group Layout");
    protected JDialog dialog;

    public XMLPropertyEditor() {
        this.initialize();
    }

    private void initialize() {
        this.button = new JButton(I18n.text("Edit"));
        this.editor = new JPanel(new BorderLayout(0, 0));
        ((JPanel)this.editor).add((Component)this.button, "Center");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLPropertyEditor.this.buildUI();
                XMLPropertyEditor.this.dialog.setVisible(true);
            }
        });
    }

    protected void buildUI() {
        this.dialog = new JDialog(SwingUtilities.getWindowAncestor(this.editor));
        this.dialog.setTitle(this.title);
        this.dialog.setSize(800, 600);
        this.dialog.setLayout(new BorderLayout());
        GuiUtils.centerOnScreen(this.dialog);
        this.dialog.setResizable(true);
        final String oldXmlStr = this.xmlStr;
        final JEditorPane editorPane = SyntaxDocument.getXmlEditorPane();
        JScrollPane editorScrollPane = new JScrollPane();
        editorScrollPane.setViewportView(editorPane);
        editorScrollPane.setVisible(true);
        try {
            if (!"".equalsIgnoreCase(this.xmlStr)) {
                this.xmlStr = XMLUtil.getAsCompactFormatedXMLString(this.xmlStr);
                this.xmlStr = XMLUtil.getAsPrettyPrintFormatedXMLString(this.xmlStr);
            }
        }
        catch (Exception e1) {
            this.xmlStr = oldXmlStr;
        }
        editorPane.setText(this.xmlStr.trim());
        JScrollPane helpScrollPane = new JScrollPane();
        JEditorPane help = new JEditorPane();
        help.setEditable(false);
        help.setContentType(this.contentType);
        help.setBackground(new Color(255, 255, 160));
        help.setText(this.helpText);
        help.setCaretPosition(0);
        helpScrollPane.setViewportView(help);
        helpScrollPane.setVisible(true);
        JSplitPane splitPane = new JSplitPane(1, editorScrollPane, helpScrollPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation((int)((double)this.dialog.getWidth() * 0.7));
        this.dialog.add((Component)splitPane, "Center");
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new BorderLayout());
        JPanel buttons = new JPanel();
        GroupLayout layout = new GroupLayout(buttons);
        buttons.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        JButton okButton = new JButton(I18n.text("OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String[] vmsgs = XMLPropertyEditor.this.validateLayoutXML(editorPane.getText());
                if (vmsgs.length == 0) {
                    String tmpStr = editorPane.getText();
                    try {
                        if (!"".equalsIgnoreCase(tmpStr)) {
                            tmpStr = XMLUtil.getAsCompactFormatedXMLString(tmpStr);
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    XMLPropertyEditor.this.setValue(tmpStr);
                    XMLPropertyEditor.this.firePropertyChange(oldXmlStr, tmpStr);
                    XMLPropertyEditor.this.dialog.setVisible(false);
                    XMLPropertyEditor.this.dialog.dispose();
                } else {
                    String strMsg = I18n.text("Invalid XML!") + "\n";
                    for (String str : vmsgs) {
                        strMsg = strMsg + "\n" + str;
                    }
                    GuiUtils.infoMessage(XMLPropertyEditor.this.dialog, I18n.text("Validation"), strMsg);
                }
            }
        });
        JButton cancelButton = new JButton(I18n.text("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XMLPropertyEditor.this.dialog.setVisible(false);
                XMLPropertyEditor.this.dialog.dispose();
            }
        });
        JButton validateButton = new JButton(I18n.text("Validate"));
        validateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String[] vmsgs = XMLPropertyEditor.this.validateLayoutXML(editorPane.getText());
                if (vmsgs.length == 0) {
                    GuiUtils.infoMessage(XMLPropertyEditor.this.dialog, I18n.text("Validation"), I18n.text("Valid XML."));
                } else {
                    String strMsg = I18n.text("Invalid XML!") + "\n";
                    for (String str : vmsgs) {
                        strMsg = strMsg + "\n" + str;
                    }
                    GuiUtils.infoMessage(XMLPropertyEditor.this.dialog, I18n.text("Validation"), strMsg);
                }
            }
        });
        JButton extractSchemaButton = new JButton(I18n.text("Extract Schema"));
        extractSchemaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    InputStream sstream = GroupLayoutContainer.class.getResourceAsStream("console-group-layout.xsd");
                    File fx = new File("console-group-layout.xsd");
                    fx = new File(fx.getName());
                    fx.createNewFile();
                    StreamUtil.copyStreamToFile(sstream, fx);
                    GuiUtils.infoMessage(XMLPropertyEditor.this.dialog, I18n.text("Extract Schema"), I18n.text("Schema extracted to file:") + "\n" + fx.getAbsolutePath());
                }
                catch (Exception e) {
                    GuiUtils.errorMessage(XMLPropertyEditor.this.dialog, I18n.text("Extract Schema"), I18n.text("Error while extracting schema to file!!") + "\n" + e.getMessage());
                }
            }
        });
        if (this.getSchema() == null) {
            validateButton.setEnabled(false);
            extractSchemaButton.setEnabled(false);
        }
        JLabel label = new JLabel(this.smallMsg);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(extractSchemaButton).addComponent(validateButton).addComponent(label).addComponent(okButton).addComponent(cancelButton));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent(extractSchemaButton).addComponent(validateButton).addComponent(label).addComponent(okButton).addComponent(cancelButton));
        layout.linkSize(0, validateButton, okButton, cancelButton, extractSchemaButton);
        toolbar.add((Component)buttons, "East");
        this.dialog.add((Component)toolbar, "South");
    }

    public Object getValue() {
        return this.xmlStr;
    }

    public void setValue(Object arg0) {
        if (arg0 instanceof String) {
            this.xmlStr = (String)arg0;
        }
    }

    private String[] validateLayoutXML(String strXml) {
        ByteArrayInputStream bais = new ByteArrayInputStream(("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + (this.rootElement != null && !"".equalsIgnoreCase(this.rootElement) ? "<" + this.rootElement + ">" : "") + strXml.trim() + (this.rootElement != null && !"".equalsIgnoreCase(this.rootElement) ? "</" + this.rootElement + ">" : "")).getBytes());
        final Vector validationMsgs = new Vector();
        if (this.getSchema() == null) {
            return new String[0];
        }
        Validator validator = this.getSchema().newValidator();
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                validationMsgs.add("WARNING: " + exception.getMessage());
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                validationMsgs.add("ERROR: " + exception.getMessage());
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                validationMsgs.add("FATAL: " + exception.getMessage());
            }
        });
        try {
            validator.validate(new StreamSource(bais));
        }
        catch (Exception e) {
            // empty catch block
        }
        return validationMsgs.toArray(new String[validationMsgs.size()]);
    }

    public Schema getSchema() {
        return null;
    }

    public static void main(String[] args) {
        XMLPropertyEditor xp = new XMLPropertyEditor();
        GuiUtils.testFrame(xp.button);
    }
}

