/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.editor.renderer;

import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JTable;
import pt.lsts.neptus.i18n.I18n;

public class I18nCellRenderer
extends DefaultCellRenderer {
    private final String unitsStr;
    protected HashMap<String, String> i18nMapper;

    public I18nCellRenderer() {
        this.setShowOddAndEvenRows(false);
        this.i18nMapper = null;
        this.unitsStr = null;
    }

    public I18nCellRenderer(String unitsStr) {
        this.setShowOddAndEvenRows(false);
        this.i18nMapper = null;
        this.unitsStr = unitsStr;
    }

    protected String convertToString(Object value) {
        return (value == null ? "" : super.convertToString(value)) + (this.unitsStr == null ? "" : " " + this.unitsStr);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String stringToI18n = null;
        stringToI18n = value instanceof String ? (String)value : value.toString();
        String i18nString = this.i18nMapper != null ? this.i18nMapper.get(value) : I18n.text(stringToI18n);
        return super.getTableCellRendererComponent(table, i18nString == null ? value : i18nString, isSelected, hasFocus, row, column);
    }

    public HashMap<String, String> getI18nMapper() {
        return this.i18nMapper;
    }

    public void setI18nMapper(HashMap<String, String> i18nMapper) {
        this.i18nMapper = i18nMapper;
    }

    public String getUnitsStr() {
        return this.unitsStr;
    }
}

