/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.objparams;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.i18n.I18n;

public class DrawingParameters
extends ParametersPanel {
    static final long serialVersionUID = 23874623L;
    private JLabel jLabel8 = null;
    private JButton choose = null;
    private JTextField ColorField = null;
    private JCheckBox shapeCheck = null;

    public DrawingParameters() {
        this.initialize();
        this.setPreferredSize(new Dimension(400, 300));
    }

    private JButton getChoose() {
        if (this.choose == null) {
            this.choose = new JButton();
            this.choose.setBounds(135, 15, 90, 25);
            this.choose.setText(I18n.text("Choose..."));
        }
        return this.choose;
    }

    public JCheckBox getShapeCheck() {
        if (this.shapeCheck == null) {
            this.shapeCheck = new JCheckBox(I18n.text("Filled shape"));
            this.shapeCheck.setOpaque(false);
            this.shapeCheck.setBounds(80, 60, 100, 25);
        }
        return this.shapeCheck;
    }

    public JTextField getColorField() {
        if (this.ColorField == null) {
            this.ColorField = new JTextField();
            this.ColorField.setBounds(100, 15, 25, 25);
            this.ColorField.setEditable(true);
            this.ColorField.setEnabled(false);
            this.ColorField.setBackground(Color.orange);
        }
        return this.ColorField;
    }

    private void initialize() {
        this.jLabel8 = new JLabel();
        this.setLayout(null);
        this.setSize(350, 50);
        this.setBackground(SystemColor.control);
        this.jLabel8.setBounds(15, 15, 50, 25);
        this.jLabel8.setText("Color:");
        this.add((Component)this.getChoose(), null);
        this.add((Component)this.getColorField(), null);
        this.add(this.getShapeCheck());
        this.getChoose().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawingParameters.this.showColorDialog();
            }
        });
        this.add((Component)this.jLabel8, null);
    }

    public Color getColor() {
        return this.getColorField().getBackground();
    }

    public void showColorDialog() {
        Color newColor = JColorChooser.showDialog(this, I18n.text("Choose the parallel piped color"), this.getColorField().getBackground());
        this.getColorField().setBackground(newColor);
    }

    public static void main(String[] args) {
        JFrame tstFrame = new JFrame("Dialog Unitary Test");
        tstFrame.setLayout(new BorderLayout());
        DrawingParameters params = new DrawingParameters();
        tstFrame.getContentPane().add((Component)params, "Center");
        tstFrame.setDefaultCloseOperation(3);
        tstFrame.setSize(350, 350);
        tstFrame.setVisible(true);
    }

    @Override
    public String getErrors() {
        return null;
    }

    @Override
    public void setEditable(boolean value) {
        super.setEditable(value);
        this.getChoose().setEnabled(this.isEditable());
        this.getShapeCheck().setEnabled(this.isEditable());
    }
}

