/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.objparams;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.LocationPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.coord.MapTileUtil;

@Deprecated
public class ImageLocatorPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -8382828403279503811L;
    LocationType location1 = new LocationType();
    LocationType location2 = new LocationType();
    Point2D point1;
    Point2D point2;
    Image image;
    int curLocation = 1;
    double scale = 1.0;
    LocationType center = new LocationType();
    private JButton okBtn;
    private JButton cancelBtn;
    boolean isCancel = true;

    public ImageLocatorPanel(Image image) {
        this.image = image;
        this.setCursor(new Cursor(1));
        this.addMouseListener(this);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double zoom = Math.min((double)this.getWidth() / (double)this.image.getWidth(null), (double)this.getHeight() / (double)this.image.getHeight(null));
        g2d.translate(this.getWidth() / 2, this.getHeight() / 2);
        g2d.scale(zoom, zoom);
        g2d.translate(-this.image.getWidth(null) / 2, -this.image.getHeight(null) / 2);
        g2d.drawImage(this.image, 0, 0, null);
        if (this.point1 != null) {
            g2d.setColor(new Color(255, 255, 255, 100));
            g2d.fill(new Ellipse2D.Double(this.point1.getX() - 7.0, this.point1.getY() - 7.0, 14.0, 14.0));
            g2d.setColor(Color.RED);
            g2d.draw(new Ellipse2D.Double(this.point1.getX() - 7.0, this.point1.getY() - 7.0, 14.0, 14.0));
            g2d.drawString("1", (int)this.point1.getX() - 4, (int)this.point1.getY() + 4);
        }
        if (this.point2 != null) {
            g2d.setColor(new Color(255, 255, 255, 100));
            g2d.fill(new Ellipse2D.Double(this.point2.getX() - 7.0, this.point2.getY() - 7.0, 14.0, 14.0));
            g2d.setColor(Color.RED);
            g2d.draw(new Ellipse2D.Double(this.point2.getX() - 7.0, this.point2.getY() - 7.0, 14.0, 14.0));
            g2d.drawString("2", (int)this.point2.getX() - 4, (int)this.point2.getY() + 4);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        final Point position = e.getPoint();
        JPopupMenu menu = new JPopupMenu();
        AbstractAction setLoc1 = new AbstractAction(I18n.text("Set Location 1")){
            private static final long serialVersionUID = -8936197276937360980L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationType lt = LocationPanel.showLocationDialog(I18n.text("Set Location 1"), ImageLocatorPanel.this.location1, null);
                if (lt != null) {
                    ImageLocatorPanel.this.location1 = lt;
                    ImageLocatorPanel.this.point1 = position;
                    if (ImageLocatorPanel.this.point2 != null) {
                        ImageLocatorPanel.this.okBtn.setEnabled(true);
                    }
                    ImageLocatorPanel.this.repaint();
                }
            }
        };
        menu.add(setLoc1);
        AbstractAction setLoc2 = new AbstractAction(I18n.text("Set Location 2")){
            private static final long serialVersionUID = 395764026001138275L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationType lt = LocationPanel.showLocationDialog(I18n.text("Set Location 2"), ImageLocatorPanel.this.location2, null);
                if (lt != null) {
                    ImageLocatorPanel.this.location2 = lt;
                    ImageLocatorPanel.this.point2 = position;
                    if (ImageLocatorPanel.this.point1 != null) {
                        ImageLocatorPanel.this.okBtn.setEnabled(true);
                    }
                    ImageLocatorPanel.this.repaint();
                }
            }
        };
        menu.add(setLoc2);
        menu.show(this, e.getX(), e.getY());
    }

    public boolean performCalculations() {
        double screenDiff = Math.abs(this.point2.getX() - this.point1.getX());
        double locationsDiff = Math.abs(MapTileUtil.getOffsetInPixels(this.location1, this.location2)[1]);
        if (locationsDiff == 0.0) {
            return false;
        }
        this.scale = locationsDiff / screenDiff;
        Point2D.Double meanpoint = new Point2D.Double((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        double xDiff = Math.abs(this.point1.getX() - meanpoint.getX());
        double yDiff = Math.abs(this.point1.getY() - meanpoint.getY());
        if (xDiff == 0.0) {
            return false;
        }
        this.center.setLocation(this.location1);
        this.center.translatePosition(xDiff * this.scale, yDiff * this.scale, 0.0);
        return true;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public static void main(String[] args) {
        ImageLocatorPanel ilp = new ImageLocatorPanel(ImageUtils.getImage("images/lsts.png"));
        if (ilp.showDialog()) {
            NeptusLog.pub().info((Object)("<###>Scale: " + ilp.getScale()));
            NeptusLog.pub().info((Object)("<###>Center: " + ilp.getCenter().getDebugString()));
        }
    }

    public boolean showDialog() {
        final JDialog positionDialog = new JDialog(new JFrame(), I18n.text("Set 2 locations"), true);
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel controlPanel = new JPanel(new FlowLayout(2));
        this.okBtn = new JButton(I18n.text("OK"));
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImageLocatorPanel.this.performCalculations()) {
                    positionDialog.setVisible(false);
                    positionDialog.dispose();
                    ImageLocatorPanel.this.isCancel = false;
                } else {
                    ImageLocatorPanel.this.okBtn.setEnabled(false);
                    GuiUtils.errorMessage(positionDialog, I18n.text("Error in the locations"), I18n.text("The entered locations are not valid"));
                }
            }
        });
        this.okBtn.setEnabled(false);
        this.cancelBtn = new JButton(I18n.text("Cancel"));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                positionDialog.setVisible(false);
                positionDialog.dispose();
                ImageLocatorPanel.this.isCancel = true;
            }
        });
        controlPanel.add(this.okBtn);
        controlPanel.add(this.cancelBtn);
        mainPanel.add((Component)this, "Center");
        mainPanel.add((Component)controlPanel, "South");
        positionDialog.setContentPane(mainPanel);
        positionDialog.setSize(400, 500);
        GuiUtils.centerOnScreen(positionDialog);
        positionDialog.setVisible(true);
        return !this.isCancel;
    }

    public LocationType getCenter() {
        return this.center;
    }

    public void setCenter(LocationType center) {
        this.center = center;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }
}

