/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.objparams;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.ImageFileChooser;
import pt.lsts.neptus.gui.ImageScaleAndLocationPanel;
import pt.lsts.neptus.gui.LocationPanel;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.ImageElement;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class ImageObjectParameters
extends ParametersPanel {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private JLabel imgLabel = null;
    private JButton selectImage = null;
    private JPanel lat = null;
    private JPanel jPanel2 = null;
    private JLabel jLabel1 = null;
    private JButton changeCenter = null;
    private JPanel jPanel4 = null;
    private JLabel jLabel3 = null;
    private JFormattedTextField scale = null;
    private NumberFormat df = GuiUtils.getNeptusDecimalFormat();
    private NumberFormat dfI = GuiUtils.getNeptusIntegerFormat();
    private String imageFileName = null;
    private LocationType center = new LocationType();
    private JPanel jPanel1 = null;
    private JPanel jPanel3 = null;
    private JButton jButton = null;
    private JPanel batPanel = null;
    private JPanel jPanel5 = null;
    private JCheckBox batCheckBox = null;
    private JLabel maxHeightLabel = null;
    private JFormattedTextField maxHeightFormattedTextField = null;
    private JPanel jPanel6 = null;
    private JPanel jPanel7 = null;
    private JLabel maxDepthLabel = null;
    private JLabel resolutionLabel = null;
    private JFormattedTextField maxDepthFormattedTextField = null;
    private JFormattedTextField resolutionFormattedTextField = null;
    private JPanel jPanel8 = null;
    private JButton bathImageSelect = null;
    private File selectedBathymetricImage = null;

    public ImageObjectParameters() {
        this.initialize();
        this.setPreferredSize(new Dimension(505, 300));
    }

    private void initialize() {
        GridLayout gridLayout6 = new GridLayout();
        this.setLayout(gridLayout6);
        this.setSize(505, 181);
        gridLayout6.setRows(1);
        gridLayout6.setColumns(3);
        this.add((Component)this.getJPanel1(), null);
        this.add((Component)this.getLat(), null);
        this.add((Component)this.getBatPanel(), null);
    }

    @Override
    public String getErrors() {
        if (this.getImageFileName() == null) {
            return "The selected image is invalid";
        }
        if (this.batCheckBox.isSelected() && this.selectedBathymetricImage == null) {
            return "You must select a bathymetric image";
        }
        if (this.batCheckBox.isSelected() && !this.selectedBathymetricImage.canRead()) {
            return "Unable to read the bathymetric image file";
        }
        return null;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setPreferredSize(new Dimension(150, 170));
            this.jPanel.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Image"), 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jPanel.add((Component)this.getImgLabel(), "North");
            this.jPanel.add((Component)this.getSelectImage(), "South");
        }
        return this.jPanel;
    }

    private JButton getSelectImage() {
        if (this.selectImage == null) {
            this.selectImage = new JButton();
            this.selectImage.setText(I18n.text("Select image..."));
            this.selectImage.setPreferredSize(new Dimension(90, 25));
            this.selectImage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File f = ImageFileChooser.showOpenImageDialog();
                    if (f != null) {
                        ImageObjectParameters.this.setImageFileName(f.getAbsolutePath());
                    }
                }
            });
        }
        return this.selectImage;
    }

    private JPanel getLat() {
        if (this.lat == null) {
            this.lat = new JPanel();
            this.lat.setLayout(new BorderLayout());
            this.lat.add((Component)this.getJPanel3(), "North");
            this.lat.add((Component)this.getJPanel2(), "Center");
        }
        return this.lat;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            this.jLabel1 = new JLabel();
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(flowLayout1);
            this.jLabel1.setText(I18n.text("Center:"));
            flowLayout1.setVgap(30);
            this.jPanel2.add((Component)this.jLabel1, null);
            this.jPanel2.add((Component)this.getChangeCenter(), null);
            this.jPanel2.add((Component)this.getJPanel4(), null);
            this.jPanel2.add((Component)this.getJButton(), null);
        }
        return this.jPanel2;
    }

    private JButton getChangeCenter() {
        if (this.changeCenter == null) {
            this.changeCenter = new JButton();
            this.changeCenter.setText(I18n.text("Change..."));
            this.changeCenter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LocationType tmp = LocationPanel.showLocationDialog(I18n.text("Set the center location"), ImageObjectParameters.this.getCenter(), null);
                    if (tmp != null) {
                        ImageObjectParameters.this.getCenter().setLocation(tmp);
                    }
                }
            });
        }
        return this.changeCenter;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jLabel3 = new JLabel();
            this.jPanel4 = new JPanel();
            this.jLabel3.setText(I18n.text("Scale (m/pixel):"));
            this.jPanel4.add((Component)this.jLabel3, null);
            this.jPanel4.add((Component)this.getScale(), null);
        }
        return this.jPanel4;
    }

    private JFormattedTextField getScale() {
        if (this.scale == null) {
            this.scale = new JFormattedTextField(this.df);
            this.scale.setPreferredSize(new Dimension(40, 20));
            this.scale.setText("1.0");
        }
        return this.scale;
    }

    public LocationType getCenter() {
        return this.center;
    }

    public void setCenter(LocationType center) {
        this.center.setLocation(center);
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
        Image origImage = ImageUtils.getImage(this.getImageFileName());
        if (origImage != null) {
            this.getImgLabel().setIcon(new ImageIcon(ImageUtils.getScaledImage(origImage, 100, 100, false)));
        }
    }

    public double getImageScale() {
        return Double.parseDouble(this.getScale().getText());
    }

    public void setImageScale(double scale) {
        this.getScale().setText(String.valueOf(scale));
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.add((Component)this.getJPanel(), null);
        }
        return this.jPanel1;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new BorderLayout());
            this.jPanel3.setSize(192, 122);
        }
        return this.jPanel3;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setPreferredSize(new Dimension(120, 26));
            this.jButton.setText(I18n.text("2 locations..."));
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ImageElement tmp = new ImageElement();
                        tmp.setImage(ImageUtils.getImage(ImageObjectParameters.this.getImageFileName()));
                        if (ImageScaleAndLocationPanel.showDialog(tmp, SwingUtilities.getWindowAncestor(ImageObjectParameters.this))) {
                            ImageObjectParameters.this.getScale().setText(String.valueOf(tmp.getImageScale()));
                            ImageObjectParameters.this.center = tmp.getCenterLocation();
                        }
                    }
                    catch (Exception exception) {
                        NeptusLog.pub().warn((Object)exception.getMessage());
                        GuiUtils.errorMessage(SwingUtilities.getRoot((Component)e.getSource()), I18n.text("Select an image first"), I18n.text("You have to select an image fisrt."));
                    }
                }
            });
        }
        return this.jButton;
    }

    private JLabel getImgLabel() {
        if (this.imgLabel == null) {
            this.imgLabel = new JLabel();
            this.imgLabel.setPreferredSize(new Dimension(120, 120));
            this.imgLabel.setHorizontalAlignment(0);
            this.imgLabel.setVerticalAlignment(0);
        }
        return this.imgLabel;
    }

    private JPanel getBatPanel() {
        if (this.batPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.batPanel = new JPanel();
            this.batPanel.setLayout(flowLayout);
            this.batPanel.add((Component)this.getBatCheckBox(), null);
            this.batPanel.add((Component)this.getJPanel5(), null);
            this.batPanel.add((Component)this.getJPanel6(), null);
            this.batPanel.add((Component)this.getJPanel7(), null);
            this.batPanel.add((Component)this.getJPanel8(), null);
        }
        return this.batPanel;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            this.maxHeightLabel = new JLabel();
            this.maxHeightLabel.setText(I18n.text("Max height"));
            this.jPanel5 = new JPanel();
            this.jPanel5.add((Component)this.maxHeightLabel, null);
            this.jPanel5.add((Component)this.getMaxHeightFormattedTextField(), null);
        }
        return this.jPanel5;
    }

    private JCheckBox getBatCheckBox() {
        if (this.batCheckBox == null) {
            this.batCheckBox = new JCheckBox();
            this.batCheckBox.setText(I18n.text("Is bathymetric"));
            this.batCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    NeptusLog.pub().info((Object)("<###>itemStateChanged()" + (e.getStateChange() == 1 ? "Sel." : "Desel.")));
                    if (e.getStateChange() == 1) {
                        ImageObjectParameters.this.getMaxHeightFormattedTextField().setEnabled(true);
                        ImageObjectParameters.this.getMaxDepthFormattedTextField().setEnabled(true);
                        ImageObjectParameters.this.getResolutionFormattedTextField().setEnabled(true);
                        ImageObjectParameters.this.getBathImageSelect().setEnabled(true);
                    } else {
                        ImageObjectParameters.this.getMaxHeightFormattedTextField().setEnabled(false);
                        ImageObjectParameters.this.getMaxDepthFormattedTextField().setEnabled(false);
                        ImageObjectParameters.this.getResolutionFormattedTextField().setEnabled(false);
                        ImageObjectParameters.this.getBathImageSelect().setEnabled(false);
                    }
                }
            });
        }
        return this.batCheckBox;
    }

    private JFormattedTextField getMaxHeightFormattedTextField() {
        if (this.maxHeightFormattedTextField == null) {
            this.maxHeightFormattedTextField = new JFormattedTextField(this.df);
            this.maxHeightFormattedTextField.setPreferredSize(new Dimension(70, 20));
            this.maxHeightFormattedTextField.setText("1.0");
            this.maxHeightFormattedTextField.setEnabled(false);
        }
        return this.maxHeightFormattedTextField;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            this.maxDepthLabel = new JLabel();
            this.maxDepthLabel.setText(I18n.text("Max depth"));
            this.jPanel6 = new JPanel();
            this.jPanel6.add((Component)this.maxDepthLabel, null);
            this.jPanel6.add((Component)this.getMaxDepthFormattedTextField(), null);
        }
        return this.jPanel6;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            this.resolutionLabel = new JLabel();
            this.resolutionLabel.setText(I18n.text("Resolution"));
            this.jPanel7 = new JPanel();
            this.jPanel7.add((Component)this.resolutionLabel, null);
            this.jPanel7.add((Component)this.getResolutionFormattedTextField(), null);
        }
        return this.jPanel7;
    }

    private JFormattedTextField getMaxDepthFormattedTextField() {
        if (this.maxDepthFormattedTextField == null) {
            this.maxDepthFormattedTextField = new JFormattedTextField(this.df);
            this.maxDepthFormattedTextField.setPreferredSize(new Dimension(70, 20));
            this.maxDepthFormattedTextField.setText("0.0");
            this.maxDepthFormattedTextField.setEnabled(false);
        }
        return this.maxDepthFormattedTextField;
    }

    private JFormattedTextField getResolutionFormattedTextField() {
        if (this.resolutionFormattedTextField == null) {
            this.resolutionFormattedTextField = new JFormattedTextField(this.dfI);
            this.resolutionFormattedTextField.setPreferredSize(new Dimension(70, 20));
            this.resolutionFormattedTextField.setText("100");
            this.resolutionFormattedTextField.setEnabled(false);
        }
        return this.resolutionFormattedTextField;
    }

    public boolean getIsBathymetric() {
        return this.getBatCheckBox().isSelected();
    }

    public void setIsBathymetric(boolean val) {
        this.getBatCheckBox().setSelected(val);
    }

    public double getMaxHeight() {
        return Double.parseDouble(this.getMaxHeightFormattedTextField().getText());
    }

    public void setMaxHeight(double val) {
        this.getMaxHeightFormattedTextField().setText(Double.toString(val));
    }

    public double getMaxDepth() {
        return Double.parseDouble(this.getMaxDepthFormattedTextField().getText());
    }

    public void setMaxDepth(double val) {
        this.getMaxDepthFormattedTextField().setText(Double.toString(val));
    }

    public int getResolution() {
        return Integer.parseInt(this.getResolutionFormattedTextField().getText());
    }

    public void setResolution(int val) {
        this.getResolutionFormattedTextField().setText(Integer.toString(val));
    }

    public File getBathimFile() {
        return this.selectedBathymetricImage;
    }

    public void setBathimFile(String filename) {
        if (filename != null) {
            this.selectedBathymetricImage = new File(filename);
        }
    }

    private JPanel getJPanel8() {
        if (this.jPanel8 == null) {
            FlowLayout flowLayout2 = new FlowLayout();
            flowLayout2.setHgap(0);
            flowLayout2.setVgap(0);
            this.jPanel8 = new JPanel();
            this.jPanel8.setLayout(flowLayout2);
            this.jPanel8.setPreferredSize(new Dimension(145, 30));
            this.jPanel8.add((Component)this.getBathImageSelect(), null);
        }
        return this.jPanel8;
    }

    private JButton getBathImageSelect() {
        if (this.bathImageSelect == null) {
            this.bathImageSelect = new JButton();
            this.bathImageSelect.setPreferredSize(new Dimension(145, 26));
            this.bathImageSelect.setText(I18n.text("Bathymetric Image..."));
            this.bathImageSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File imgFile = ImageFileChooser.showOpenImageDialog();
                    if (imgFile != null) {
                        ImageObjectParameters.this.selectedBathymetricImage = imgFile;
                    }
                }
            });
            this.bathImageSelect.setEnabled(false);
        }
        return this.bathImageSelect;
    }

    public File getSelectedBathymetricImage() {
        return this.selectedBathymetricImage;
    }

    public void setSelectedBathymetricImage(File selectedBathymetricImage) {
        this.selectedBathymetricImage = selectedBathymetricImage;
    }

    public static void main(String[] args) {
        GuiUtils.testFrame(new ImageObjectParameters(), "test");
    }
}

