/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.objparams;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pt.lsts.neptus.gui.LocationPanel;
import pt.lsts.neptus.gui.SelectAllFocusListener;
import pt.lsts.neptus.gui.TextureComboChooser;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.ParallelepipedElement;
import pt.lsts.neptus.types.texture.TextureType;
import pt.lsts.neptus.types.texture.TexturesHolder;
import pt.lsts.neptus.util.GuiUtils;

public class ParallelepipedParameters
extends ParametersPanel
implements ActionListener {
    public static final long serialVersionUID = 23756234L;
    private NumberFormat df = GuiUtils.getNeptusDecimalFormat();
    private JLabel jLabel5 = null;
    private JTextField XDim = null;
    private JLabel jLabel6 = null;
    private JTextField YDim = null;
    private JLabel jLabel7 = null;
    private JTextField ZDim = null;
    private JLabel jLabel8 = null;
    private JButton choose = null;
    private JTextField ColorField = null;
    private JLabel jLabel = null;
    private JButton changeCenterLoc = null;
    private LocationType location = new LocationType();
    private JPanel jPanel = null;
    private JLabel jLabel1 = null;
    private JFormattedTextField rollField = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel3 = null;
    private JFormattedTextField pitchField = null;
    private JLabel jLabel9 = null;
    private JLabel jLabel10 = null;
    private JFormattedTextField yawField = null;
    private JPanel jPanel1 = null;
    private JPanel jPanel2 = null;
    private JLabel jLabel4 = null;
    private JLabel jLabel11 = null;
    private JLabel jLabel12 = new JLabel(I18n.text("Texture:"));
    private JLabel lblFilled = new JLabel(I18n.text("Filled:"));
    private JCheckBox chkFilled = new JCheckBox();
    private TextureComboChooser textureCombo;
    private JPanel jPanel3 = null;

    public ParallelepipedParameters() {
        this.initialize();
        this.setPreferredSize(new Dimension(450, 350));
    }

    public void setDimensions(double dimx, double dimy, double dimz) {
        this.getXDim().setText(String.valueOf(dimx));
        this.getYDim().setText(String.valueOf(dimy));
        this.getZDim().setText(String.valueOf(dimz));
    }

    public void setFilled(boolean filled) {
        this.chkFilled.setSelected(filled);
    }

    public void setRotation(double roll, double pitch, double yaw) {
        this.getRollField().setText(String.valueOf(roll));
        this.getPitchField().setText(String.valueOf(pitch));
        this.getYawField().setText(String.valueOf(yaw));
    }

    public TextureType getSelectedTexture() {
        return this.getTexturesCombo().getCurrentlySelectedTexture();
    }

    public double[] getRotation() {
        double[] ret = new double[]{Double.parseDouble(this.getRollField().getText()), Double.parseDouble(this.getPitchField().getText()), Double.parseDouble(this.getYawField().getText())};
        return ret;
    }

    public boolean isFilled() {
        return this.chkFilled.isSelected();
    }

    public void setCenterLocation(LocationType centerLoc) {
        this.location = centerLoc;
    }

    private JTextField getXDim() {
        if (this.XDim == null) {
            this.XDim = new JTextField();
            this.XDim.setPreferredSize(new Dimension(40, 20));
            this.XDim.addFocusListener(new SelectAllFocusListener());
        }
        return this.XDim;
    }

    private JTextField getYDim() {
        if (this.YDim == null) {
            this.YDim = new JTextField();
            this.YDim.setPreferredSize(new Dimension(40, 20));
            this.YDim.addFocusListener(new SelectAllFocusListener());
        }
        return this.YDim;
    }

    private JTextField getZDim() {
        if (this.ZDim == null) {
            this.ZDim = new JTextField();
            this.ZDim.setPreferredSize(new Dimension(40, 20));
            this.ZDim.addFocusListener(new SelectAllFocusListener());
        }
        return this.ZDim;
    }

    private JButton getChoose() {
        if (this.choose == null) {
            this.choose = new JButton();
            this.choose.setText(I18n.text("Choose..."));
            this.choose.setPreferredSize(new Dimension(90, 25));
        }
        return this.choose;
    }

    private JTextField getColorField() {
        if (this.ColorField == null) {
            this.ColorField = new JTextField();
            this.ColorField.setEditable(true);
            this.ColorField.setEnabled(false);
            this.ColorField.setBackground(Color.orange);
            this.ColorField.setPreferredSize(new Dimension(25, 25));
        }
        return this.ColorField;
    }

    private void initialize() {
        GridLayout gridLayout1 = new GridLayout();
        this.jLabel = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel5 = new JLabel();
        this.setLayout(gridLayout1);
        this.setSize(428, 197);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jLabel5.setText(I18n.text("Width:"));
        this.jLabel5.setPreferredSize(new Dimension(60, 20));
        this.jLabel6.setText(I18n.text("Length:"));
        this.jLabel6.setPreferredSize(new Dimension(60, 20));
        this.jLabel7.setText(I18n.text("Height:"));
        this.jLabel7.setPreferredSize(new Dimension(60, 20));
        this.jLabel8.setText(I18n.text("Color:"));
        this.jLabel.setText(I18n.text("Center Location:"));
        gridLayout1.setRows(4);
        this.add((Component)this.getJPanel3(), null);
        this.add((Component)this.getJPanel1(), null);
        this.add((Component)this.getJPanel2(), null);
        this.add((Component)this.getJPanel(), null);
        this.getChoose().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParallelepipedParameters.this.showColorDialog();
            }
        });
    }

    public void setColor(Color color) {
        this.getColorField().setBackground(color);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LocationType tmp = LocationPanel.showLocationDialog(I18n.text("Set the object center location"), this.location, this.getMissionType(), this.isEditable());
        if (tmp != null) {
            this.setLocationType(tmp);
        }
    }

    public void showColorDialog() {
        Color newColor = JColorChooser.showDialog(this, I18n.text("Choose the parallel piped color"), this.getColorField().getBackground());
        this.getColorField().setBackground(newColor);
    }

    private JButton getChangeCenterLoc() {
        if (this.changeCenterLoc == null) {
            this.changeCenterLoc = new JButton();
            this.changeCenterLoc.setText(I18n.text("Change..."));
            this.changeCenterLoc.addActionListener(this);
        }
        return this.changeCenterLoc;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jLabel1 = new JLabel();
            this.jLabel2 = new JLabel();
            this.jLabel3 = new JLabel();
            this.jLabel9 = new JLabel();
            this.jLabel10 = new JLabel();
            this.jLabel1.setText(I18n.text("Roll:"));
            this.jLabel2.setText("   ");
            this.jLabel3.setText(I18n.text("Pitch:"));
            this.jLabel9.setText("   ");
            this.jLabel10.setText(I18n.text("Yaw:"));
            this.jPanel.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Rotation"), 0, 0, null, null));
            this.jPanel.add((Component)this.jLabel1, null);
            this.jPanel.add((Component)this.getRollField(), null);
            this.jPanel.add((Component)this.jLabel2, null);
            this.jPanel.add((Component)this.jLabel3, null);
            this.jPanel.add((Component)this.getPitchField(), null);
            this.jPanel.add((Component)this.jLabel9, null);
            this.jPanel.add((Component)this.jLabel10, null);
            this.jPanel.add((Component)this.getYawField(), null);
        }
        return this.jPanel;
    }

    private JFormattedTextField getRollField() {
        if (this.rollField == null) {
            this.rollField = new JFormattedTextField(this.df);
            this.rollField.setPreferredSize(new Dimension(40, 20));
            this.rollField.setText("0.0");
            this.rollField.setHorizontalAlignment(11);
            this.rollField.addFocusListener(new SelectAllFocusListener());
        }
        return this.rollField;
    }

    private JFormattedTextField getPitchField() {
        if (this.pitchField == null) {
            this.pitchField = new JFormattedTextField(this.df);
            this.pitchField.setPreferredSize(new Dimension(40, 20));
            this.pitchField.setHorizontalAlignment(11);
            this.pitchField.setText("0.0");
            this.pitchField.addFocusListener(new SelectAllFocusListener());
        }
        return this.pitchField;
    }

    private JFormattedTextField getYawField() {
        if (this.yawField == null) {
            this.yawField = new JFormattedTextField(this.df);
            this.yawField.setHorizontalAlignment(11);
            this.yawField.setPreferredSize(new Dimension(40, 20));
            this.yawField.setText("0.0");
            this.yawField.addFocusListener(new SelectAllFocusListener());
        }
        return this.yawField;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            FlowLayout flowLayout3 = new FlowLayout();
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(flowLayout3);
            flowLayout3.setAlignment(0);
            this.jPanel1.add((Component)this.jLabel8, null);
            this.jPanel1.add((Component)this.getColorField(), null);
            this.jPanel1.add((Component)this.getChoose(), null);
            this.jPanel1.add(new JLabel("   "));
            this.jPanel1.add(this.jLabel12);
            this.jPanel1.add(this.getTexturesCombo());
        }
        return this.jPanel1;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jLabel4 = new JLabel();
            this.jLabel11 = new JLabel();
            this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Dimension"), 0, 0, null, null));
            this.jLabel4.setText("   ");
            this.jLabel11.setText("   ");
            this.jPanel2.add((Component)this.jLabel5, null);
            this.jPanel2.add((Component)this.getXDim(), null);
            this.jPanel2.add((Component)this.jLabel4, null);
            this.jPanel2.add((Component)this.jLabel6, null);
            this.jPanel2.add((Component)this.getYDim(), null);
            this.jPanel2.add((Component)this.jLabel11, null);
            this.jPanel2.add((Component)this.jLabel7, null);
            this.jPanel2.add((Component)this.getZDim(), null);
        }
        return this.jPanel2;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            FlowLayout flowLayout2 = new FlowLayout();
            this.jPanel3.setLayout(flowLayout2);
            flowLayout2.setAlignment(0);
            this.jPanel3.add((Component)this.jLabel, null);
            this.jPanel3.add((Component)this.getChangeCenterLoc(), null);
            this.jPanel3.add((Component)this.lblFilled, null);
            this.jPanel3.add((Component)this.chkFilled, null);
        }
        return this.jPanel3;
    }

    public static void main(String[] args) {
        JFrame tstFrame = new JFrame("Dialog Unitary Test");
        tstFrame.setLayout(new BorderLayout());
        ParallelepipedParameters params = new ParallelepipedParameters();
        tstFrame.getContentPane().add((Component)params, "Center");
        tstFrame.setDefaultCloseOperation(3);
        tstFrame.setSize(350, 180);
        tstFrame.setVisible(true);
    }

    @Override
    public String getErrors() {
        ParallelepipedElement obj = new ParallelepipedElement(null, null);
        try {
            obj.setWidth(Float.parseFloat(this.getXDim().getText()));
            obj.setLength(Float.parseFloat(this.getYDim().getText()));
            obj.setHeight(Float.parseFloat(this.getZDim().getText()));
            obj.setColor(this.getColorField().getBackground());
        }
        catch (NumberFormatException e) {
            return I18n.text("The parameters entered are not valid numbers.");
        }
        if (obj.getWidth() < 0.0 || obj.getLength() < 0.0 || obj.getHeight() < 0.0) {
            return I18n.text("The object dimensions have to be positive.");
        }
        return null;
    }

    public double[] getDimension() {
        double[] dim = new double[]{Double.parseDouble(this.getXDim().getText()), Double.parseDouble(this.getYDim().getText()), Double.parseDouble(this.getZDim().getText())};
        return dim;
    }

    public Color getChosenColor() {
        return this.getColorField().getBackground();
    }

    public LocationType getLocationType() {
        return this.location;
    }

    public void setLocationType(LocationType location) {
        this.location = location;
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (!this.isEditable()) {
            this.getChoose().setEnabled(false);
            this.getChangeCenterLoc().setText(I18n.text("View..."));
            this.getXDim().setEditable(false);
            this.getYDim().setEditable(false);
            this.getZDim().setEditable(false);
            this.getYawField().setEditable(false);
            this.getRollField().setEditable(false);
            this.getPitchField().setEditable(false);
        } else {
            this.getChoose().setEnabled(true);
            this.getChangeCenterLoc().setText(I18n.text("Change..."));
            this.getXDim().setEditable(true);
            this.getYDim().setEditable(true);
            this.getZDim().setEditable(true);
            this.getYawField().setEditable(true);
            this.getRollField().setEditable(true);
            this.getPitchField().setEditable(true);
        }
    }

    public TextureComboChooser getTexturesCombo() {
        if (this.textureCombo == null) {
            this.textureCombo = TexturesHolder.getTextureListChooser();
        }
        return this.textureCombo;
    }
}

