/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.objparams;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.LocationPanel;
import pt.lsts.neptus.gui.objparams.ParametersPanel;
import pt.lsts.neptus.gui.objparams.TranspondersPositionHelper;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.TransponderUtils;
import pt.lsts.neptus.types.mission.MapMission;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.conf.ConfigFetch;
import pt.lsts.neptus.util.editors.EditorLauncher;

public class TransponderParameters
extends ParametersPanel {
    private static final long serialVersionUID = 7696810945439062905L;
    private LocationPanel locationPanel = null;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JComboBox<String> configurationFile = null;
    private JButton editBtn = null;
    private CoordinateSystem homeRef = null;
    private JButton jButton = null;
    private JLabel jLabel1 = null;
    private JTextField idEditor;

    public TransponderParameters(CoordinateSystem homeRef, JTextField idEditor) {
        this.idEditor = idEditor;
        this.homeRef = homeRef;
        this.initialize();
        this.setPreferredSize(new Dimension(470, 530));
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getLocationPanel(), "Center");
        this.add((Component)this.getJPanel(), "South");
    }

    @Override
    public String getErrors() {
        if (this.getConfigurationFile().getSelectedItem() == null) {
            return I18n.text("A configuration file must be selected");
        }
        if (this.getLocationPanel().getErrors() != null) {
            return this.getLocationPanel().getErrors();
        }
        return null;
    }

    public void setIdEditor(JTextField idEditor) {
        this.idEditor = idEditor;
    }

    public void setLocation(LocationType location) {
        this.getLocationPanel().setLocationType(location);
    }

    public void setMap(MapType map) {
        this.getLocationPanel().setMissionType(this.getMissionType());
        if (map.getMission() != null) {
            this.getLocationPanel().setMissionType(map.getMission());
        } else {
            MissionType mt = new MissionType();
            MapMission mapm = new MapMission();
            mapm.setMap(map);
            mt.addMap(mapm);
            MapGroup.getMapGroupInstance(mt);
        }
    }

    public LocationPanel getLocationPanel() {
        if (this.locationPanel == null) {
            this.locationPanel = new LocationPanel(this.getMissionType());
            this.locationPanel.hideButtons();
            this.locationPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.locationPanel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabel1 = new JLabel();
            FlowLayout flowLayout1 = new FlowLayout();
            this.jLabel = new JLabel();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(flowLayout1);
            this.jLabel.setText(I18n.text("Configuration File: "));
            flowLayout1.setHgap(5);
            this.jLabel1.setText("      ");
            this.jPanel.add((Component)this.getJButton(), null);
            this.jPanel.add((Component)this.jLabel1, null);
            this.jPanel.add((Component)this.jLabel, null);
            this.jPanel.add(this.getConfigurationFile(), null);
            this.jPanel.add((Component)this.getEditBtn(), null);
        }
        return this.jPanel;
    }

    private JComboBox<String> getConfigurationFile() {
        if (this.configurationFile == null) {
            String[] confs = TransponderUtils.getTranspondersConfsNamesList();
            this.configurationFile = new JComboBox<String>(confs);
            this.configurationFile.setPreferredSize(new Dimension(150, 20));
            this.configurationFile.setEditable(false);
            this.configurationFile.setEnabled(true);
            this.configurationFile.setSelectedIndex(0);
            this.configurationFile.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String beaconIDItem;
                    if (e.getStateChange() == 1 && (beaconIDItem = (String)e.getItem()) != null) {
                        TransponderParameters.this.updateIdFromConfiguration(beaconIDItem);
                    }
                }
            });
        }
        return this.configurationFile;
    }

    public String getConfiguration() {
        return (String)this.getConfigurationFile().getSelectedItem();
    }

    public void setConfiguration(String configuration) {
        if (configuration == null) {
            this.updateIdFromConfiguration((String)this.getConfigurationFile().getSelectedItem());
            return;
        }
        this.getConfigurationFile().setSelectedItem(configuration);
        this.updateIdFromConfiguration((String)this.getConfigurationFile().getSelectedItem());
    }

    private void updateIdFromConfiguration(String beaconIDItem) {
        this.idEditor.setText(beaconIDItem.replaceAll("\\.conf$", ""));
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText(I18n.text("Triangulation"));
            this.jButton.setPreferredSize(new Dimension(110, 25));
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LocationType lt = TranspondersPositionHelper.showTranspondersPositionHelperDialog(TransponderParameters.this.homeRef, TransponderParameters.this);
                    if (lt != null) {
                        TransponderParameters.this.setLocation(lt);
                    }
                }
            });
        }
        return this.jButton;
    }

    @Override
    public void setEditable(boolean value) {
        super.setEditable(value);
        this.locationPanel.setEditable(this.isEditable());
        if (!this.isEditable()) {
            this.getConfigurationFile().setEnabled(false);
            this.getJButton().setEnabled(false);
        } else {
            this.getConfigurationFile().setEnabled(true);
            this.getJButton().setEnabled(true);
        }
    }

    public JButton getEditBtn() {
        if (this.editBtn == null) {
            this.editBtn = new JButton(I18n.text("Edit file"));
            this.editBtn.setPreferredSize(new Dimension(110, 25));
            this.editBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(new JFrame(), "<html><strong>" + I18n.text("Full attention when altering this file") + "</strong>" + ", <br>" + I18n.text("The changes will apply to all existing missions!") + "</html>", I18n.text("Warning"), 2);
                    new EditorLauncher().editFile(ConfigFetch.resolvePath("maps/" + TransponderParameters.this.getConfigurationFile().getSelectedItem()));
                }
            });
        }
        return this.editBtn;
    }

    public CoordinateSystem getHomeRef() {
        return this.homeRef;
    }

    public void setHomeRef(CoordinateSystem homeRef) {
        this.homeRef = homeRef;
    }

    public static void main(String[] args) {
        JFrame testFrame = new JFrame("Teste Unitario");
        TransponderParameters nmp = new TransponderParameters(new CoordinateSystem(), new JTextField("id"));
        testFrame.add(nmp);
        testFrame.setSize(453, 450);
        testFrame.setVisible(true);
        Vector<String> aTranspondersFiles = new Vector<String>();
        File dir = new File("maps/");
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                NeptusLog.pub().info((Object)("<###> " + name + ": " + name.matches("^(lsts[0-9]+\\.conf)|([A-Za-z]+[0-9]+\\.conf)$")));
                return name.matches("^(lsts[0-9]+\\.conf)|([A-Za-z]+[0-9]+\\.conf)$");
            }
        });
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.getName().startsWith("lsts") && !o2.getName().startsWith("lsts")) {
                    return -1;
                }
                if (!o1.getName().startsWith("lsts") && o2.getName().startsWith("lsts")) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        for (File file : files) {
            NeptusLog.pub().info((Object)("<###> " + file.getName()));
            aTranspondersFiles.add(file.getName());
        }
    }
}

