/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.objparams;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.CoordinateSystemPanel;
import pt.lsts.neptus.gui.ImagePanel;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.MathMiscUtils;

public class TranspondersPositionHelper
extends JPanel {
    private static final long serialVersionUID = -104139574067820066L;
    private JPanel transPanel = null;
    private ImagePanel imagePanel = null;
    private JPanel jPanel = null;
    private JLabel latLabel = null;
    private JLabel latValue = null;
    private JLabel lonValue = null;
    private JLabel lonLabel = null;
    private JPanel jPanel1 = null;
    private JLabel jLabel = null;
    private JTextField t1DepthValue = null;
    private JPanel pointPa = null;
    private JLabel pointPaXLabel = null;
    private JTextField pointPaX = null;
    private JLabel pointPaYLabel = null;
    private JTextField pointPaY = null;
    private JPanel pointPb = null;
    private JLabel pointPbXLabel = null;
    private JTextField pointPbX = null;
    private JLabel pointPbYLabel = null;
    private JTextField pointPbY = null;
    private JPanel distances = null;
    private JLabel da1Label = null;
    private JLabel db1Label = null;
    private JTextField da1Value = null;
    private JTextField db1Value = null;
    private JPanel jPanel2 = null;
    private JButton calcButton = null;
    private JButton jButton = null;
    private JButton jButton1 = null;
    private JPanel jPanel3 = null;
    private JTextArea resultsTextArea = null;
    private double t1Depth = 0.0;
    private double paY = 0.0;
    private double pbY = 0.0;
    private double da1 = 0.0;
    private double daH1 = 0.0;
    private double db1 = 0.0;
    private double dbH1 = 0.0;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double offsetNorth = 0.0;
    private double offsetEast = 0.0;
    private double yawHR = 0.0;
    private String lat = "";
    private String lon = "";
    private double legacyOffsetDistance = 0.0;
    private double legacyTheta = 0.0;
    private double legacyOffsetNorth = 0.0;
    private double legacyOffsetEast = 0.0;
    private LocationType location = null;
    private boolean calculatedOnceOk = false;
    private JPanel jContentPane = null;
    private JDialog jDialog = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JLabel legOffsetNLabel = null;
    private JLabel legOffsetELabel = null;
    private JLabel jLabel5 = null;
    private JLabel jLabel6 = null;
    private JLabel jLabel7 = null;
    private JLabel legOffsetDLabel = null;
    private JLabel legAziLabel = null;
    private JLabel legPsiLabel = null;
    private JPanel jContentPane1 = null;
    private JFrame jFrame = null;

    public TranspondersPositionHelper(CoordinateSystem cs) {
        this.lat = cs.getLatitudeStr();
        this.lon = cs.getLongitudeStr();
        this.yawHR = cs.getYaw();
        double[] cyl = CoordinateUtil.sphericalToCylindricalCoordinates(cs.getOffsetDistance(), cs.getAzimuth(), cs.getZenith());
        this.legacyOffsetDistance = MathMiscUtils.round(cyl[0], 3);
        this.legacyTheta = MathMiscUtils.round(Math.toDegrees(cyl[1]), 3);
        this.legacyOffsetNorth = cs.getOffsetNorth();
        this.legacyOffsetEast = cs.getOffsetEast();
        this.initialize();
    }

    private JPanel getTransPanel() {
        if (this.transPanel == null) {
            this.transPanel = new JPanel();
            this.transPanel.setLayout(null);
            this.transPanel.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Transponders Location Helper"), 0, 0, null, null));
            this.transPanel.add((Component)this.getImagePanel(), null);
            this.transPanel.add((Component)this.getJPanel(), null);
            this.transPanel.add((Component)this.getJPanel1(), null);
            this.transPanel.add((Component)this.getJPanel2(), null);
            this.transPanel.add((Component)this.getJPanel3(), null);
        }
        return this.transPanel;
    }

    private ImagePanel getImagePanel() {
        if (this.imagePanel == null) {
            Image image = ImageUtils.getImage("images/transloc.png");
            this.imagePanel = new ImagePanel(image);
            this.imagePanel.setPreferredSize(new Dimension(232, 169));
            this.imagePanel.setLocation(9, 19);
            this.imagePanel.setSize(232, 169);
        }
        return this.imagePanel;
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(423, 560);
        this.add((Component)this.getTransPanel(), null);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.legPsiLabel = new JLabel();
            this.legAziLabel = new JLabel();
            this.legOffsetDLabel = new JLabel();
            this.jLabel7 = new JLabel();
            this.jLabel6 = new JLabel();
            this.jLabel5 = new JLabel();
            this.legOffsetELabel = new JLabel();
            this.legOffsetNLabel = new JLabel();
            this.jLabel2 = new JLabel();
            this.jLabel1 = new JLabel();
            this.jPanel = new JPanel();
            this.lonLabel = new JLabel();
            this.lonValue = new JLabel();
            this.latLabel = new JLabel();
            this.latValue = new JLabel();
            this.jPanel.setLayout(null);
            this.jPanel.setBounds(251, 19, 160, 167);
            this.jPanel.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Axis origin (Home Ref.)"), 0, 0, null, null));
            this.latLabel.setText(I18n.text("Lat"));
            this.latLabel.setBounds(5, 19, 21, 19);
            this.latValue.setBounds(30, 19, 128, 19);
            this.latValue.setText(this.lat);
            this.lonValue.setBounds(30, 43, 128, 19);
            this.lonValue.setText(this.lon);
            this.lonLabel.setBounds(5, 43, 21, 19);
            this.lonLabel.setText(I18n.text("Lon"));
            this.jLabel1.setBounds(5, 64, 45, 19);
            this.jLabel1.setText(I18n.text("OffsetN"));
            this.jLabel2.setBounds(5, 86, 45, 19);
            this.jLabel2.setText(I18n.text("OffsetE"));
            this.legOffsetNLabel.setBounds(55, 62, 104, 20);
            this.legOffsetNLabel.setText(Double.toString(this.legacyOffsetNorth));
            this.legOffsetELabel.setBounds(55, 86, 105, 20);
            this.legOffsetELabel.setText(Double.toString(this.legacyOffsetEast));
            this.jLabel5.setBounds(5, 108, 45, 15);
            this.jLabel5.setText(I18n.text("Off.Dist"));
            this.jLabel6.setBounds(5, 127, 48, 17);
            this.jLabel6.setText(I18n.text("Azimuth"));
            this.jLabel7.setBounds(5, 146, 32, 14);
            this.jLabel7.setText(I18n.text("Psi"));
            this.legOffsetDLabel.setBounds(55, 108, 106, 17);
            this.legOffsetDLabel.setText(Double.toString(this.legacyOffsetDistance));
            this.legAziLabel.setBounds(55, 128, 104, 15);
            this.legAziLabel.setText(Double.toString(this.legacyTheta) + "\u00b0");
            this.legPsiLabel.setBounds(55, 146, 105, 17);
            this.legPsiLabel.setText(Double.toString(this.yawHR) + "\u00b0");
            this.jPanel.add((Component)this.lonLabel, null);
            this.jPanel.add((Component)this.latLabel, null);
            this.jPanel.add((Component)this.latValue, null);
            this.jPanel.add((Component)this.lonValue, null);
            this.jPanel.add((Component)this.jLabel1, null);
            this.jPanel.add((Component)this.jLabel2, null);
            this.jPanel.add((Component)this.legOffsetNLabel, null);
            this.jPanel.add((Component)this.legOffsetELabel, null);
            this.jPanel.add((Component)this.jLabel5, null);
            this.jPanel.add((Component)this.jLabel6, null);
            this.jPanel.add((Component)this.jLabel7, null);
            this.jPanel.add((Component)this.legOffsetDLabel, null);
            this.jPanel.add((Component)this.legAziLabel, null);
            this.jPanel.add((Component)this.legPsiLabel, null);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jLabel = new JLabel();
            this.jPanel1.setLayout(null);
            this.jPanel1.setBounds(10, 196, 402, 230);
            this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Inputs"), 0, 0, null, null));
            this.jLabel.setText(I18n.text("Transponder depth (m):"));
            this.jLabel.setBounds(10, 19, 135, 16);
            this.jPanel1.add((Component)this.jLabel, null);
            this.jPanel1.add((Component)this.getT1DepthValue(), null);
            this.jPanel1.add((Component)this.getPointPa(), null);
            this.jPanel1.add((Component)this.getPointPb(), null);
            this.jPanel1.add((Component)this.getDistancies(), null);
        }
        return this.jPanel1;
    }

    private JTextField getT1DepthValue() {
        if (this.t1DepthValue == null) {
            this.t1DepthValue = new JTextField();
            this.t1DepthValue.setBounds(150, 18, 84, 20);
            this.t1DepthValue.setText("0");
        }
        return this.t1DepthValue;
    }

    private JPanel getPointPa() {
        if (this.pointPa == null) {
            this.pointPa = new JPanel();
            this.pointPaXLabel = new JLabel();
            this.pointPaYLabel = new JLabel();
            this.pointPa.setBounds(7, 43, 384, 56);
            this.pointPa.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Point Pa"), 0, 0, null, null));
            this.pointPaXLabel.setText(I18n.text("x (m):"));
            this.pointPaXLabel.setPreferredSize(new Dimension(35, 19));
            this.pointPaYLabel.setText("      " + I18n.text("y (m):"));
            this.pointPaYLabel.setPreferredSize(new Dimension(50, 19));
            this.pointPa.add((Component)this.pointPaXLabel, null);
            this.pointPa.add((Component)this.getPointPaX(), null);
            this.pointPa.add((Component)this.pointPaYLabel, null);
            this.pointPa.add((Component)this.getPointPaY(), null);
        }
        return this.pointPa;
    }

    private JTextField getPointPaX() {
        if (this.pointPaX == null) {
            this.pointPaX = new JTextField();
            this.pointPaX.setPreferredSize(new Dimension(84, 20));
            this.pointPaX.setText("0");
            this.pointPaX.setEnabled(true);
            this.pointPaX.setEditable(false);
        }
        return this.pointPaX;
    }

    private JTextField getPointPaY() {
        if (this.pointPaY == null) {
            this.pointPaY = new JTextField();
            this.pointPaY.setPreferredSize(new Dimension(84, 20));
            this.pointPaY.setText("0");
        }
        return this.pointPaY;
    }

    private JPanel getPointPb() {
        if (this.pointPb == null) {
            this.pointPb = new JPanel();
            this.pointPbXLabel = new JLabel();
            this.pointPbYLabel = new JLabel();
            this.pointPb.setBounds(7, 104, 384, 56);
            this.pointPb.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Point Pb"), 0, 0, null, null));
            this.pointPbXLabel.setText(I18n.text("x (m):"));
            this.pointPbXLabel.setPreferredSize(new Dimension(35, 19));
            this.pointPbYLabel.setText("      " + I18n.text("y (m):"));
            this.pointPbYLabel.setPreferredSize(new Dimension(50, 19));
            this.pointPb.add((Component)this.pointPbXLabel, null);
            this.pointPb.add((Component)this.getPointPbX(), null);
            this.pointPb.add((Component)this.pointPbYLabel, null);
            this.pointPb.add((Component)this.getPointPbY(), null);
        }
        return this.pointPb;
    }

    private JTextField getPointPbX() {
        if (this.pointPbX == null) {
            this.pointPbX = new JTextField();
            this.pointPbX.setPreferredSize(new Dimension(84, 20));
            this.pointPbX.setText("0");
            this.pointPbX.setEnabled(true);
            this.pointPbX.setEditable(false);
        }
        return this.pointPbX;
    }

    private JTextField getPointPbY() {
        if (this.pointPbY == null) {
            this.pointPbY = new JTextField();
            this.pointPbY.setPreferredSize(new Dimension(84, 20));
            this.pointPbY.setText("0");
        }
        return this.pointPbY;
    }

    private JPanel getDistancies() {
        if (this.distances == null) {
            this.distances = new JPanel();
            this.da1Label = new JLabel();
            this.db1Label = new JLabel();
            this.distances.setBounds(7, 165, 384, 56);
            this.distances.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Distances"), 0, 0, null, null));
            this.da1Label.setText(I18n.text("da1 (m):"));
            this.da1Label.setPreferredSize(new Dimension(50, 19));
            this.db1Label.setText("     " + I18n.text("db1 (m):"));
            this.db1Label.setPreferredSize(new Dimension(65, 19));
            this.distances.add((Component)this.da1Label, null);
            this.distances.add((Component)this.getDa1Value(), null);
            this.distances.add((Component)this.db1Label, null);
            this.distances.add((Component)this.getDb1Value(), null);
        }
        return this.distances;
    }

    private JTextField getDa1Value() {
        if (this.da1Value == null) {
            this.da1Value = new JTextField();
            this.da1Value.setPreferredSize(new Dimension(84, 20));
            this.da1Value.setText("0");
        }
        return this.da1Value;
    }

    private JTextField getDb1Value() {
        if (this.db1Value == null) {
            this.db1Value = new JTextField();
            this.db1Value.setPreferredSize(new Dimension(84, 20));
            this.db1Value.setText("0");
        }
        return this.db1Value;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            FlowLayout flowLayout1 = new FlowLayout();
            this.jPanel2.setLayout(flowLayout1);
            this.jPanel2.setBounds(13, 510, 402, 39);
            flowLayout1.setAlignment(2);
            this.jPanel2.add((Component)this.getCalcButton(), null);
            this.jPanel2.add((Component)this.getJButton(), null);
            this.jPanel2.add((Component)this.getJButton1(), null);
        }
        return this.jPanel2;
    }

    private JButton getCalcButton() {
        if (this.calcButton == null) {
            this.calcButton = new JButton();
            this.calcButton.setHorizontalAlignment(0);
            this.calcButton.setText(I18n.text("Calculate"));
            this.calcButton.setPreferredSize(new Dimension(87, 26));
            this.calcButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TranspondersPositionHelper.this.calculate();
                }
            });
        }
        return this.calcButton;
    }

    private boolean calculate() {
        boolean ret = this.collectVariables();
        if (!ret) {
            JOptionPane.showMessageDialog(this.getTransPanel().getParent(), "<html>" + I18n.text("The calculation was not possible.<br> Some inputs are not valid!") + "</html>");
            return false;
        }
        this.daH1 = Math.sqrt(Math.pow(this.da1, 2.0) - Math.pow(this.t1Depth, 2.0));
        this.dbH1 = Math.sqrt(Math.pow(this.db1, 2.0) - Math.pow(this.t1Depth, 2.0));
        this.offsetY = (Math.pow(this.daH1, 2.0) - Math.pow(this.dbH1, 2.0) + Math.pow(this.pbY, 2.0) - Math.pow(this.paY, 2.0)) / (2.0 * this.pbY - 2.0 * this.paY);
        this.offsetX = Math.sqrt(Math.pow(this.daH1, 2.0) - Math.pow(this.offsetY - this.paY, 2.0));
        double[] offsetsIne = CoordinateUtil.bodyFrameToInertialFrame(this.offsetX, this.offsetY, 0.0, 0.0, 0.0, Math.toRadians(this.yawHR));
        this.offsetNorth = MathMiscUtils.round(offsetsIne[0], 3) + this.legacyOffsetNorth;
        this.offsetEast = MathMiscUtils.round(offsetsIne[1], 3) + this.legacyOffsetEast;
        this.calculatedOnceOk = true;
        this.presentResults();
        return true;
    }

    private void presentResults() {
        String res = "";
        res = res + I18n.text("Lat") + ": " + this.lat;
        res = res + "    " + I18n.text("Lon") + ": " + this.lon;
        res = res + "    " + I18n.text("Depth") + ": " + this.t1Depth;
        res = res + "\n" + I18n.text("Offset north") + ": " + this.offsetNorth;
        res = res + "    " + I18n.text("Offset east") + ": " + this.offsetEast;
        res = res + "\n" + I18n.text("Offset distance") + ": " + this.legacyOffsetDistance;
        res = res + "    " + I18n.text("Azimuth") + ": " + this.legacyTheta + "\u00b0";
        this.getResultsTextArea().setText(res);
    }

    private boolean collectVariables() {
        try {
            this.paY = Double.parseDouble(this.getPointPaY().getText());
            this.pbY = Double.parseDouble(this.getPointPbY().getText());
            this.da1 = Double.parseDouble(this.getDa1Value().getText());
            this.db1 = Double.parseDouble(this.getDb1Value().getText());
            this.t1Depth = Double.parseDouble(this.getT1DepthValue().getText());
        }
        catch (NumberFormatException e) {
            NeptusLog.pub().error((Object)(this + ": " + e.getMessage()));
            return false;
        }
        return true;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText(I18n.text("Ok"));
            this.jButton.setPreferredSize(new Dimension(87, 26));
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TranspondersPositionHelper.this.calculatedOnceOk) {
                        LocationType loc = new LocationType();
                        loc.setLatitudeStr(TranspondersPositionHelper.this.lat);
                        loc.setLongitudeStr(TranspondersPositionHelper.this.lon);
                        loc.setDepth(TranspondersPositionHelper.this.t1Depth);
                        loc.setOffsetNorth(TranspondersPositionHelper.this.offsetNorth);
                        loc.setOffsetEast(TranspondersPositionHelper.this.offsetEast);
                        loc.setOffsetDistance(TranspondersPositionHelper.this.legacyOffsetDistance);
                        loc.setAzimuth(TranspondersPositionHelper.this.legacyTheta);
                        TranspondersPositionHelper.this.location = loc;
                    } else {
                        TranspondersPositionHelper.this.location = null;
                    }
                    TranspondersPositionHelper.this.jDialog.setVisible(false);
                    TranspondersPositionHelper.this.jDialog.dispose();
                }
            });
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
            this.jButton1.setText(I18n.text("Cancel"));
            this.jButton1.setPreferredSize(new Dimension(87, 26));
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TranspondersPositionHelper.this.location = null;
                    if (TranspondersPositionHelper.this.jDialog != null) {
                        TranspondersPositionHelper.this.jDialog.setVisible(false);
                        TranspondersPositionHelper.this.jDialog.dispose();
                    }
                    if (TranspondersPositionHelper.this.jFrame != null) {
                        TranspondersPositionHelper.this.jFrame.setVisible(false);
                        TranspondersPositionHelper.this.jFrame.dispose();
                    }
                }
            });
        }
        return this.jButton1;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new BorderLayout());
            this.jPanel3.setBounds(10, 433, 402, 71);
            this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, I18n.text("Result"), 0, 0, null, null));
            this.jPanel3.add((Component)this.getResultsTextArea(), "Center");
        }
        return this.jPanel3;
    }

    private JTextArea getResultsTextArea() {
        if (this.resultsTextArea == null) {
            this.resultsTextArea = new JTextArea();
            this.resultsTextArea.setEditable(false);
        }
        return this.resultsTextArea;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
        }
        return this.jContentPane;
    }

    private JDialog getJDialog(JComponent parent) {
        Window tmpP = parent != null ? SwingUtilities.getWindowAncestor(parent) : null;
        Window windowParent = tmpP != null ? tmpP : new JFrame();
        if (this.jDialog == null) {
            this.jDialog = new JDialog(windowParent);
            this.jDialog.setContentPane(this.getJContentPane());
            this.jDialog.setTitle(I18n.text("Triangulating transponder position"));
            this.jDialog.setSize(this.getWidth() + 5, this.getHeight() + 35);
            this.jDialog.setLayout(new BorderLayout());
            this.jDialog.getContentPane().add((Component)this, "Center");
            this.jDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            this.jDialog.setAlwaysOnTop(false);
            GuiUtils.centerOnScreen(this.jDialog);
            this.jDialog.setResizable(false);
            this.jDialog.setAlwaysOnTop(false);
            this.jDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TranspondersPositionHelper.this.location = null;
                    TranspondersPositionHelper.this.jDialog.setVisible(false);
                    TranspondersPositionHelper.this.jDialog.dispose();
                }
            });
            this.jDialog.setVisible(true);
        }
        return this.jDialog;
    }

    public LocationType getLocationType() {
        return this.location;
    }

    public static LocationType showTranspondersPositionHelperDialog(CoordinateSystem homeRef, JComponent parent) {
        Window tmpP = parent != null ? SwingUtilities.getWindowAncestor(parent) : null;
        Window windowParent = tmpP != null ? tmpP : new JFrame();
        CoordinateSystem cs = new CoordinateSystem();
        cs.setCoordinateSystem(homeRef);
        if (1 == JOptionPane.showConfirmDialog(windowParent, I18n.text("Do you want to base the triangulation on home reference?"), "", 0)) {
            cs = CoordinateSystemPanel.showCoordinateSystemDialog(I18n.text("Set reference"), cs, parent);
        }
        if (cs == null) {
            return null;
        }
        TranspondersPositionHelper tph = new TranspondersPositionHelper(cs);
        tph.getJDialog(parent);
        return tph.getLocationType();
    }

    public static LocationType showTranspondersPositionHelperFrame(CoordinateSystem homeRef, JComponent parent) {
        Window tmpP = parent != null ? SwingUtilities.getWindowAncestor(parent) : null;
        Window windowParent = tmpP != null ? tmpP : new JFrame();
        CoordinateSystem cs = new CoordinateSystem();
        cs.setCoordinateSystem(homeRef);
        if (1 == JOptionPane.showConfirmDialog(windowParent, I18n.text("Do you want to base the triangulation on home reference?"), "", 0)) {
            cs = CoordinateSystemPanel.showCoordinateSystemDialog(I18n.text("Set reference"), cs, parent);
        }
        if (cs == null) {
            return null;
        }
        TranspondersPositionHelper tph = new TranspondersPositionHelper(cs);
        tph.getJFrame();
        return tph.getLocationType();
    }

    private JPanel getJContentPane1() {
        if (this.jContentPane1 == null) {
            this.jContentPane1 = new JPanel();
            this.jContentPane1.setLayout(new BorderLayout());
        }
        return this.jContentPane1;
    }

    private JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            this.jFrame.setContentPane(this.getJContentPane1());
            this.jFrame.setTitle("");
            this.jFrame.setSize(this.getWidth() + 5, this.getHeight() + 35);
            this.jFrame.setIconImage(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/neptus-icon.png"))).getImage());
            this.jFrame.setLayout(new BorderLayout());
            this.jFrame.getContentPane().add((Component)this, "Center");
            this.jFrame.setAlwaysOnTop(true);
            GuiUtils.centerOnScreen(this.jFrame);
            this.jFrame.setVisible(true);
            this.jFrame.setResizable(false);
            this.jFrame.setAlwaysOnTop(true);
            this.jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TranspondersPositionHelper.this.location = null;
                    TranspondersPositionHelper.this.jFrame.setVisible(false);
                    TranspondersPositionHelper.this.jFrame.dispose();
                }
            });
        }
        return this.jFrame;
    }

    public static void main(String[] args) {
        CoordinateSystem cs = new CoordinateSystem();
        cs.setYaw(73.5);
        cs = CoordinateSystemPanel.showCoordinateSystemDialog("Set the HomeRef", cs, null);
        TranspondersPositionHelper.showTranspondersPositionHelperDialog(cs, null);
        NeptusLog.pub().info((Object)"<###>dfs");
    }
}

