/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.properties;

import java.util.Vector;
import pt.lsts.neptus.gui.properties.VerifyingProperty;

public class BoundedNumericalProperty
extends VerifyingProperty {
    private static final long serialVersionUID = 1L;
    private double minVal;
    private double maxVal;

    public BoundedNumericalProperty(double minVal, double maxVal) {
        this.maxVal = maxVal;
        this.minVal = minVal;
    }

    @Override
    public Vector<String> verifyErrors(Object value) {
        Vector<String> errors = new Vector<String>();
        if (value instanceof Number) {
            double val = ((Number)value).doubleValue();
            if (val < this.minVal) {
                errors.add("The minimum allowed value for the property " + this.getName() + " is " + this.minVal);
                return errors;
            }
            if (val > this.maxVal) {
                errors.add("The maximum allowed value for the property " + this.getName() + " is " + this.maxVal);
                return errors;
            }
            return errors;
        }
        errors.add("The property " + this.getName() + " must have a numerical value");
        return errors;
    }

    public double getMinVal() {
        return this.minVal;
    }

    public void setMinVal(double minVal) {
        this.minVal = minVal;
    }

    public double getMaxVal() {
        return this.maxVal;
    }

    public void setMaxVal(double maxVal) {
        this.maxVal = maxVal;
    }
}

