/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.properties;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.util.LinkedHashMap;
import java.util.Vector;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.properties.VerifyingProperty;
import pt.lsts.neptus.types.coord.LocationType;

public class PropertiesBag
implements PropertiesProvider {
    private String propertiesDialogTitle = "Properties";
    private LinkedHashMap<String, DefaultProperty> properties = new LinkedHashMap();

    @Override
    public DefaultProperty[] getProperties() {
        return this.properties.values().toArray(new DefaultProperty[0]);
    }

    public void addProperty(DefaultProperty dp) {
        this.properties.put(dp.getName(), dp);
    }

    public void setProperty(String key, Object value) {
        if (this.properties.containsKey(key)) {
            this.properties.get(key).setValue(value);
        }
    }

    @Override
    public String getPropertiesDialogTitle() {
        return this.propertiesDialogTitle;
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        Vector<String> errors = new Vector<String>();
        for (Property p : properties) {
            if (!(p instanceof VerifyingProperty)) continue;
            VerifyingProperty vp = (VerifyingProperty)p;
            errors.addAll(vp.verifyErrors(p.getValue()));
        }
        return null;
    }

    @Override
    public void setProperties(Property[] properties) {
        for (Property p : properties) {
            if (p instanceof DefaultProperty) {
                this.properties.put(p.getName(), (DefaultProperty)p);
                continue;
            }
            this.properties.put(p.getName(), PropertiesBag.cloneProperty(p));
        }
    }

    public void setPropertiesDialogTitle(String propertiesDialogTitle) {
        this.propertiesDialogTitle = propertiesDialogTitle;
    }

    private static DefaultProperty cloneProperty(Property p) {
        DefaultProperty dp = new DefaultProperty();
        dp.setName(p.getName());
        dp.setDisplayName(p.getDisplayName());
        dp.setCategory(dp.getCategory());
        dp.setShortDescription(p.getShortDescription());
        dp.setParentProperty(p.getParentProperty());
        dp.setEditable(p.isEditable());
        dp.setType(p.getType());
        for (Property sp : p.getSubProperties()) {
            dp.addSubProperty(sp);
        }
        dp.setValue(p.getValue());
        return dp;
    }

    public PropertiesBag clone() {
        PropertiesBag clone = new PropertiesBag();
        clone.setPropertiesDialogTitle(this.getPropertiesDialogTitle());
        LinkedHashMap<String, DefaultProperty> props = new LinkedHashMap<String, DefaultProperty>();
        for (String key : this.properties.keySet()) {
            props.put(key, PropertiesBag.cloneProperty((Property)this.properties.get(key)));
        }
        clone.properties = props;
        return clone;
    }

    public LocationType getLocationProperty(String key) {
        DefaultProperty dp = this.properties.get(key);
        if (dp != null && dp.getValue() instanceof LocationType) {
            return new LocationType((LocationType)dp.getValue());
        }
        return null;
    }

    public double getDoubleProperty(String key) {
        DefaultProperty dp = this.properties.get(key);
        if (dp.getValue() instanceof Number) {
            return ((Number)dp.getValue()).doubleValue();
        }
        return Double.NaN;
    }

    public float getFloatProperty(String key) {
        DefaultProperty dp = this.properties.get(key);
        if (dp != null && dp.getValue() instanceof Number) {
            return ((Number)dp.getValue()).floatValue();
        }
        return Float.NaN;
    }

    public int getIntProperty(String key) {
        DefaultProperty dp = this.properties.get(key);
        if (dp != null && dp.getValue() instanceof Number) {
            return ((Number)dp.getValue()).intValue();
        }
        return 0;
    }

    public String getStringProperty(String key) {
        DefaultProperty dp = this.properties.get(key);
        if (dp != null) {
            return dp.getValue().toString();
        }
        return null;
    }

    public Object getPropertyValue(String key) {
        DefaultProperty dp = this.properties.get(key);
        if (dp != null) {
            return dp.getValue();
        }
        return null;
    }

    public Vector<DefaultProperty> getPropertiesAsVector() {
        Vector<DefaultProperty> vec = new Vector<DefaultProperty>();
        for (DefaultProperty dp : this.properties.values()) {
            vec.add(dp);
        }
        return vec;
    }
}

