/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import pt.lsts.neptus.gui.SelectAllFocusListener;
import pt.lsts.neptus.gui.tablelayout.TableLayout;
import pt.lsts.neptus.util.GuiUtils;

public class AnglePanel
extends JPanel {
    private static double choosenAngle = 0.0;
    private double angleRads = 0.0;
    private TrigoCircle trigo = new TrigoCircle();
    private JFormattedTextField radsField = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat(3));
    private JFormattedTextField degsField = new JFormattedTextField(GuiUtils.getNeptusDecimalFormat(3));
    private boolean negValuesAllowed = false;

    public static double angleDialogRads(Component parentComponent, double angleRads) {
        return AnglePanel.angleDialogRads(parentComponent, angleRads, false);
    }

    public static double angleDialogRads(Component parentComponent, double angleRads, boolean negValues) {
        choosenAngle = angleRads;
        final AnglePanel aPanel = new AnglePanel();
        if (negValues) {
            aPanel.negValuesAllowed(true);
        } else {
            aPanel.negValuesAllowed(false);
        }
        aPanel.setAngleRads(angleRads);
        final JDialog dialog = parentComponent != null ? new JDialog(SwingUtilities.getWindowAncestor(parentComponent)) : new JDialog();
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)aPanel, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        JCheckBox negAngles = new JCheckBox("+/- values");
        negAngles.setSelected(false);
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        okButton.setPreferredSize(new Dimension(60, 25));
        cancelButton.setPreferredSize(new Dimension(60, 25));
        buttonsPanel.add(negAngles);
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                choosenAngle = aPanel.getAngleRads();
                dialog.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        negAngles.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    aPanel.negValuesAllowed(true);
                } else {
                    aPanel.negValuesAllowed(false);
                }
            }
        });
        dialog.add((Component)buttonsPanel, "South");
        dialog.setSize(250, 200);
        dialog.setResizable(false);
        dialog.setTitle("Angle chooser");
        dialog.setDefaultCloseOperation(0);
        dialog.setModal(true);
        GuiUtils.centerOnScreen(dialog);
        dialog.setVisible(true);
        return choosenAngle;
    }

    public static void main(String[] args) {
        GuiUtils.setLookAndFeel();
        double a = AnglePanel.angleDialogRads(null, -0.3);
        System.out.print(a);
    }

    public AnglePanel() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new TableLayout(new double[][]{{0.2, 0.3, 0.2, 0.3}, {20.0, -1.0}}));
        this.add((Component)this.trigo, "0,1,3,1");
        this.trigo.setParent(this);
        this.radsField.addFocusListener(new SelectAllFocusListener());
        this.degsField.addFocusListener(new SelectAllFocusListener());
        this.add((Component)new JLabel("Rads: ", 4), "0,0");
        this.add((Component)this.radsField, "1,0");
        this.add((Component)new JLabel("Degs: ", 4), "2,0");
        this.add((Component)this.degsField, "3,0");
        this.radsField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    double val;
                    for (val = Double.parseDouble(AnglePanel.this.radsField.getText()); val > Math.PI * 2; val -= Math.PI * 2) {
                    }
                    while (val < 0.0) {
                        val += Math.PI * 2;
                    }
                    if (AnglePanel.this.negValuesAllowed && val > Math.PI) {
                        val -= Math.PI * 2;
                    }
                    AnglePanel.this.degsField.setValue(Math.toDegrees(val));
                    AnglePanel.this.trigo.setAngleRads(val);
                    AnglePanel.this.angleRads = val;
                }
                catch (Exception ex) {
                    AnglePanel.this.degsField.setValue(0);
                    AnglePanel.this.trigo.setAngleRads(0.0);
                    AnglePanel.this.angleRads = 0.0;
                }
            }
        });
        this.degsField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    double val;
                    for (val = Double.parseDouble(AnglePanel.this.degsField.getText()); val > 360.0; val -= 360.0) {
                    }
                    while (val < 0.0) {
                        val += 360.0;
                    }
                    if (AnglePanel.this.negValuesAllowed && val > 180.0) {
                        val -= 360.0;
                    }
                    AnglePanel.this.radsField.setValue(Math.toRadians(val));
                    AnglePanel.this.trigo.setAngleRads(Math.toRadians(val));
                    AnglePanel.this.angleRads = Math.toRadians(val);
                }
                catch (Exception ex) {
                    AnglePanel.this.degsField.setValue(0);
                    AnglePanel.this.trigo.setAngleRads(0.0);
                    AnglePanel.this.angleRads = 0.0;
                }
            }
        });
    }

    public double getAngleRads() {
        return this.angleRads;
    }

    public void setAngleRads(double angleRads) {
        while (angleRads > Math.PI * 2) {
            angleRads -= Math.PI * 2;
        }
        while (angleRads < 0.0) {
            angleRads += Math.PI * 2;
        }
        if (this.negValuesAllowed && angleRads > Math.PI) {
            angleRads -= Math.PI * 2;
        }
        if (angleRads == -Math.PI) {
            angleRads = -angleRads;
        }
        if (angleRads == 0.0) {
            angleRads = 0.0;
        }
        this.angleRads = angleRads;
        this.degsField.setValue(new Double(Math.toDegrees(angleRads)));
        this.radsField.setValue(angleRads);
        this.trigo.setAngleRads(angleRads);
    }

    public void negValuesAllowed(boolean negAllowed) {
        this.negValuesAllowed = negAllowed;
        this.setAngleRads(this.getAngleRads());
    }

    class TrigoCircle
    extends JPanel {
        private double angRads = 0.0;
        private double margin = 8.0;
        private AnglePanel parent = null;

        public TrigoCircle() {
            MouseAdapter myAdapter = new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    super.mouseDragged(e);
                    TrigoCircle.this.calcAngle(e.getPoint());
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    TrigoCircle.this.calcAngle(e.getPoint());
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    TrigoCircle.this.calcAngle(e.getPoint());
                }
            };
            this.addMouseMotionListener(myAdapter);
            this.addMouseListener(myAdapter);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            double diameter = this.getWidth() < this.getHeight() ? (double)this.getWidth() : (double)this.getHeight();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            double hMargin = ((double)this.getWidth() - diameter) / 2.0 + this.margin;
            double vMargin = ((double)this.getHeight() - diameter) / 2.0 + this.margin;
            Ellipse2D.Double ellis = new Ellipse2D.Double(hMargin, vMargin, diameter -= this.margin * 2.0, diameter);
            Arc2D.Double arc = new Arc2D.Double();
            arc.setFrame(new Rectangle2D.Double(hMargin, vMargin, diameter, diameter));
            ((Arc2D)arc).setAngleStart(0.0);
            ((Arc2D)arc).setAngleExtent(Math.toDegrees(this.angRads));
            arc.setArcType(2);
            g2d.setColor(Color.white);
            g2d.fill(ellis);
            if (this.angRads >= 0.0) {
                g2d.setColor(new Color(255, 100, 100));
            } else {
                g2d.setColor(new Color(100, 100, 255));
            }
            if (this.angRads == 0.0) {
                g2d.draw(new Line2D.Double(this.getWidth() / 2, this.getHeight() / 2, (double)(this.getWidth() / 2) + diameter / 2.0, this.getHeight() / 2));
            } else {
                g2d.fill(arc);
            }
            g2d.setColor(Color.black);
            g2d.draw(ellis);
            int iang = (int)Math.round(Math.toDegrees(this.getAngleRads()));
            String angStr = iang + "\u00b0";
            Rectangle2D r = g2d.getFontMetrics().getStringBounds("360", g2d);
            g2d.translate(this.getWidth() / 2, this.getHeight() / 2);
            double scale = diameter / 3.0 / r.getWidth();
            g2d.scale(scale, scale);
            g2d.drawString(angStr, (float)(-r.getWidth()) / 2.0f, (float)r.getHeight() / 3.0f);
        }

        private void calcAngle(Point2D click) {
            Point2D.Double pt = new Point2D.Double(this.getWidth() / 2, this.getHeight() / 2);
            double angRads = Math.atan2(click.getY() - ((Point2D)pt).getY(), click.getX() - ((Point2D)pt).getX());
            if ((angRads = -angRads) == -Math.PI) {
                angRads = -angRads;
            }
            if (angRads == 0.0) {
                angRads = 0.0;
            }
            if (!AnglePanel.this.negValuesAllowed && angRads < 0.0) {
                angRads = Math.PI * 2 + angRads;
            }
            this.setAngleRads(angRads);
            if (this.parent != null) {
                this.parent.setAngleRads(this.getAngleRads());
            }
        }

        public double getAngleRads() {
            return this.angRads;
        }

        public void setAngleRads(double angleRads) {
            this.angRads = angleRads;
            this.repaint();
        }

        public void setParent(AnglePanel parent) {
            this.parent = parent;
        }
    }
}

