/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.swing;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import pt.lsts.neptus.util.ImageUtils;

public class JRoundButton
extends JButton {
    private static final long serialVersionUID = 1672225468260288000L;
    protected Shape shape = null;
    protected boolean pressed = false;
    protected boolean isCircular = false;

    public JRoundButton() {
        this(null, null);
    }

    public JRoundButton(Icon icon) {
        this(null, icon);
    }

    public JRoundButton(String text) {
        this(text, null);
    }

    public JRoundButton(String text, Icon icon) {
        super(text, icon);
        Dimension size = this.getPreferredSize();
        size.width = size.height = Math.max(size.width, size.height);
        this.setPreferredSize(size);
        this.setFocusPainted(icon == null);
        this.setContentAreaFilled(true);
    }

    public JRoundButton(String imageURL, String toolTipText, String actionCommand) {
        super(new ImageIcon(ImageUtils.getImage(imageURL)));
        this.setToolTipText(toolTipText);
        this.setActionCommand(actionCommand);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getBackground());
        Rectangle ret = g2.getClipBounds();
        ret = this.isDoubleCircle() ? new Rectangle(this.getWidth() / 6, this.getHeight() / 6, this.getWidth() * 2 / 3, this.getHeight() * 2 / 3) : new Rectangle(0, 0, this.getWidth(), this.getHeight());
        this.pressed = this.getModel().isPressed();
        Arc2D.Double arc = new Arc2D.Double(ret.x, ret.y, ret.width - 1, ret.height - 1, 0.0, 360.0, 1);
        if (this.pressed) {
            g2.setColor(this.getBackground().darker());
        }
        g2.fill(arc);
        super.paintComponent(g);
        if (this.isContentAreaFilled()) {
            Color backColor = null;
            backColor = this.getParent() != null ? this.getParent().getBackground() : new JButton().getBackground();
            AlphaComposite ac = AlphaComposite.getInstance(7);
            BufferedImage buffImg = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D gbi = buffImg.createGraphics();
            gbi.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gbi.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            gbi.setComposite(ac);
            gbi.setColor(backColor);
            gbi.fillRect(0, 0, this.getSize().width, this.getSize().height);
            Color fc = this.getBackground().darker();
            if (!this.getModel().isEnabled()) {
                fc = Color.GRAY;
            }
            gbi.setColor(fc);
            gbi.fillOval(0, 0, this.getSize().width, this.getSize().height);
            g2.drawImage(buffImg, 0, 0, this.getWidth(), this.getHeight(), this);
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle ret = g2.getClipBounds();
        ret = this.isDoubleCircle() ? new Rectangle(this.getWidth() / 6, this.getHeight() / 6, this.getWidth() * 2 / 3, this.getHeight() * 2 / 3) : new Rectangle(0, 0, this.getWidth(), this.getHeight());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Color col1 = this.getBackground().darker();
        Color col2 = this.getBackground().brighter();
        BasicStroke s = new BasicStroke(3.0f);
        g2.setStroke(s);
        Arc2D.Double arc = new Arc2D.Double(ret.x + 1, ret.y + 1, ret.width - 3, ret.height - 3, 0.0, 360.0, 1);
        Point2D.Double pt1 = new Point2D.Double(ret.x, ret.y);
        Point2D.Double pt2 = new Point2D.Double(ret.width - 1, ret.height - 1);
        GradientPaint gp = null;
        gp = this.pressed ? new GradientPaint(pt1, col1, pt2, col2, true) : new GradientPaint(pt1, col2, pt2, col1, true);
        g2.setPaint(gp);
        g2.draw(arc);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.shape == null || !this.shape.getBounds().equals(this.getBounds())) {
            this.shape = new Ellipse2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
        return this.shape.contains(x, y);
    }

    protected boolean isDoubleCircle() {
        return false;
    }

    public boolean isCircular() {
        return this.isCircular;
    }

    public void setCircular(boolean isCircular) {
        boolean oldIsCircular = this.isCircular;
        this.isCircular = isCircular;
        if (isCircular && !oldIsCircular) {
            this.setSize(this.getSize());
            this.setPreferredSize(this.getPreferredSize());
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.isCircular()) {
            width = height = Math.min(width, height);
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setSize(Dimension d) {
        if (this.isCircular()) {
            int min = (int)Math.min(d.getWidth(), d.getHeight());
            d.setSize(min, min);
        }
        super.setSize(d);
    }

    @Override
    public void setSize(int width, int height) {
        if (this.isCircular()) {
            int min;
            width = height = (min = Math.min(width, height));
        }
        super.setSize(width, height);
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        if (this.isCircular()) {
            int min = (int)Math.min(preferredSize.getWidth(), preferredSize.getHeight());
            preferredSize.setSize(min, min);
        }
        super.setPreferredSize(preferredSize);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(new JRoundButton("cool", null));
        JRoundButton but = new JRoundButton("STOP");
        but.setSize(300, 250);
        but.setBackground(Color.YELLOW);
        frame.getContentPane().add(but);
        frame.getContentPane().add(new JButton("cool", null));
        JButton but1 = new JButton("STOP");
        but1.setSize(300, 250);
        but1.setBackground(Color.YELLOW);
        frame.getContentPane().add(but1);
        frame.setSize(150, 150);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

