/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.util.GuiUtils;

public class MessagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss,SSS");
    public static final Color DEFAULT = Color.BLACK;
    public static final Color INFO = Color.BLUE.darker();
    public static final Color ERROR = Color.RED;
    public static final Color WARN = new Color(255, 180, 0);
    public static final Color SENT = Color.BLUE;
    public static final Color RECEIVE = new Color(0, 200, 125);
    public static final Color PING = new Color(193, 176, 135);
    private Color defaultColor = DEFAULT;
    private static final int MAX_TEXT_MSG_LENGHT = 500000;
    private boolean isTimeStampEnable = false;
    private JScrollPane msgScrollPane = null;
    private JTextPane msgTextPane = null;
    private JButton clearMsgsButton = null;
    private JButton copyToClipboardButton = null;
    private JPanel buttonsPanel = null;

    public MessagePanel() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMsgScrollPane(), "Center");
        this.add((Component)this.getButtonsPanel(), "South");
    }

    public void showButtons(boolean show) {
        if (show) {
            this.getButtonsPanel().setVisible(true);
        } else {
            this.getButtonsPanel().setVisible(false);
        }
    }

    private JScrollPane getMsgScrollPane() {
        if (this.msgScrollPane == null) {
            this.msgScrollPane = new JScrollPane();
            this.msgScrollPane.setViewportView(this.getMsgTextPane());
        }
        return this.msgScrollPane;
    }

    private JTextPane getMsgTextPane() {
        if (this.msgTextPane == null) {
            this.msgTextPane = new JTextPane();
            this.msgTextPane.setEditable(false);
        }
        return this.msgTextPane;
    }

    private JButton getClearMsgsButton() {
        if (this.clearMsgsButton == null) {
            this.clearMsgsButton = new JButton();
            this.clearMsgsButton.setText("clear");
            this.clearMsgsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MessagePanel.this.getMsgTextPane().setText("");
                }
            });
        }
        return this.clearMsgsButton;
    }

    private JButton getCopyToClipboardButton() {
        if (this.copyToClipboardButton == null) {
            this.copyToClipboardButton = new JButton("copy to clipboard");
            this.copyToClipboardButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClipboardOwner owner = new ClipboardOwner(){

                        @Override
                        public void lostOwnership(Clipboard clipboard, Transferable contents) {
                        }
                    };
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(MessagePanel.this.msgTextPane.getText()), owner);
                    MessagePanel.this.writeMessageTextln("Text was copied to the system clipboard", DEFAULT);
                }
            });
        }
        return this.copyToClipboardButton;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel(new GridLayout(1, 2));
            this.buttonsPanel.add(this.getClearMsgsButton());
            this.buttonsPanel.add(this.getCopyToClipboardButton());
        }
        return this.buttonsPanel;
    }

    public boolean isTimeStampEnable() {
        return this.isTimeStampEnable;
    }

    public void setTimeStampEnable(boolean isTimeStampEnable) {
        this.isTimeStampEnable = isTimeStampEnable;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    private synchronized void writeMessageTextWorker(String message, Color type, int offset) {
        SimpleAttributeSet attrTS = new SimpleAttributeSet();
        attrTS.addAttribute(StyleConstants.ColorConstants.Foreground, Color.DARK_GRAY);
        attrTS.addAttribute(StyleConstants.Bold, true);
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute(StyleConstants.ColorConstants.Foreground, type);
        StyledDocument doc = this.getMsgTextPane().getStyledDocument();
        if (offset == -1) {
            offset = doc.getLength();
        }
        try {
            if (this.isTimeStampEnable()) {
                String msgTs = "[" + this.getTimeStamp() + "]: ";
                doc.insertString(offset, msgTs, attrTS);
                offset += msgTs.length();
            }
            doc.insertString(offset, message, attr);
            int docLength = doc.getLength();
            if (docLength > 500000) {
                doc.remove(0, docLength - 500000);
            }
            this.getMsgTextPane().setCaretPosition(doc.getLength());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void writeMessageTextln(String message, Color type) {
        if (!message.endsWith("\n")) {
            this.writeMessageTextWorker(message + "\n", type, -1);
        } else {
            this.writeMessageTextWorker(message, type, -1);
        }
    }

    public void writeMessageText(String message) {
        this.writeMessageTextWorker(message, this.getDefaultColor(), -1);
    }

    public void writeMessageText(String message, Color type) {
        this.writeMessageTextWorker(message, type, -1);
    }

    public void writeMessageTextln(String message) {
        this.writeMessageTextln(message, this.getDefaultColor());
    }

    public void writeMessageText(String message, Color type, int offset) {
        this.writeMessageTextWorker(message, type, offset);
    }

    public void writeMessageText(String message, int offset) {
        this.writeMessageTextWorker(message, this.getDefaultColor(), offset);
    }

    public synchronized void removeTextFromDoc(int offset, int length) {
        StyledDocument doc = this.getMsgTextPane().getStyledDocument();
        try {
            doc.remove(offset, length);
        }
        catch (BadLocationException e) {
            NeptusLog.pub().info((Object)("<###>offset=" + offset + "  length=" + length + "   docsize=" + doc.getLength()));
            e.printStackTrace();
        }
    }

    public synchronized String getTextFromDoc(int offset, int length) {
        StyledDocument doc = this.getMsgTextPane().getStyledDocument();
        try {
            return doc.getText(offset, length);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    public synchronized Position getCurrentPosition() {
        StyledDocument doc = this.getMsgTextPane().getStyledDocument();
        try {
            return doc.createPosition(doc.getLength());
        }
        catch (BadLocationException e) {
            return doc.getEndPosition();
        }
    }

    private String getTimeStamp() {
        return this.dateFormat.format(new Date(System.currentTimeMillis()));
    }

    public static void main(String[] args) {
        MessagePanel msgPanel = new MessagePanel();
        GuiUtils.testFrame(msgPanel);
        msgPanel.writeMessageText("123456 ");
        Position cpos = msgPanel.getCurrentPosition();
        msgPanel.writeMessageText("12%");
        msgPanel.removeTextFromDoc(cpos.getOffset() - 3, 3);
        msgPanel.writeMessageText("\n" + cpos.getOffset());
        msgPanel.removeTextFromDoc(0, 14);
        msgPanel.writeMessageText("oooooooo%", WARN);
    }
}

