/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.swing;

import java.awt.Image;
import java.io.File;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

public class NeptusFileView
extends FileView {
    public static Hashtable<String, Image> iconSet = new Hashtable();

    protected boolean isNeptusFile(File f) {
        String fext = FileUtil.getFileExtension(f);
        if ("gz".equalsIgnoreCase(fext)) {
            fext = FileUtil.getFileExtension(f.getName().substring(0, f.getName().length() - 3)) + "." + fext;
        }
        if ("bz2".equalsIgnoreCase(fext)) {
            fext = FileUtil.getFileExtension(f.getName().substring(0, f.getName().length() - 4)) + "." + fext;
        }
        for (String ext : iconSet.keySet()) {
            if (!fext.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean isTraversable(File f) {
        return null;
    }

    @Override
    public Icon getIcon(File f) {
        if (this.isNeptusFile(f)) {
            String fex = FileUtil.getFileExtension(f);
            if ("gz".equalsIgnoreCase(fex)) {
                fex = FileUtil.getFileExtension(f.getName().substring(0, f.getName().length() - 3)) + "." + fex;
            }
            if ("bz2".equalsIgnoreCase(fex)) {
                fex = FileUtil.getFileExtension(f.getName().substring(0, f.getName().length() - 4)) + "." + fex;
            }
            return new ImageIcon(iconSet.get(fex));
        }
        return super.getIcon(f);
    }

    public static void main(String[] args) {
        GuiUtils.setSystemLookAndFeel();
        JFileChooser chooser = new JFileChooser(new File(ConfigFetch.getConfigFile()));
        chooser.setFileView(new NeptusFileView());
        chooser.showOpenDialog(null);
    }

    static {
        JFileChooser chooser = new JFileChooser();
        FileChooserUI fcui = (FileChooserUI)UIManager.getUI(chooser);
        fcui.installUI(chooser);
        FileView def = fcui.getFileView(chooser);
        File tmp = new File(".");
        Icon folder = def.getIcon(tmp);
        int w = folder.getIconWidth();
        int h = folder.getIconHeight();
        if (w < 20 || h < 20) {
            iconSet.put("nmis", ImageUtils.getScaledImage("images/files-icons/nmis16.png", w, h));
            iconSet.put("nmisz", ImageUtils.getScaledImage("images/files-icons/nmisz16.png", w, h));
            iconSet.put("nmap", ImageUtils.getScaledImage("images/files-icons/nmap16.png", w, h));
            iconSet.put("ncon", ImageUtils.getScaledImage("images/files-icons/ncon16.png", w, h));
            iconSet.put("ncfg", ImageUtils.getScaledImage("images/files-icons/ncfg16.png", w, h));
            iconSet.put("nvcl", ImageUtils.getScaledImage("images/files-icons/nvcl16.png", w, h));
            iconSet.put("nchk", ImageUtils.getScaledImage("images/files-icons/nchk16.png", w, h));
            iconSet.put("nwsn", ImageUtils.getScaledImage("images/files-icons/nwsn16.png", w, h));
            iconSet.put("ini", ImageUtils.getScaledImage("images/files-icons/ini16.png", w, h));
            iconSet.put("rmf", ImageUtils.getScaledImage("images/files-icons/rmf16.png", w, h));
            iconSet.put("lsf", ImageUtils.getScaledImage("images/files-icons/lsf16.png", w, h));
            iconSet.put("lsf.gz", ImageUtils.getScaledImage("images/files-icons/lsfgz16.png", w, h));
            iconSet.put("lsf.bz2", ImageUtils.getScaledImage("images/files-icons/lsfgz16.png", w, h));
        } else {
            iconSet.put("nmis", ImageUtils.getScaledImage("images/files-icons/nmis.png", w, h));
            iconSet.put("nmisz", ImageUtils.getScaledImage("images/files-icons/nmisz.png", w, h));
            iconSet.put("nmap", ImageUtils.getScaledImage("images/files-icons/nmap.png", w, h));
            iconSet.put("ncon", ImageUtils.getScaledImage("images/files-icons/ncon.png", w, h));
            iconSet.put("ncfg", ImageUtils.getScaledImage("images/files-icons/ncfg.png", w, h));
            iconSet.put("nvcl", ImageUtils.getScaledImage("images/files-icons/nvcl.png", w, h));
            iconSet.put("nchk", ImageUtils.getScaledImage("images/files-icons/nchk.png", w, h));
            iconSet.put("nwsn", ImageUtils.getScaledImage("images/files-icons/nwsn.png", w, h));
            iconSet.put("ini", ImageUtils.getScaledImage("images/files-icons/ini.png", w, h));
            iconSet.put("rmf", ImageUtils.getScaledImage("images/files-icons/rmf.png", w, h));
            iconSet.put("lsf", ImageUtils.getScaledImage("images/files-icons/lsf.png", w, h));
            iconSet.put("lsf.gz", ImageUtils.getScaledImage("images/files-icons/lsfgz.png", w, h));
            iconSet.put("lsf.bz2", ImageUtils.getScaledImage("images/files-icons/lsfgz.png", w, h));
        }
    }
}

