/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import pt.lsts.neptus.gui.swing.JRoundButton;
import pt.lsts.neptus.util.GuiUtils;

public class PanicButton
extends JRoundButton {
    private static final long serialVersionUID = -4027845692644064678L;
    protected Color backgroundOutter = new Color(255, 230, 63);
    protected Color backgroundInner = new Color(232, 28, 28);
    protected Paint backgroundOutterPaint = null;
    protected Paint backgroundOutterPaintDisabled = null;
    protected Dimension dim = null;
    boolean dp = false;

    public PanicButton() {
        this.setText("Abort");
        this.initCmp();
    }

    public PanicButton(Icon icon) {
        super(icon);
        this.initCmp();
    }

    public PanicButton(String text) {
        super(text);
        this.initCmp();
    }

    public PanicButton(String text, Icon icon) {
        super(text, icon);
        this.initCmp();
    }

    protected void initCmp() {
        this.setPreferredSize(new Dimension(80, 80));
        this.initTextureOfButton();
        this.setBackground(this.backgroundInner);
        this.setForeground(this.getBackgroundOutter());
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
            }
        });
    }

    protected void initTextureOfButton() {
        if (this.dim == null) {
            this.dim = this.getSize();
        }
        if (this.dim.equals(this.getSize())) {
            return;
        }
        this.dim = this.getSize();
        Paint[] paints = PanicButton.createStripesEnableDisablePaints(this.dim, this.backgroundOutter);
        this.backgroundOutterPaint = paints[0];
        this.backgroundOutterPaintDisabled = paints[1];
        try {
            Graphics2D g2 = (Graphics2D)this.getGraphics();
            AffineTransform pre = g2.getTransform();
            g2.scale((double)this.getWidth() / 80.0, (double)this.getHeight() / 80.0);
            Font newF = this.getFont().deriveFont(g2.getTransform());
            g2.setTransform(pre);
            this.setFont(newF);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Paint[] createStripesEnableDisablePaints(Dimension dim, Color backgroundOutter) {
        double mS = Math.min(dim.width, dim.height);
        mS = mS == 0.0 ? 80.0 : mS;
        int refSize = 80;
        int refTexSize = 25;
        int refStrokeSize = 10;
        int size = (int)(mS * (double)refTexSize / (double)refSize);
        int stroke = (int)(mS * (double)refStrokeSize / (double)refSize);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        BufferedImage buffImg = gc.createCompatibleImage(size, size, 2);
        Graphics2D gbi = buffImg.createGraphics();
        gbi.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gbi.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        gbi.setColor(backgroundOutter);
        gbi.fillRect(0, 0, size, size);
        gbi.setColor(Color.BLACK);
        BasicStroke s = new BasicStroke(stroke);
        gbi.setStroke(s);
        gbi.drawLine(0, 0, size, size);
        gbi.drawLine(-size, 0, size, size * 2);
        gbi.drawLine(0, -size, size * 2, size);
        Rectangle r = new Rectangle(0, 0, size, size);
        TexturePaint backgroundOutterPaint = new TexturePaint(buffImg, r);
        buffImg = new BufferedImage(size, size, 11);
        gbi = buffImg.createGraphics();
        gbi.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gbi.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        gbi.setColor(backgroundOutter);
        gbi.fillRect(0, 0, size, size);
        gbi.setColor(Color.BLACK);
        s = new BasicStroke(stroke);
        gbi.setStroke(s);
        gbi.drawLine(0, 0, size, size);
        gbi.drawLine(-size, 0, size, size * 2);
        gbi.drawLine(0, -size, size * 2, size);
        r = new Rectangle(0, 0, size, size);
        TexturePaint backgroundOutterPaintDisabled = new TexturePaint(buffImg, r);
        return new Paint[]{backgroundOutterPaint, backgroundOutterPaintDisabled};
    }

    public Color getBackgroundOutter() {
        return this.backgroundOutter;
    }

    public void setBackgroundOutter(Color backgroundOutter) {
        this.backgroundOutter = backgroundOutter;
        this.initTextureOfButton();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.dp) {
            return;
        }
        this.dp = true;
        this.initTextureOfButton();
        this.dp = false;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Arc2D.Double arc = new Arc2D.Double(0.0, 0.0, this.getSize().width - 1, this.getSize().height - 1, 0.0, 360.0, 1);
        if (this.isEnabled()) {
            g2.setPaint(this.backgroundOutterPaint);
        } else {
            g2.setPaint(this.backgroundOutterPaintDisabled);
        }
        g2.fill(arc);
        super.paintComponent(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Color col1 = this.getBackgroundOutter().darker();
        if (!this.getModel().isEnabled()) {
            col1 = Color.LIGHT_GRAY.darker();
        }
        Color col2 = this.getBackgroundOutter().brighter();
        if (!this.getModel().isEnabled()) {
            col2 = Color.LIGHT_GRAY.brighter();
        }
        BasicStroke s = new BasicStroke(3.0f);
        g2.setStroke(s);
        Arc2D.Double arc = new Arc2D.Double(1.0, 1.0, this.getSize().width - 3, this.getSize().height - 3, 0.0, 360.0, 1);
        Point2D.Double pt1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double pt2 = new Point2D.Double(this.getSize().width - 1, this.getSize().height - 1);
        GradientPaint gp = null;
        gp = new GradientPaint(pt1, col2, pt2, col1, true);
        g2.setPaint(gp);
        g2.draw(arc);
        super.paintBorder(g);
    }

    @Override
    public boolean contains(int x, int y) {
        this.shape = new Ellipse2D.Float(this.getWidth() / 6, this.getHeight() / 6, this.getWidth() * 2 / 3, this.getHeight() * 2 / 3);
        return this.shape.contains(x, y);
    }

    @Override
    protected boolean isDoubleCircle() {
        return true;
    }

    public static void main(String[] args) {
        GuiUtils.setLookAndFeel();
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(new PanicButton("cool"));
        JButton but = new PanicButton();
        but.setPreferredSize(new Dimension(100, 80));
        ((JRoundButton)but).setCircular(true);
        frame.getContentPane().add(but);
        frame.getContentPane().add(new JButton("Hello"));
        frame.getContentPane().add(new JRoundButton("Hello"));
        but = new JRoundButton("Hi");
        but.setBackground(Color.YELLOW);
        frame.getContentPane().add(but);
        but = new JButton("Hi1");
        but.setBackground(Color.YELLOW);
        frame.getContentPane().add(but);
        but = new PanicButton("Disable");
        but.setEnabled(false);
        frame.getContentPane().add(but);
        but = new JRoundButton("Disable");
        but.setEnabled(false);
        frame.getContentPane().add(but);
        but = new JRoundButton("Disable");
        but.setBackground(Color.YELLOW);
        but.setEnabled(false);
        frame.getContentPane().add(but);
        but = new JButton("Disable");
        but.setEnabled(false);
        frame.getContentPane().add(but);
        but = new JButton("Disable");
        but.setBackground(Color.YELLOW);
        but.setEnabled(false);
        frame.getContentPane().add(but);
        PanicButton pb = new PanicButton();
        pb.setCircular(true);
        pb.setPreferredSize(new Dimension(200, 300));
        frame.getContentPane().add(pb);
        frame.setSize(400, 300);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        try {
            Thread.sleep(2000L);
            frame.getContentPane().setBackground(Color.CYAN);
            Thread.sleep(2000L);
            frame.getContentPane().setBackground(Color.ORANGE);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

