/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXPanel;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.gui.system.SymbolLabel;
import pt.lsts.neptus.util.GuiUtils;

public class AuthoritySymbol
extends SymbolLabel {
    private ImcSystem.IMCAuthorityState authorityType = ImcSystem.IMCAuthorityState.NONE;
    protected boolean fullOrNoneOnly = false;

    @Override
    protected void initialize() {
        this.setSize(10, 10);
        this.setPreferredSize(new Dimension(10, 10));
        super.initialize();
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (!active) {
            this.authorityType = ImcSystem.IMCAuthorityState.OFF;
        } else if (this.authorityType == ImcSystem.IMCAuthorityState.OFF) {
            this.authorityType = ImcSystem.IMCAuthorityState.SYSTEM_MONITOR;
        }
    }

    public ImcSystem.IMCAuthorityState getAuthorityType() {
        return this.authorityType;
    }

    public void setAuthorityType(ImcSystem.IMCAuthorityState authorityType) {
        boolean changeValue = this.authorityType != authorityType;
        this.authorityType = authorityType;
        this.active = authorityType != ImcSystem.IMCAuthorityState.OFF;
        if (this.blinkOnChange && changeValue) {
            this.blink(true);
        }
    }

    @Override
    public void paint(Graphics2D g, JXPanel c, int width, int height) {
        GeneralPath sp;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.scale((double)width / 10.0, (double)height / 10.0);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, 10.0, 10.0, 0.0, 0.0);
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fill(rect);
        if (this.getAuthorityType() != ImcSystem.IMCAuthorityState.NONE) {
            sp = new GeneralPath();
            sp.moveTo(2.0f, 4.0f);
            sp.lineTo(5.0f, 1.0f);
            sp.lineTo(8.0f, 4.0f);
            g2.setColor(this.getActiveColor());
            g2.draw(sp);
        }
        if (!this.isActive()) {
            sp = new GeneralPath();
            sp.moveTo(8.0f, 2.0f);
            sp.lineTo(2.0f, 8.0f);
            sp.moveTo(2.0f, 2.0f);
            sp.lineTo(8.0f, 8.0f);
            g2.setColor(this.getActiveColor());
            g2.draw(sp);
        }
        g2.setColor(this.getActiveColor());
        g2.translate(5, 6);
        if (!this.isActive() || this.isActive() && this.getAuthorityType() == ImcSystem.IMCAuthorityState.NONE || this.fullOrNoneOnly) {
            Ellipse2D.Double el1 = new Ellipse2D.Double(-2.5, -2.5, 5.0, 5.0);
            g2.fill(el1);
        }
        if (this.isActive() && !this.fullOrNoneOnly && this.getAuthorityType() != ImcSystem.IMCAuthorityState.NONE && this.getAuthorityType() != ImcSystem.IMCAuthorityState.OFF) {
            String tt = "F";
            switch (this.getAuthorityType()) {
                case SYSTEM_FULL: {
                    tt = "F";
                    break;
                }
                case SYSTEM_MONITOR: {
                    tt = "M";
                    break;
                }
                case PAYLOAD: {
                    tt = "P";
                    break;
                }
                case PAYLOAD_MONITOR: {
                    tt = "PM";
                    break;
                }
                default: {
                    tt = "?";
                }
            }
            g2.setFont(new Font("Arial", 1, 7));
            Rectangle2D sB1 = g2.getFontMetrics().getStringBounds(tt, g2);
            double sw0 = sB1.getWidth() / 2.0;
            g2.drawString(tt, (float)(-Math.round(sw0)), 3.0f);
        }
    }

    public static void main(String[] args) {
        AuthoritySymbol symb1 = new AuthoritySymbol();
        symb1.setSize(20, 50);
        symb1.setActive(true);
        JXPanel panel = new JXPanel();
        panel.setBackground(Color.BLACK);
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)((Object)symb1), (Object)"Center");
        GuiUtils.testFrame((JComponent)panel, "", 300, 300);
    }
}

