/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXPanel;
import pt.lsts.neptus.gui.system.SymbolLabel;
import pt.lsts.neptus.util.GuiUtils;

public class ConnectionSymbol
extends SymbolLabel {
    private ConnectionStrengthEnum strength = ConnectionStrengthEnum.FULL;
    private boolean activeAnnounce = false;

    @Override
    protected void initialize() {
        this.setSize(10, 10);
        this.setPreferredSize(new Dimension(10, 10));
        super.initialize();
    }

    public ConnectionStrengthEnum getStrength() {
        return this.strength;
    }

    public void setStrength(ConnectionStrengthEnum strength) {
        this.strength = strength;
        this.repaint();
    }

    public void setFullStrength() {
        this.setStrength(ConnectionStrengthEnum.FULL);
    }

    public ConnectionStrengthEnum reduceStrength() {
        switch (this.strength) {
            case FULL: {
                this.setStrength(ConnectionStrengthEnum.HIGH);
                break;
            }
            case HIGH: {
                this.setStrength(ConnectionStrengthEnum.MEDIAN);
                break;
            }
            case MEDIAN: {
                this.setStrength(ConnectionStrengthEnum.LOW);
                break;
            }
        }
        return this.strength;
    }

    public boolean isActiveAnnounce() {
        return this.activeAnnounce;
    }

    public void setActiveAnnounce(boolean activeAnnounce) {
        this.activeAnnounce = activeAnnounce;
    }

    @Override
    public void paint(Graphics2D g, JXPanel c, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, 10.0, 10.0, 0.0, 0.0);
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fill(rect);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.scale((double)width / 10.0, (double)height / 10.0);
        if (this.activeAnnounce) {
            g2.setColor(this.getActiveColor());
            GeneralPath sp = new GeneralPath();
            sp.moveTo(0.0f, 8.0f);
            sp.lineTo(0.0f, 2.0f);
            g2.draw(sp);
        }
        g2.translate(2, 5);
        Ellipse2D.Double el1 = new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0);
        g2.setColor(this.getActiveColor());
        g2.fill(el1);
        if (this.isActive()) {
            Arc2D.Double arc1;
            if (this.strength.ordinal() >= ConnectionStrengthEnum.MEDIAN.ordinal()) {
                arc1 = new Arc2D.Double(0.0, -1.5, 3.0, 3.0, -45.0, 90.0, 0);
                g2.draw(arc1);
            }
            if (this.strength.ordinal() >= ConnectionStrengthEnum.HIGH.ordinal()) {
                arc1 = new Arc2D.Double(0.0, -2.5, 5.0, 5.0, -45.0, 90.0, 0);
                g2.draw(arc1);
            }
            if (this.strength.ordinal() >= ConnectionStrengthEnum.FULL.ordinal()) {
                arc1 = new Arc2D.Double(0.0, -3.5, 7.0, 7.0, -45.0, 90.0, 0);
                g2.draw(arc1);
            }
        } else {
            g2.translate(4, 0);
            GeneralPath sp = new GeneralPath();
            sp.moveTo(-3.0f, -3.0f);
            sp.lineTo(3.0f, 3.0f);
            sp.moveTo(3.0f, -3.0f);
            sp.lineTo(-3.0f, 3.0f);
            g2.draw(sp);
        }
        if (this.activeAnnounce) {
            g2.setFont(new Font("Arial", 1, 3));
            g2.drawString("A", -1, 4);
        }
    }

    public static void main(String[] args) {
        ConnectionSymbol symb1 = new ConnectionSymbol();
        symb1.setSize(50, 50);
        symb1.setActive(true);
        JXPanel panel = new JXPanel();
        panel.setBackground(Color.BLACK);
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)((Object)symb1), (Object)"Center");
        GuiUtils.testFrame((JComponent)panel, "", 400, 400);
        try {
            Thread.sleep(2000L);
            symb1.reduceStrength();
            Thread.sleep(2000L);
            symb1.reduceStrength();
            Thread.sleep(2000L);
            symb1.reduceStrength();
            Thread.sleep(2000L);
            symb1.reduceStrength();
            Thread.sleep(2000L);
            symb1.setFullStrength();
            Thread.sleep(2000L);
            symb1.setActive(false);
            Thread.sleep(2000L);
            symb1.setActiveAnnounce(true);
            Thread.sleep(2000L);
            symb1.setActive(true);
            symb1.setFullStrength();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static enum ConnectionStrengthEnum {
        LOW,
        MEDIAN,
        HIGH,
        FULL;

    }
}

