/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXPanel;
import pt.lsts.neptus.gui.system.TaskSymbol;
import pt.lsts.neptus.util.GuiUtils;

public class EmergencyTaskSymbol
extends TaskSymbol {
    private EmergencyStatus status = EmergencyStatus.NOT_CONFIGURED;

    public EmergencyStatus getStatus() {
        return this.status;
    }

    public void setStatus(EmergencyStatus status) {
        boolean changeValue = this.status != status;
        this.status = status;
        if (this.blinkOnChange && changeValue) {
            this.blink(true);
        }
    }

    @Override
    public void paint(Graphics2D g, JXPanel c, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        super.paint(g, c, width, height);
        if (this.isActive()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.scale((double)width / 10.0, (double)height / 10.0);
            g2.setColor(this.getActiveColor());
            g2.setFont(new Font("Arial", 1, 5));
            g2.drawString("E", 0, 4);
            g2.setFont(new Font("Arial", 1, 4));
            String st = "NC";
            switch (this.status) {
                case ENABLED: {
                    st = "EN";
                    break;
                }
                case DISABLED: {
                    st = "NO";
                    break;
                }
                case ACTIVE: {
                    st = "AC";
                    break;
                }
                case ARMED: {
                    st = "AR";
                    break;
                }
                case STOPPING: {
                    st = "ST";
                    break;
                }
                default: {
                    st = "NC";
                }
            }
            g2.drawString(st, 4, 10);
        }
    }

    public static void main(String[] args) {
        EmergencyTaskSymbol symb1 = new EmergencyTaskSymbol();
        symb1.setSize(50, 50);
        symb1.setActive(true);
        JXPanel panel = new JXPanel();
        panel.setBackground(Color.GRAY.darker());
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)((Object)symb1), (Object)"Center");
        GuiUtils.testFrame((JComponent)panel, "", 400, 400);
    }

    public static enum EmergencyStatus {
        NOT_CONFIGURED,
        DISABLED,
        ENABLED,
        ARMED,
        ACTIVE,
        STOPPING;

    }
}

