/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXPanel;
import pt.lsts.neptus.gui.system.SymbolLabel;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.MathMiscUtils;

public class FuelLevelSymbol
extends SymbolLabel {
    private double percentage = -1.0;

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    @Override
    public void paint(Graphics2D g, JXPanel c, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.scale((double)width / 10.0, (double)height / 10.0);
        Color cErase = new Color(0, 0, 0, 0);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, 10.0, 10.0, 0.0, 0.0);
        g2.setColor(cErase);
        g2.fill(rect);
        double value = (double)((long)MathMiscUtils.clamp(this.percentage, 0.0, 100.0)) / 100.0;
        int xwAdd = 0;
        double threshold = 0.1;
        if (value > threshold || this.percentage < 0.0) {
            xwAdd = 2;
        }
        int x = 4;
        boolean y = true;
        int xw = 3 + xwAdd;
        int yh = 8;
        g2.setColor(this.getActiveColor());
        rect = new RoundRectangle2D.Double(x, (double)y, xw, yh, 0.0, 0.0);
        if (this.percentage >= 0.0) {
            g2.draw(rect);
        }
        g2.setFont(new Font("Arial", 1, 5));
        g2.drawString("F", 0, 4);
        g2.drawString("L", 0, 9);
        if (!this.isActive() || this.percentage < 0.0) {
            g2.setColor(this.getActiveColor());
            g2.setFont(new Font("Arial", 1, 8));
            g2.drawString("?", 4 - (2 - xwAdd) / 2, 8);
        }
        if (this.percentage >= 0.0) {
            g2.setColor(this.getActiveColor());
            if (value <= threshold) {
                g2.setFont(new Font("Arial", 1, 11));
                g2.drawString("!", 7, 9);
            }
            rect = new RoundRectangle2D.Double(x, (double)y + (double)yh * (1.0 - value), xw, (double)yh - (double)yh * (1.0 - value), 0.0, 0.0);
            g2.fill(rect);
        }
        if (!this.isActive() && this.percentage >= 0.0) {
            g2.setFont(new Font("Arial", 1, 8));
            Graphics2D g2tmp = (Graphics2D)g2.create();
            g2tmp.setColor(cErase);
            g2tmp.setComposite(AlphaComposite.getInstance(7));
            g2tmp.clip(rect);
            g2tmp.drawString("?", 4 - (2 - xwAdd) / 2, 8);
            g2tmp.dispose();
            if (xwAdd == 0) {
                Rectangle2D.Double rect1 = new Rectangle2D.Double((double)x - (double)xw / 2.0, (double)y, (double)xw / 2.0 + 0.5, yh);
                g2tmp = (Graphics2D)g2.create();
                g2tmp.setColor(cErase);
                g2tmp.setComposite(AlphaComposite.getInstance(7));
                g2tmp.clip(rect1);
                g2tmp.drawString("?", 4 - (2 - xwAdd) / 2, 8);
                g2tmp.dispose();
                Rectangle2D.Double rect2 = new Rectangle2D.Double((double)(x + xw) - 0.5, (double)y, (double)xw / 2.0 + 0.5, yh);
                g2tmp = (Graphics2D)g2.create();
                g2tmp.setColor(cErase);
                g2tmp.setComposite(AlphaComposite.getInstance(7));
                g2tmp.clip(rect2);
                g2tmp.drawString("?", 4 - (2 - xwAdd) / 2, 8);
                g2tmp.dispose();
            }
        }
    }

    public static void main(String[] args) {
        FuelLevelSymbol symb1 = new FuelLevelSymbol();
        symb1.setSize(20, 50);
        symb1.setActive(true);
        JXPanel panel = new JXPanel();
        panel.setBackground(Color.BLACK);
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)((Object)symb1), (Object)"Center");
        GuiUtils.testFrame((JComponent)panel, "", 300, 300);
    }
}

