/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pt.lsts.neptus.util.ColorUtils;
import pt.lsts.neptus.util.GuiUtils;

public class MilStd2525LikeSymbolsDefinitions {
    public static boolean debugOn = false;
    private static final Color CYAN = new Color(0, 255, 255);
    private static final Color CRYSTAL_BLUE = new Color(128, 224, 255);
    private static final Color YELLOW = new Color(255, 255, 0);
    private static final Color LIGHT_YELLOW = new Color(255, 255, 128);
    private static final Color NEON_GREEN = new Color(0, 255, 0);
    private static final Color BAMBOO_GREEN = new Color(170, 255, 170);
    private static final Color RED = new Color(255, 0, 0);
    private static final Color SALMON = new Color(255, 128, 128);
    private static final Color PLUM_RED = new Color(255, 0, 255);
    private static final Color LIGHT_ORCHID = new Color(255, 161, 255);
    private static final Color SAFARI = new Color(128, 98, 16);
    private static final Color KHAKI = new Color(210, 176, 106);
    private static final Color BLACK = new Color(0, 0, 0);
    private static final Color WHITE = new Color(255, 255, 255);
    private static final Color OFF_WHITE_6PERC_GREY = new Color(239, 239, 239);
    public static final Color BLUE_ICON = CYAN;
    public static final Color BLUE_FILL = CRYSTAL_BLUE;
    public static final Color BLUE_FILL_MEDIUM = new Color(0, 168, 220);
    public static final Color BLUE_FILL_DARK = new Color(0, 107, 140);
    public static final Color YELLOW_ICON = YELLOW;
    public static final Color YELLOW_FILL = LIGHT_YELLOW;
    public static final Color YELLOW_FILL_MEDIUM = new Color(255, 255, 0);
    public static final Color YELLOW_FILL_DARK = new Color(225, 220, 0);
    public static final Color GREEN_ICON = NEON_GREEN;
    public static final Color GREEN_FILL = BAMBOO_GREEN;
    public static final Color GREEN_FILL_MEDIUM = new Color(0, 226, 0);
    public static final Color GREEN_FILL_DARK = new Color(0, 160, 0);
    public static final Color RED_ICON = RED;
    public static final Color RED_FILL = SALMON;
    public static final Color RED_FILL_MEDIUM = new Color(255, 48, 49);
    public static final Color RED_FILL_DARK = new Color(200, 0, 0);
    public static final Color PURPLE_ICON = PLUM_RED;
    public static final Color PURPLE_FILL = LIGHT_ORCHID;
    public static final Color PURPLE_FILL_MEDIUM = new Color(128, 0, 128);
    public static final Color PURPLE_FILL_DARK = new Color(80, 0, 80);
    public static final Color BROWN_ICON = SAFARI;
    public static final Color BROWN_FILL = KHAKI;
    public static final Color BROWN_FILL_MEDIUM = new Color(164, 139, 86);
    public static final Color BROWN_FILL_DARK = new Color(118, 91, 32);
    public static final Color BLACK_ICON = BLACK;
    public static final Color BLACK_FILL;
    public static final Color BLACK_FILL_MEDIUM;
    public static final Color BLACK_FILL_DARK;
    public static final Color WHITE_ICON;
    public static final Color WHITE_FILL;
    public static final Color WHITE_FILL_MEDIUM;
    public static final Color WHITE_FILL_DARK;
    public static final Color ORANGE_ICON;
    public static final Color ORANGE_FILL;
    public static final Color ORANGE_FILL_MEDIUM;
    public static final Color ORANGE_FILL_DARK;
    private static final int SYMBOL_SIZE = 32;
    private static final GeneralPath ICON_SHAPE_OCTAGON;
    public static SymbolColorIntencityEnum colorIntencity;

    public static void paintMilStd2525(Graphics2D g, SymbolTypeEnum type, SymbolShapeEnum shapeType, SymbolOperationalConditionEnum operationalCondition, int iconSize, boolean frameOn, boolean fillOn, boolean continuousOrDashedFrameStroke, int useTransparency, SymbolIconEnum drawIcon, boolean drawMainIndicator) {
        SymbolColorEnum colorType = SymbolColorEnum.BLUE;
        switch (shapeType) {
            case FRIEND: {
                colorType = SymbolColorEnum.BLUE;
                break;
            }
            case NEUTRAL: {
                colorType = SymbolColorEnum.GREEN;
                break;
            }
            case HOSTILE: {
                colorType = SymbolColorEnum.RED;
                break;
            }
            case UNKNOWN: {
                colorType = SymbolColorEnum.YELLOW;
                break;
            }
        }
        MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g, type, shapeType, colorType, operationalCondition, iconSize, frameOn, fillOn, continuousOrDashedFrameStroke, useTransparency, drawIcon, drawMainIndicator);
    }

    public static void paintMilStd2525(Graphics2D g, SymbolTypeEnum type, SymbolShapeEnum shapeType, SymbolColorEnum colorType, SymbolOperationalConditionEnum operationalCondition, int iconSize, boolean frameOn, boolean fillOn, boolean continuousOrDashedFrameStroke, int useTransparency, SymbolIconEnum drawIcon, boolean drawMainIndicator) {
        double sh0;
        double sw0;
        Shape shape;
        Color colorWhite;
        Color colorBlack;
        Color colorToIcon;
        Color colorToFill;
        double zs;
        Graphics2D g2;
        block57: {
            block59: {
                GeneralPath gp;
                block58: {
                    block56: {
                        g2 = (Graphics2D)g.create();
                        if (useTransparency != 255) {
                            g2.setComposite(AlphaComposite.getInstance(3, (float)useTransparency / 255.0f));
                        }
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        zs = (double)iconSize * 1.0 / 32.0;
                        if (zs != 1.0) {
                            g2.scale(zs, zs);
                        }
                        g2.translate(-16.0, -16.0);
                        colorToFill = colorType.getFillColor();
                        colorToIcon = colorType.getIconColor();
                        colorBlack = BLACK_FILL;
                        colorWhite = WHITE_FILL;
                        if (shapeType != SymbolShapeEnum.NEUTRAL) break block56;
                        switch (type) {
                            case AIR: 
                            case SUBSURFACE: {
                                gp = new GeneralPath();
                                gp.moveTo(-1.6, 32.0);
                                gp.lineTo(-1.6, -6.4);
                                gp.lineTo(33.6, -6.4);
                                gp.lineTo(33.6, 32.0);
                                shape = gp;
                                if (type == SymbolTypeEnum.SUBSURFACE) {
                                    shape = gp.createTransformedShape(new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, 32.0f, 32.0f));
                                    break;
                                }
                                break block57;
                            }
                            case SURFACE: 
                            case SURFACE_UNIT: {
                                shape = new RoundRectangle2D.Double(-1.6, -1.6, 35.2, 35.2, 0.0, 0.0);
                                break;
                            }
                            default: {
                                shape = new Ellipse2D.Double(-3.2, -3.2, 6.0, 6.0);
                                break;
                            }
                        }
                        break block57;
                    }
                    if (shapeType != SymbolShapeEnum.HOSTILE) break block58;
                    switch (type) {
                        case AIR: 
                        case SUBSURFACE: {
                            gp = new GeneralPath();
                            gp.moveTo(-1.6, 32.0);
                            gp.lineTo(-1.6, 6.4);
                            gp.lineTo(16.0, -9.6);
                            gp.lineTo(33.6, 6.4);
                            gp.lineTo(33.6, 32.0);
                            shape = gp;
                            if (type == SymbolTypeEnum.SUBSURFACE) {
                                shape = gp.createTransformedShape(new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, 32.0f, 32.0f));
                                break;
                            }
                            break block57;
                        }
                        case SURFACE: 
                        case SURFACE_UNIT: {
                            gp = new GeneralPath();
                            gp.moveTo(16.0, -7.04);
                            gp.lineTo(39.04, 16.0);
                            gp.lineTo(16.0, 39.04);
                            gp.lineTo(-7.04, 16.0);
                            gp.closePath();
                            shape = gp;
                            break;
                        }
                        default: {
                            shape = new Ellipse2D.Double(-3.2, -3.2, 6.0, 6.0);
                            break;
                        }
                    }
                    break block57;
                }
                if (shapeType != SymbolShapeEnum.UNKNOWN) break block59;
                double halfLength = 16.0;
                double halfLengthCosPiPer4 = halfLength * Math.cos(0.7853981633974483);
                switch (type) {
                    case AIR: 
                    case SUBSURFACE: {
                        gp = new GeneralPath();
                        gp.moveTo(16.0 - halfLengthCosPiPer4, 32.0);
                        gp.curveTo(-8.0, 32.0, -8.0, 16.0 - halfLengthCosPiPer4, 16.0 - halfLengthCosPiPer4, 16.0 - halfLengthCosPiPer4);
                        gp.curveTo(16.0 - halfLengthCosPiPer4, -9.6, 16.0 + halfLengthCosPiPer4, -9.6, 16.0 + halfLengthCosPiPer4, 16.0 - halfLengthCosPiPer4);
                        gp.curveTo(40.0, 16.0 - halfLengthCosPiPer4, 40.0, 32.0, 16.0 + halfLengthCosPiPer4, 32.0);
                        shape = gp;
                        if (type == SymbolTypeEnum.SUBSURFACE) {
                            shape = gp.createTransformedShape(new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, 32.0f, 32.0f));
                            break;
                        }
                        break block57;
                    }
                    case SURFACE: 
                    case SURFACE_UNIT: {
                        gp = new GeneralPath();
                        gp.moveTo(16.0 - halfLengthCosPiPer4, 16.0 - halfLengthCosPiPer4);
                        gp.curveTo(16.0 - halfLengthCosPiPer4, -7.04, 16.0 + halfLengthCosPiPer4, -7.04, 16.0 + halfLengthCosPiPer4, 16.0 - halfLengthCosPiPer4);
                        gp.curveTo(39.04, 16.0 - halfLengthCosPiPer4, 39.04, 16.0 + halfLengthCosPiPer4, 16.0 + halfLengthCosPiPer4, 16.0 + halfLengthCosPiPer4);
                        gp.curveTo(16.0 + halfLengthCosPiPer4, 39.04, 16.0 - halfLengthCosPiPer4, 39.04, 16.0 - halfLengthCosPiPer4, 16.0 + halfLengthCosPiPer4);
                        gp.curveTo(-7.04, 16.0 + halfLengthCosPiPer4, -7.04, 16.0 - halfLengthCosPiPer4, 16.0 - halfLengthCosPiPer4, 16.0 - halfLengthCosPiPer4);
                        shape = gp;
                        break;
                    }
                    default: {
                        shape = new Ellipse2D.Double(-3.2, -3.2, 6.0, 6.0);
                        break;
                    }
                }
                break block57;
            }
            switch (type) {
                case AIR: {
                    shape = new Arc2D.Double(-1.6, -6.4, 35.2, 76.8, 0.0, 180.0, 0);
                    break;
                }
                case SUBSURFACE: {
                    shape = new Arc2D.Double(-1.6, -38.4, 35.2, 76.8, 0.0, -180.0, 0);
                    break;
                }
                case SURFACE: {
                    shape = new Ellipse2D.Double(-3.2, -3.2, 38.4, 38.4);
                    break;
                }
                case SURFACE_UNIT: {
                    shape = new RoundRectangle2D.Double(-8.0, 0.0, 48.0, 32.0, 0.0, 0.0);
                    break;
                }
                default: {
                    shape = new Ellipse2D.Double(-3.2, -3.2, 6.0, 6.0);
                }
            }
        }
        if (fillOn) {
            g2.setColor(colorToFill);
            g2.fill(shape);
            if (shapeType == SymbolShapeEnum.NEUTRAL && (type == SymbolTypeEnum.AIR || type == SymbolTypeEnum.SUBSURFACE)) {
                boolean isAirOrSub = type != SymbolTypeEnum.SUBSURFACE;
                Graphics2D gI = (Graphics2D)g2.create();
                if (fillOn) {
                    gI.setColor(colorBlack);
                } else {
                    gI.setColor(colorToIcon);
                }
                RoundRectangle2D.Double shapeNotched = new RoundRectangle2D.Double(-3.2, isAirOrSub ? 25.6 : 0.0, 6.4, 6.4, 0.0, 0.0);
                gI.fill(shapeNotched);
                shapeNotched = new RoundRectangle2D.Double(28.8, isAirOrSub ? 25.6 : 0.0, 6.4, 6.4, 0.0, 0.0);
                gI.fill(shapeNotched);
                gI.dispose();
            }
        }
        if (frameOn) {
            Graphics2D gI = (Graphics2D)g2.create();
            Stroke oldStroke = gI.getStroke();
            if (!continuousOrDashedFrameStroke) {
                gI.setColor(colorWhite);
                gI.setStroke(new BasicStroke(3.0f));
                gI.draw(shape);
            }
            if (fillOn) {
                gI.setColor(colorBlack);
            } else {
                gI.setColor(colorToIcon);
            }
            if (!continuousOrDashedFrameStroke) {
                gI.setStroke(new BasicStroke(3.0f, 0, 1, 0.0f, new float[]{3.0f, 3.0f}, 0.0f));
            } else {
                gI.setStroke(new BasicStroke(3.0f));
            }
            gI.draw(shape);
            gI.setStroke(oldStroke);
            gI.dispose();
        }
        if (drawIcon != SymbolIconEnum.NONE) {
            Rectangle2D sB1;
            Graphics2D gI = (Graphics2D)g2.create();
            gI.translate(16.0, 16.0);
            if (fillOn) {
                gI.setColor(colorBlack);
            } else {
                gI.setColor(colorToIcon);
            }
            if (drawIcon == SymbolIconEnum.UAS) {
                GeneralPath sp = new GeneralPath();
                sp.moveTo(0.0, 4.571428571428571);
                sp.lineTo(-10.666666666666666, -4.0);
                sp.lineTo(0.0, 4.0);
                sp.lineTo(10.666666666666666, -4.0);
                sp.closePath();
                gI.setStroke(new BasicStroke(3.2f));
                gI.draw(sp);
            } else if (drawIcon == SymbolIconEnum.CCU) {
                gI.setFont(new Font("Arial", 1, 10));
                String tt = "CCU";
                sB1 = gI.getFontMetrics().getStringBounds(tt, gI);
                sw0 = 19.2 / sB1.getWidth();
                sh0 = 12.8 / sB1.getHeight();
                gI.scale(sw0, sh0);
                gI.translate(-sB1.getWidth() / 2.0, sB1.getHeight() / 4.0);
                gI.drawString(tt, 0, 0);
            } else if (drawIcon == SymbolIconEnum.SENSOR) {
                GeneralPath sps = new GeneralPath();
                double dSize = 8.32;
                double infl = dSize * 0.4;
                double cOff = dSize * 0.6;
                sps.moveTo(-dSize, -dSize);
                sps.curveTo(-dSize + cOff, -dSize + infl, dSize - dSize * 0.6, -dSize + infl, dSize, -dSize);
                sps.curveTo(dSize - infl, -dSize + cOff, dSize - infl, dSize - cOff, dSize, dSize);
                sps.curveTo(dSize - cOff, dSize - infl, -dSize + cOff, dSize - infl, -dSize, dSize);
                sps.curveTo(-dSize + infl, dSize - cOff, -dSize + infl, -dSize + cOff, -dSize, -dSize);
                gI.rotate(0.7853981633974483);
                gI.fill(sps);
                gI.rotate(-0.7853981633974483);
            } else if (drawIcon == SymbolIconEnum.UNKNOWN) {
                gI.setFont(new Font("Arial", 1, 10));
                String tt = "?";
                sB1 = gI.getFontMetrics().getStringBounds(tt, gI);
                sw0 = 16.0 / sB1.getWidth();
                sh0 = 16.0 / sB1.getHeight();
                gI.scale(sw0, sh0);
                gI.translate(-sB1.getWidth() / 2.0, sB1.getHeight() / 4.0);
                gI.drawString(tt, 0, 0);
            }
            gI.dispose();
        }
        if (drawMainIndicator) {
            Graphics2D gI = (Graphics2D)g2.create();
            gI.translate(16.0, 16.0);
            gI.setFont(new Font("Arial", 1, 10));
            String tt = "M";
            Rectangle2D sB1 = gI.getFontMetrics().getStringBounds(tt, gI);
            sw0 = 10.0 / sB1.getWidth();
            sh0 = 10.0 / sB1.getHeight();
            gI.scale(sw0, sh0);
            gI.translate(-sB1.getWidth() / 2.0, 12.8 / sh0);
            if (fillOn) {
                gI.setColor(colorBlack);
            } else {
                gI.setColor(colorToIcon);
            }
            gI.drawString(tt, 0, 0);
            gI.dispose();
        }
        if (operationalCondition != SymbolOperationalConditionEnum.NONE) {
            Rectangle2D bounds = shape.getBounds2D();
            RoundRectangle2D.Double opShape = new RoundRectangle2D.Double(bounds.getMinX(), bounds.getMaxY() + 3.0, bounds.getWidth(), 8.0, 0.0, 0.0);
            Color opColor = Color.LIGHT_GRAY;
            switch (operationalCondition) {
                case NORMAL: {
                    opColor = Color.GREEN;
                    break;
                }
                case WARNING: {
                    opColor = Color.BLUE;
                    break;
                }
                case FAULT: {
                    opColor = Color.YELLOW;
                    break;
                }
                case ERROR: {
                    opColor = new Color(255, 128, 0);
                    break;
                }
                case FAILURE: {
                    opColor = Color.RED;
                    break;
                }
            }
            g2.setColor(opColor);
            g2.fill(opShape);
            g2.setColor(colorBlack);
            g2.draw(opShape);
        }
        g2.dispose();
        if (debugOn) {
            g2 = (Graphics2D)g.create();
            if (zs != 1.0) {
                g2.scale(zs, zs);
            }
            g2.setColor(ColorUtils.setTransparencyToColor(Color.LIGHT_GRAY, 128));
            g2.fill(ICON_SHAPE_OCTAGON);
            g2.setColor(ColorUtils.setTransparencyToColor(Color.GRAY, 128));
            g2.draw(ICON_SHAPE_OCTAGON);
            g2.dispose();
        }
    }

    public static void main(String[] args) {
        JPanel panel = new JPanel(true){
            int iconSize = 32;
            int spacingSize = (int)((double)this.iconSize * 1.6);
            SymbolShapeEnum shapeType = SymbolShapeEnum.FRIEND;
            SymbolColorEnum colorType = SymbolColorEnum.BLUE;
            SymbolOperationalConditionEnum operationalCondition = SymbolOperationalConditionEnum.NONE;
            SymbolColorEnum[] altColor = new SymbolColorEnum[]{null, null, null, null, null, null, null, SymbolColorEnum.PURPLE, SymbolColorEnum.BROWN, SymbolColorEnum.ORANGE};
            boolean[] frameOn = new boolean[]{true, true, true, true, true, true, true, true, true, true};
            boolean[] fillOn = new boolean[]{true, true, true, true, false, false, true, true, true, true};
            boolean[] continuousOrDashedFrameStroke = new boolean[]{true, false, true, false, true, false, true, true, true, true};
            int[] useTransparency = new int[]{255, 255, 255, 255, 255, 255, 128, 255, 255, 255};
            SymbolIconEnum[] drawIcon = new SymbolIconEnum[]{SymbolIconEnum.NONE, SymbolIconEnum.NONE, SymbolIconEnum.UAS, SymbolIconEnum.UAS, SymbolIconEnum.UAS, SymbolIconEnum.UAS, SymbolIconEnum.UAS, SymbolIconEnum.CCU, SymbolIconEnum.SENSOR, SymbolIconEnum.UNKNOWN};
            boolean[] drawMainIndicator = new boolean[]{false, false, true, true, true, true, false, false, false, false};

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.translate(this.spacingSize / 2, this.spacingSize / 2);
                for (int i = 0; i < this.frameOn.length; ++i) {
                    this.shapeType = SymbolShapeEnum.FRIEND;
                    this.colorType = this.altColor[i] != null ? this.altColor[i] : SymbolColorEnum.BLUE;
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.AIR, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.SURFACE_UNIT, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.SURFACE, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.SUBSURFACE, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    this.shapeType = SymbolShapeEnum.NEUTRAL;
                    this.colorType = this.altColor[i] != null ? this.altColor[i] : SymbolColorEnum.GREEN;
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.AIR, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.SURFACE_UNIT, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.SURFACE, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.SUBSURFACE, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    this.shapeType = SymbolShapeEnum.HOSTILE;
                    this.colorType = this.altColor[i] != null ? this.altColor[i] : SymbolColorEnum.RED;
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.AIR, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.SURFACE_UNIT, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.SURFACE, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.SUBSURFACE, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    this.shapeType = SymbolShapeEnum.UNKNOWN;
                    this.colorType = this.altColor[i] != null ? this.altColor[i] : SymbolColorEnum.YELLOW;
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.AIR, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.SURFACE_UNIT, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.SURFACE, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    g2.translate(this.spacingSize, 0);
                    MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, SymbolTypeEnum.SUBSURFACE, this.shapeType, this.colorType, this.operationalCondition, this.iconSize, this.frameOn[i], this.fillOn[i], this.continuousOrDashedFrameStroke[i], this.useTransparency[i], this.drawIcon[i], this.drawMainIndicator[i]);
                    g2.translate((double)(-this.spacingSize * 15), (double)this.spacingSize + (double)this.iconSize / 2.0);
                }
            }
        };
        panel.setBackground(Color.WHITE);
        panel.setBackground(new Color(2, 113, 171));
        JScrollPane jsp = new JScrollPane(panel, 22, 32);
        GuiUtils.testFrame(jsp, "MIL-STD-2525 Like Symbology", 860, 750);
    }

    static {
        BLACK_FILL_MEDIUM = BLACK_FILL = BLACK;
        BLACK_FILL_DARK = BLACK_FILL;
        WHITE_ICON = WHITE;
        WHITE_FILL_MEDIUM = WHITE_FILL = OFF_WHITE_6PERC_GREY;
        WHITE_FILL_DARK = WHITE_FILL;
        ORANGE_ICON = new Color(255, 128, 0);
        ORANGE_FILL = new Color(230, 121, 56);
        ORANGE_FILL_MEDIUM = new Color(246, 96, 5);
        ORANGE_FILL_DARK = new Color(232, 103, 25);
        ICON_SHAPE_OCTAGON = new GeneralPath();
        double halfLength = 16.0;
        double halfLengthCosPiPer4 = halfLength * Math.cos(0.7853981633974483);
        ICON_SHAPE_OCTAGON.moveTo(0.0, -halfLength);
        ICON_SHAPE_OCTAGON.lineTo(halfLengthCosPiPer4, -halfLengthCosPiPer4);
        ICON_SHAPE_OCTAGON.lineTo(halfLength, 0.0);
        ICON_SHAPE_OCTAGON.lineTo(halfLengthCosPiPer4, halfLengthCosPiPer4);
        ICON_SHAPE_OCTAGON.lineTo(0.0, halfLength);
        ICON_SHAPE_OCTAGON.lineTo(-halfLengthCosPiPer4, halfLengthCosPiPer4);
        ICON_SHAPE_OCTAGON.lineTo(-halfLength, 0.0);
        ICON_SHAPE_OCTAGON.lineTo(-halfLengthCosPiPer4, -halfLengthCosPiPer4);
        ICON_SHAPE_OCTAGON.closePath();
        colorIntencity = SymbolColorIntencityEnum.LIGHT;
    }

    public static enum SymbolIconEnum {
        NONE,
        UAS,
        CCU,
        SENSOR,
        UNKNOWN;

    }

    public static enum SymbolOperationalConditionEnum {
        NONE,
        NORMAL,
        WARNING,
        FAULT,
        ERROR,
        FAILURE;

    }

    public static enum SymbolColorIntencityEnum {
        LIGHT,
        MEDIUM,
        DARK;

    }

    public static enum SymbolColorEnum {
        BLUE,
        RED,
        GREEN,
        YELLOW,
        PURPLE,
        BROWN,
        ORANGE;


        public Color getFillColor() {
            switch (this) {
                case BLUE: {
                    if (colorIntencity == SymbolColorIntencityEnum.DARK) {
                        return BLUE_FILL_DARK;
                    }
                    if (colorIntencity == SymbolColorIntencityEnum.MEDIUM) {
                        return BLUE_FILL_MEDIUM;
                    }
                    return BLUE_FILL;
                }
                case RED: {
                    if (colorIntencity == SymbolColorIntencityEnum.DARK) {
                        return RED_FILL_DARK;
                    }
                    if (colorIntencity == SymbolColorIntencityEnum.MEDIUM) {
                        return RED_FILL_MEDIUM;
                    }
                    return RED_FILL;
                }
                case GREEN: {
                    if (colorIntencity == SymbolColorIntencityEnum.DARK) {
                        return GREEN_FILL_DARK;
                    }
                    if (colorIntencity == SymbolColorIntencityEnum.MEDIUM) {
                        return GREEN_FILL_MEDIUM;
                    }
                    return GREEN_FILL;
                }
                case YELLOW: {
                    if (colorIntencity == SymbolColorIntencityEnum.DARK) {
                        return YELLOW_FILL_DARK;
                    }
                    if (colorIntencity == SymbolColorIntencityEnum.MEDIUM) {
                        return YELLOW_FILL_MEDIUM;
                    }
                    return YELLOW_FILL;
                }
                case PURPLE: {
                    if (colorIntencity == SymbolColorIntencityEnum.DARK) {
                        return PURPLE_FILL_DARK;
                    }
                    if (colorIntencity == SymbolColorIntencityEnum.MEDIUM) {
                        return PURPLE_FILL_MEDIUM;
                    }
                    return PURPLE_FILL;
                }
                case BROWN: {
                    if (colorIntencity == SymbolColorIntencityEnum.DARK) {
                        return BROWN_FILL_DARK;
                    }
                    if (colorIntencity == SymbolColorIntencityEnum.MEDIUM) {
                        return BROWN_FILL_MEDIUM;
                    }
                    return BROWN_FILL;
                }
                case ORANGE: {
                    if (colorIntencity == SymbolColorIntencityEnum.DARK) {
                        return ORANGE_FILL_DARK;
                    }
                    if (colorIntencity == SymbolColorIntencityEnum.MEDIUM) {
                        return ORANGE_FILL_MEDIUM;
                    }
                    return ORANGE_FILL;
                }
            }
            if (colorIntencity == SymbolColorIntencityEnum.DARK) {
                return BLUE_FILL_DARK;
            }
            if (colorIntencity == SymbolColorIntencityEnum.MEDIUM) {
                return BLUE_FILL_MEDIUM;
            }
            return BLUE_FILL;
        }

        public Color getIconColor() {
            switch (this) {
                case BLUE: {
                    return BLUE_ICON;
                }
                case RED: {
                    return RED_ICON;
                }
                case GREEN: {
                    return GREEN_ICON;
                }
                case YELLOW: {
                    return YELLOW_ICON;
                }
                case PURPLE: {
                    return PURPLE_ICON;
                }
                case BROWN: {
                    return BROWN_ICON;
                }
                case ORANGE: {
                    return ORANGE_ICON;
                }
            }
            return BLUE_ICON;
        }
    }

    public static enum SymbolShapeEnum {
        FRIEND,
        NEUTRAL,
        HOSTILE,
        UNKNOWN,
        UNFRAMED;

    }

    public static enum SymbolTypeEnum {
        AIR,
        SURFACE_UNIT,
        SURFACE,
        SUBSURFACE;

    }
}

