/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;
import pt.lsts.neptus.gui.system.SystemDisplay;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.util.GuiUtils;

public class SymbolLabel
extends JXPanel
implements Painter<JXPanel>,
IPeriodicUpdates {
    protected SystemDisplay.BlinkingStateEnum blinkingState = SystemDisplay.BlinkingStateEnum.NOT_BLINKING;
    protected int blinkTime = 5000;
    private long time = -1L;
    private int symbolWidth = 48;
    private int symbolHeight = 48;
    private Color color = Color.WHITE;
    private Color colorHover = Color.WHITE;
    protected boolean active = false;
    protected boolean blinkOnChange = true;
    private Timer timer = null;
    private TimerTask updaterTask = null;

    public SymbolLabel() {
        this.initialize();
    }

    protected void initialize() {
        this.setOpaque(false);
        this.setBackgroundPainter(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SymbolLabel.this.getParent() != null) {
                    for (MouseListener ml : SymbolLabel.this.getParent().getMouseListeners()) {
                        ml.mouseClicked(e);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SymbolLabel.this.isRightClickable()) {
                    SymbolLabel.this.setBorder(BorderFactory.createLineBorder(SymbolLabel.this.colorHover, (int)((double)SymbolLabel.this.getWidth() * 0.05)));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SymbolLabel.this.setBorder(null);
            }
        });
    }

    public void dispose() {
        this.revokeScheduleUpdateTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blink(boolean blink) {
        SystemDisplay.BlinkingStateEnum blinkingStateEnum = this.blinkingState;
        synchronized (blinkingStateEnum) {
            if (blink) {
                this.time = System.currentTimeMillis();
            }
            if (blink && this.blinkingState == SystemDisplay.BlinkingStateEnum.NOT_BLINKING) {
                this.blinkingState = SystemDisplay.BlinkingStateEnum.BLINKING_NORMAL;
                this.scheduleUpdateTask();
            } else if (!blink) {
                this.revokeScheduleUpdateTask();
                this.blinkingState = SystemDisplay.BlinkingStateEnum.NOT_BLINKING;
            }
        }
    }

    public boolean isBlinkOnChange() {
        return this.blinkOnChange;
    }

    public void setBlinkOnChange(boolean blinkOnChange) {
        this.blinkOnChange = blinkOnChange;
    }

    public int getBlinkTime() {
        return this.blinkTime;
    }

    public void setBlinkTime(int blinkTime) {
        this.blinkTime = blinkTime;
    }

    public int getSymbolWidth() {
        return this.symbolWidth;
    }

    public void setSymbolWidth(int symbolWidth) {
        this.symbolWidth = symbolWidth;
    }

    public int getSymbolHeight() {
        return this.symbolHeight;
    }

    public void setSymbolHeight(int symbolHeight) {
        this.symbolHeight = symbolHeight;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        boolean changeValue = this.active != active;
        this.active = active;
        if (this.blinkOnChange && changeValue) {
            this.blink(true);
        }
    }

    public boolean toggleActive() {
        this.setActive(!this.active);
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getActiveColor() {
        SystemDisplay.BlinkingStateEnum blinkingStateEnum = this.blinkingState;
        synchronized (blinkingStateEnum) {
            if (this.blinkingState == SystemDisplay.BlinkingStateEnum.BLINKING_BRILLIANT) {
                return this.color == Color.WHITE ? this.color.darker() : this.color.brighter();
            }
            return this.color;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColorHover() {
        return this.colorHover;
    }

    public void setColorHover(Color colorHover) {
        this.colorHover = colorHover;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdateTask() {
        SystemDisplay.BlinkingStateEnum blinkingStateEnum = this.blinkingState;
        synchronized (blinkingStateEnum) {
            if (this.updaterTask == null) {
                if (this.timer == null) {
                    this.timer = new Timer(this.getClass().getSimpleName() + " updater: ", true);
                }
                this.updaterTask = this.createUpdaterTask();
                this.timer.scheduleAtFixedRate(this.updaterTask, 0L, 700L);
            }
        }
    }

    private TimerTask createUpdaterTask() {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SystemDisplay.BlinkingStateEnum blinkingStateEnum = SymbolLabel.this.blinkingState;
                synchronized (blinkingStateEnum) {
                    if (SymbolLabel.this.blinkTime > 0 && System.currentTimeMillis() - SymbolLabel.this.time > (long)SymbolLabel.this.blinkTime) {
                        SymbolLabel.this.blinkingState = SystemDisplay.BlinkingStateEnum.NOT_BLINKING;
                    }
                    if (SymbolLabel.this.blinkingState == SystemDisplay.BlinkingStateEnum.NOT_BLINKING) {
                        SymbolLabel.this.repaint();
                        SymbolLabel.this.revokeScheduleUpdateTask();
                    }
                    if (SymbolLabel.this.blinkingState == SystemDisplay.BlinkingStateEnum.BLINKING_NORMAL) {
                        SymbolLabel.this.blinkingState = SystemDisplay.BlinkingStateEnum.BLINKING_BRILLIANT;
                    } else if (SymbolLabel.this.blinkingState == SystemDisplay.BlinkingStateEnum.BLINKING_BRILLIANT) {
                        SymbolLabel.this.blinkingState = SystemDisplay.BlinkingStateEnum.BLINKING_NORMAL;
                    }
                    SymbolLabel.this.repaint();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeScheduleUpdateTask() {
        SystemDisplay.BlinkingStateEnum blinkingStateEnum = this.blinkingState;
        synchronized (blinkingStateEnum) {
            if (this.updaterTask != null) {
                this.updaterTask.cancel();
                this.updaterTask = null;
            }
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long millisBetweenUpdates() {
        SystemDisplay.BlinkingStateEnum blinkingStateEnum = this.blinkingState;
        synchronized (blinkingStateEnum) {
            if (this.blinkTime > 0 && System.currentTimeMillis() - this.time > (long)this.blinkTime) {
                this.blinkingState = SystemDisplay.BlinkingStateEnum.NOT_BLINKING;
                this.repaint();
            }
            switch (this.blinkingState) {
                case NOT_BLINKING: {
                    return 0L;
                }
                case BLINKING_NORMAL: {
                    return 700L;
                }
                case BLINKING_BRILLIANT: {
                    return 700L;
                }
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update() {
        SystemDisplay.BlinkingStateEnum blinkingStateEnum = this.blinkingState;
        synchronized (blinkingStateEnum) {
            if (this.blinkTime > 0 && System.currentTimeMillis() - this.time > (long)this.blinkTime) {
                this.blinkingState = SystemDisplay.BlinkingStateEnum.NOT_BLINKING;
            }
            if (this.blinkingState == SystemDisplay.BlinkingStateEnum.NOT_BLINKING) {
                this.repaint();
                return false;
            }
            this.blinkingState = this.blinkingState == SystemDisplay.BlinkingStateEnum.BLINKING_NORMAL ? SystemDisplay.BlinkingStateEnum.BLINKING_BRILLIANT : SystemDisplay.BlinkingStateEnum.BLINKING_NORMAL;
        }
        this.repaint();
        return true;
    }

    public void paint(Graphics2D g, JXPanel c, int width, int height) {
        Color c1 = this.getActiveColor();
        Graphics2D g2 = (Graphics2D)g.create();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, 10.0, 10.0, 0.0, 0.0);
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fill(rect);
        g2.setColor(c1);
        g2.scale(width / 10, height / 10);
        g2.setStroke(new BasicStroke(0.3f));
        GeneralPath sp = new GeneralPath();
        sp.moveTo(0.0f, 4.0f);
        sp.lineTo(4.0f, 4.0f);
        sp.lineTo(4.0f, 0.0f);
        sp.moveTo(0.0f, 6.0f);
        sp.lineTo(4.0f, 6.0f);
        sp.lineTo(4.0f, 10.0f);
        sp.moveTo(6.0f, 0.0f);
        sp.lineTo(6.0f, 4.0f);
        sp.lineTo(10.0f, 4.0f);
        sp.moveTo(6.0f, 10.0f);
        sp.lineTo(6.0f, 6.0f);
        sp.lineTo(10.0f, 6.0f);
        g2.draw(sp);
    }

    protected void drawText(Graphics2D g2, String text) {
        g2.setColor(this.getActiveColor());
        g2.setFont(new Font("Arial", 1, 10));
        String tt = text;
        Rectangle2D sB1 = g2.getFontMetrics().getStringBounds(tt, g2);
        double sw0 = 10.0 / sB1.getWidth();
        double sh0 = 10.0 / sB1.getHeight();
        g2.translate(5, 5);
        g2.scale(sw0, sh0);
        g2.drawString(text, (int)(-sB1.getWidth() / 2.0), (int)(sB1.getHeight() / 2.0));
    }

    public boolean isRightClickable() {
        return false;
    }

    void mouseClicked(MouseEvent e) {
    }

    public static void main(String[] args) {
        SymbolLabel symb1 = new SymbolLabel();
        symb1.setSize(20, 50);
        JXPanel panel = new JXPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)((Object)symb1), (Object)"Center");
        GuiUtils.testFrame((JComponent)panel);
    }
}

