/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.dom4j.Document;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.GlossPainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;
import pt.lsts.imc.EntityParameters;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.gui.system.AttentionSymbol;
import pt.lsts.neptus.gui.system.AuthoritySymbol;
import pt.lsts.neptus.gui.system.ConnectionSymbol;
import pt.lsts.neptus.gui.system.DisplayColorSymbol;
import pt.lsts.neptus.gui.system.EmergencyTaskSymbol;
import pt.lsts.neptus.gui.system.FuelLevelSymbol;
import pt.lsts.neptus.gui.system.IdProblemSymbol;
import pt.lsts.neptus.gui.system.LocationSymbol;
import pt.lsts.neptus.gui.system.MainVehicleSymbol;
import pt.lsts.neptus.gui.system.SymbolLabel;
import pt.lsts.neptus.gui.system.SystemParamsSymbol;
import pt.lsts.neptus.gui.system.SystemTypeSymbol;
import pt.lsts.neptus.gui.system.TaskSymbol;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.params.ConfigurationManager;
import pt.lsts.neptus.params.SystemConfigurationEditorPanel;
import pt.lsts.neptus.params.SystemProperty;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.plugins.update.PeriodicUpdatesService;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class SystemDisplay
extends JXPanel
implements Comparable<SystemDisplay>,
IPeriodicUpdates {
    private static final Icon ICON_UP = ImageUtils.getScaledIcon("images/systems/uparrow.png", 12, 12);
    private static final Icon ICON_DOWN = ImageUtils.getScaledIcon("images/systems/downarrow.png", 12, 12);
    private static final Color COLOR_IDLE = Color.DARK_GRAY.brighter();
    private static final Color COLOR_GREEN = Color.GREEN.darker();
    private static final Color COLOR_RED = new Color(245, 20, 40);
    private static final Color COLOR_OLD = Color.GRAY.darker();
    private static final Color COLOR_BLUE = new Color(43, 182, 227);
    private static final Color COLOR_ORANGE = new Color(255, 128, 0);
    protected static Color BLUE_1 = new Color(181, 198, 216);
    protected BlinkingStateEnum blinkingState = BlinkingStateEnum.NOT_BLINKING;
    private String id = "";
    private Image systemImage = null;
    private ImageIcon icon = null;
    private Color displayColor = null;
    private boolean active = false;
    private boolean selected = false;
    private boolean enableSelection = true;
    private ImcSystem.IMCAuthorityState withAuthority = ImcSystem.IMCAuthorityState.NONE;
    private boolean taskAlocated = false;
    private boolean emergencyTaskAlocated = false;
    private boolean attentionAlert = false;
    private boolean idAlert = false;
    private boolean mainVehicle = false;
    private String systemType = "";
    private boolean showSystemSymbolOrText = true;
    private int iconSize = 20;
    private int indicatorsSize = 20;
    private int incrementFontSize = 0;
    private JXLabel label = null;
    private ConnectionSymbol symConnected = null;
    private LocationSymbol symLoc = null;
    private MainVehicleSymbol symMain = null;
    private AuthoritySymbol symAuth = null;
    private TaskSymbol symTask = null;
    private AttentionSymbol symAttention = null;
    private SystemTypeSymbol symType = null;
    private IdProblemSymbol symIdAttention = null;
    private EmergencyTaskSymbol sysEmergencyTask = null;
    private DisplayColorSymbol symDisplayColor = null;
    private SystemParamsSymbol symSystemParamsSymbol = null;
    private FuelLevelSymbol symFuelLevel = null;
    private JButton expandButton = new JButton(ICON_DOWN);
    private JLabel infoLabel = new JLabel(I18n.text("No extra info"));
    private GroupLayout layout;
    private Font labelOriginFont = null;
    private boolean showExtraInfoVisible = false;
    private long selectionTimeMillis = -1L;
    private SystemConfigurationEditorPanel systemConfEditor = null;
    private RectanglePainter rectPainter;
    private CompoundPainter<JXPanel> compoundBackPainter;
    private GlossPainter glossy = null;
    private long lastUpdatedTimeMillis = -1L;

    public SystemDisplay(String id) {
        this.id = id;
        this.initialize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.iconSize + this.label.getWidth() + 10, this.iconSize + this.indicatorsSize + this.label.getHeight() + this.infoLabel.getHeight());
    }

    public Dimension getPreferredSize() {
        return !this.isShowExtraInfoVisible() ? super.getPreferredSize() : new Dimension((int)super.getPreferredSize().getWidth(), (int)super.getPreferredSize().getHeight() + this.label.getHeight() + this.infoLabel.getHeight());
    }

    private void initialize() {
        this.initializeSymbols();
        this.setPreferredSize(new Dimension(100, 60));
        this.setSelected(this.isSelected());
        this.setActive(this.isActive());
        this.setWithAuthority(this.getWithAuthority());
        this.setDisplayColor(null);
        this.expandButton.setMargin(new Insets(1, 1, 1, 1));
        this.expandButton.setBackground(BLUE_1);
        this.expandButton.setForeground(Color.BLACK);
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemDisplay.this.toggleShowMoreInfoVisible();
            }
        });
        this.symConnected.setPreferredSize(new Dimension(this.indicatorsSize, this.indicatorsSize));
        this.symConnected.setSize(new Dimension(this.indicatorsSize, this.indicatorsSize));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (1 == e.getButton()) {
                    if (e.isControlDown()) {
                        e.setSource(SystemDisplay.this);
                    } else {
                        SystemDisplay.this.toggleSelected();
                    }
                    this.propagate(e, 500);
                } else {
                    try {
                        SymbolLabel symb;
                        if (e.getSource() instanceof SymbolLabel && (symb = (SymbolLabel)e.getSource()).isRightClickable()) {
                            symb.mouseClicked(e);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.propagate(e, 502);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.propagate(e, 501);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.propagate(e, 505);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.propagate(e, 504);
            }

            private void propagate(MouseEvent e, int mete) {
                e.setSource(SystemDisplay.this);
                if (SystemDisplay.this.getParent() != null) {
                    block7: for (MouseListener ml : SystemDisplay.this.getParent().getMouseListeners()) {
                        switch (mete) {
                            case 500: {
                                ml.mouseClicked(e);
                                continue block7;
                            }
                            case 504: {
                                ml.mouseEntered(e);
                                continue block7;
                            }
                            case 505: {
                                ml.mouseExited(e);
                                continue block7;
                            }
                            case 501: {
                                ml.mousePressed(e);
                                continue block7;
                            }
                            case 502: {
                                ml.mouseReleased(e);
                                continue block7;
                            }
                        }
                    }
                }
            }
        });
        this.label = new JXLabel(this.id);
        this.labelOriginFont = this.label.getFont();
        this.label.setForeground(Color.WHITE);
        if (this.systemImage != null) {
            this.icon = new ImageIcon(this.systemImage.getScaledInstance(this.iconSize, this.iconSize, 4));
            this.label.setIcon((Icon)this.icon);
        }
        this.infoLabel.setVisible(false);
        this.infoLabel.setForeground(Color.WHITE);
        Component glue1 = Box.createHorizontalGlue();
        Component glue2 = Box.createHorizontalGlue();
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.layout = new GroupLayout((Container)((Object)this));
        this.setLayout(this.layout);
        this.layout.setAutoCreateGaps(false);
        this.layout.setAutoCreateContainerGaps(false);
        this.layout.setHorizontalGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(this.layout.createSequentialGroup().addComponent((Component)this.label).addComponent(glue1).addComponent((Component)((Object)this.symSystemParamsSymbol), this.symConnected.getHeight(), this.symConnected.getHeight(), this.symConnected.getHeight()).addGap(5).addComponent((Component)((Object)this.symDisplayColor), this.symConnected.getHeight(), this.symConnected.getHeight(), this.symConnected.getHeight())).addGroup(this.layout.createSequentialGroup().addComponent((Component)((Object)this.symType), this.symConnected.getHeight(), this.symConnected.getHeight(), this.symConnected.getHeight()).addComponent((Component)((Object)this.symConnected), this.symConnected.getHeight(), this.symConnected.getHeight(), this.symConnected.getHeight()).addComponent((Component)((Object)this.symLoc), this.symConnected.getHeight(), this.symConnected.getHeight(), this.symConnected.getHeight()).addComponent((Component)((Object)this.symMain), this.symConnected.getHeight(), this.symConnected.getHeight(), this.symConnected.getHeight()).addComponent((Component)((Object)this.symAuth), this.symConnected.getHeight(), this.symConnected.getHeight(), this.symConnected.getHeight()).addComponent((Component)((Object)this.symTask), this.symConnected.getHeight(), this.symConnected.getHeight(), this.symConnected.getHeight()).addComponent((Component)((Object)this.symAttention), this.symConnected.getHeight(), this.symConnected.getHeight(), this.symConnected.getHeight()).addComponent((Component)((Object)this.symFuelLevel), this.symConnected.getHeight(), this.symConnected.getHeight(), this.symConnected.getHeight()).addComponent((Component)((Object)this.symIdAttention), this.symConnected.getHeight(), this.symConnected.getHeight(), this.symConnected.getHeight()).addComponent((Component)((Object)this.sysEmergencyTask), this.symConnected.getHeight(), this.symConnected.getHeight(), this.symConnected.getHeight()).addComponent(glue2).addComponent(this.expandButton)).addComponent(this.infoLabel));
        this.layout.setVerticalGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)this.label).addComponent(glue1).addComponent((Component)((Object)this.symSystemParamsSymbol)).addComponent((Component)((Object)this.symDisplayColor))).addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)((Object)this.symType)).addComponent((Component)((Object)this.symConnected)).addComponent((Component)((Object)this.symLoc)).addComponent((Component)((Object)this.symMain)).addComponent((Component)((Object)this.symAuth)).addComponent((Component)((Object)this.symTask)).addComponent((Component)((Object)this.symAttention)).addComponent((Component)((Object)this.symFuelLevel)).addComponent((Component)((Object)this.symIdAttention)).addComponent((Component)((Object)this.sysEmergencyTask)).addComponent(glue2).addComponent(this.expandButton)).addComponent(this.infoLabel));
        this.layout.linkSize(1, new Component[]{this.symConnected, this.symMain, this.symLoc, this.symAuth, this.symTask, this.symAttention, this.symType, this.symIdAttention, this.sysEmergencyTask, this.symDisplayColor, this.symSystemParamsSymbol, this.symFuelLevel});
        this.layout.linkSize(0, new Component[]{this.symConnected, this.symMain, this.symLoc, this.symAuth, this.symTask, this.symAttention, this.symType, this.symIdAttention, this.sysEmergencyTask, this.symDisplayColor, this.symSystemParamsSymbol, this.symFuelLevel});
    }

    private void initializeSymbols() {
        this.symConnected = new ConnectionSymbol();
        this.symLoc = new LocationSymbol(){

            @Override
            public boolean isRightClickable() {
                return true;
            }

            @Override
            void mouseClicked(MouseEvent e) {
                JPopupMenu pop = new JPopupMenu();
                if (this.isActive()) {
                    pop.add(new AbstractAction(I18n.text("Copy location")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ImcSystem sysA = ImcSystemsHolder.lookupSystemByName(SystemDisplay.this.id);
                            if (sysA != null) {
                                String loc = sysA.getLocation().getClipboardText();
                                ClipboardOwner owner = new ClipboardOwner(){

                                    @Override
                                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                                    }
                                };
                                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(loc), owner);
                            }
                        }
                    });
                }
                pop.add(new AbstractAction(I18n.text("Paste location")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ImcSystem sysA = ImcSystemsHolder.lookupSystemByName(SystemDisplay.this.id);
                        if (sysA != null) {
                            boolean hasTransferableText;
                            ClipboardOwner owner = new ClipboardOwner(){

                                @Override
                                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                                }
                            };
                            Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                            boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
                            if (hasTransferableText) {
                                try {
                                    String text = (String)contents.getTransferData(DataFlavor.stringFlavor);
                                    LocationType lt = new LocationType();
                                    lt.fromClipboardText(text);
                                    sysA.setLocation(lt);
                                }
                                catch (Exception e1) {
                                    NeptusLog.pub().error((Object)e1);
                                }
                            }
                        }
                    }
                });
                pop.show((Component)e.getSource(), e.getX(), e.getY());
            }
        };
        this.symMain = new MainVehicleSymbol();
        this.symAuth = new AuthoritySymbol(){
            {
                this.fullOrNoneOnly = true;
            }

            @Override
            public boolean isRightClickable() {
                return true;
            }

            @Override
            void mouseClicked(MouseEvent e) {
                final ImcSystem sysA = ImcSystemsHolder.lookupSystemByName(SystemDisplay.this.id);
                if (sysA != null) {
                    JPopupMenu pop = new JPopupMenu();
                    ButtonGroup chooseButtonGroup = new ButtonGroup();
                    for (final ImcSystem.IMCAuthorityState as : ImcSystem.IMCAuthorityState.values()) {
                        JCheckBoxMenuItem rButton = new JCheckBoxMenuItem(new AbstractAction(as.toString()){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                sysA.setAuthorityState(as);
                            }
                        });
                        rButton.setSelected(as == sysA.getAuthorityState());
                        boolean isEnable = true;
                        if (as.toString().toLowerCase().contains("payload") || as.toString().toLowerCase().contains("monitor")) {
                            isEnable = false;
                        }
                        rButton.setEnabled(isEnable);
                        if (!isEnable) continue;
                        chooseButtonGroup.add(rButton);
                        pop.add(rButton);
                    }
                    pop.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        };
        this.symTask = new TaskSymbol();
        this.symAttention = new AttentionSymbol();
        this.symType = new SystemTypeSymbol();
        this.symIdAttention = new IdProblemSymbol();
        this.sysEmergencyTask = new EmergencyTaskSymbol();
        this.symDisplayColor = new DisplayColorSymbol(){

            @Override
            public boolean isRightClickable() {
                return this.isActive();
            }

            @Override
            void mouseClicked(MouseEvent e) {
                Color newColor = JColorChooser.showDialog((Component)((Object)this), I18n.text("System color"), this.getDisplayColor());
                if (newColor == null || this.getDisplayColor() == newColor) {
                    return;
                }
                VehicleType veh = VehiclesHolder.getVehicleById(SystemDisplay.this.id);
                if (veh != null) {
                    veh.setIconColor(newColor);
                    String filePath = veh.getOriginalFilePath();
                    Document doc = veh.asDocument();
                    if (VehicleType.validate(doc)) {
                        String dataToSave = FileUtil.getAsPrettyPrintFormatedXMLString(doc);
                        FileUtil.saveToFile(filePath, dataToSave);
                    }
                }
            }
        };
        this.symSystemParamsSymbol = new SystemParamsSymbol(){

            @Override
            public boolean isRightClickable() {
                return this.isActive();
            }

            @Override
            void mouseClicked(MouseEvent e) {
                SystemDisplay.this.systemConfEditor = new SystemConfigurationEditorPanel(SystemDisplay.this.id, SystemProperty.Scope.GLOBAL, SystemProperty.Visibility.USER, true, false, true, ImcMsgManager.getManager());
                JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor((Component)((Object)SystemDisplay.this)));
                dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                dialog.add(SystemDisplay.this.systemConfEditor);
                dialog.setSize(600, 600);
                GuiUtils.centerParent(dialog, dialog.getOwner());
                dialog.setVisible(true);
                SystemDisplay.this.systemConfEditor = null;
                dialog.dispose();
            }
        };
        if (ConfigurationManager.getInstance().hasProperties(this.id, SystemProperty.Visibility.DEVELOPER, SystemProperty.Scope.GLOBAL)) {
            this.symSystemParamsSymbol.setActive(true);
        } else {
            this.symSystemParamsSymbol.setActive(false);
        }
        this.symFuelLevel = new FuelLevelSymbol();
    }

    public void dispose() {
        PeriodicUpdatesService.unregister(this);
        this.symConnected.dispose();
        this.symLoc.dispose();
        this.symMain.dispose();
        this.symAuth.dispose();
        this.symTask.dispose();
        this.symAttention.dispose();
        this.symType.dispose();
        this.symIdAttention.dispose();
        this.sysEmergencyTask.dispose();
        this.symDisplayColor.dispose();
        this.symSystemParamsSymbol.dispose();
    }

    public boolean isShowExtraInfoVisible() {
        return this.showExtraInfoVisible;
    }

    public void setShowExtraInfoVisible(boolean showExtraInfoVisible) {
        this.showExtraInfoVisible = showExtraInfoVisible;
        this.infoLabel.setVisible(showExtraInfoVisible);
        if (showExtraInfoVisible) {
            this.expandButton.setIcon(ICON_UP);
        } else {
            this.expandButton.setIcon(ICON_DOWN);
        }
    }

    public void setInfoLabel(String info) {
        this.infoLabel.setText(info);
    }

    public void toggleShowMoreInfoVisible() {
        this.setShowExtraInfoVisible(!this.isShowExtraInfoVisible());
    }

    @Override
    public int compareTo(SystemDisplay o) {
        String thisVal = this.id;
        String anotherVal = o.id;
        return thisVal.compareTo(anotherVal);
    }

    public boolean equals(Object obj) {
        try {
            return this.compareTo((SystemDisplay)obj) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getIndicatorsSize() {
        return this.indicatorsSize;
    }

    public void setIndicatorsSize(int indicatorsSize) {
        this.indicatorsSize = indicatorsSize;
        this.symConnected.setPreferredSize(new Dimension(indicatorsSize, indicatorsSize));
        this.symConnected.setSize(new Dimension(indicatorsSize, indicatorsSize));
        this.symAuth.setPreferredSize(new Dimension(indicatorsSize, indicatorsSize));
        this.symAuth.setSize(new Dimension(indicatorsSize, indicatorsSize));
        this.validate();
        this.repaint();
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
        if (this.systemImage != null) {
            this.icon.setImage(this.systemImage.getScaledInstance(-1, iconSize, 4));
            this.validate();
            this.repaint();
        }
    }

    public int getIncrementFontSize() {
        return this.incrementFontSize;
    }

    public void setIncrementFontSize(int incrementFontSize) {
        int n = this.incrementFontSize = incrementFontSize < 0 ? 0 : incrementFontSize;
        if (this.incrementFontSize == 0) {
            this.label.setFont(this.labelOriginFont);
        } else {
            this.label.setFont(this.labelOriginFont.deriveFont(this.labelOriginFont.getSize() + incrementFontSize));
        }
    }

    public String getId() {
        return this.id;
    }

    public Image getSystemImage() {
        return this.systemImage;
    }

    public void setSystemImage(Image systemImage) {
        this.systemImage = systemImage;
        this.icon = new ImageIcon(systemImage.getScaledInstance(-1, this.iconSize, 4));
        this.label.setIcon((Icon)this.icon);
        this.repaint();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.symConnected.setActive(active);
        this.reCalculateBackgroundColor();
        this.repaint();
    }

    public void setActiveToolTip(String text) {
        this.symConnected.setToolTipText(text);
    }

    public ConnectionSymbol.ConnectionStrengthEnum getConnectionStrength() {
        return this.symConnected.getStrength();
    }

    public void setConnectionStrength(ConnectionSymbol.ConnectionStrengthEnum strength) {
        this.symConnected.setStrength(strength);
    }

    public void setFullConnectionStrength() {
        this.symConnected.setStrength(ConnectionSymbol.ConnectionStrengthEnum.FULL);
    }

    public ConnectionSymbol.ConnectionStrengthEnum reduceConnectionStrength() {
        return this.symConnected.reduceStrength();
    }

    public boolean isAnnounceReceived() {
        return this.symConnected.isActiveAnnounce();
    }

    public void setAnnounceReceived(boolean announceReceived) {
        this.symConnected.setActiveAnnounce(announceReceived);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.isEnableSelection()) {
            if (!selected) {
                this.selectionTimeMillis = -1L;
            } else if (!this.selected) {
                this.selectionTimeMillis = System.currentTimeMillis();
            }
        }
        this.selected = selected;
        if (!this.isEnableSelection()) {
            this.selected = false;
        }
        this.reCalculateBorderColor();
        this.repaint();
    }

    public boolean toggleSelected() {
        this.setSelected(!this.selected);
        return this.selected;
    }

    public boolean isEnableSelection() {
        return this.enableSelection;
    }

    public void setEnableSelection(boolean enableSelection) {
        this.enableSelection = enableSelection;
    }

    public long getSelectionTimeMillis() {
        return this.selectionTimeMillis;
    }

    public Color getDisplayColor() {
        return this.displayColor;
    }

    public void setDisplayColor(Color displayColor) {
        this.displayColor = displayColor;
        if (displayColor == null) {
            this.symDisplayColor.setActive(false);
        } else {
            this.symDisplayColor.setDisplayColor(displayColor);
            this.symDisplayColor.setActive(true);
        }
    }

    public boolean isLocationKnown() {
        return this.symLoc.isActive();
    }

    public void setLocationKnown(boolean locationKnown) {
        this.symLoc.setActive(locationKnown);
    }

    public String getLocationKnownToolTip() {
        return this.symLoc.getToolTipText();
    }

    public void setLocationKnownToolTip(String text) {
        this.symLoc.setToolTipText(text);
    }

    public boolean isMainVehicle() {
        return this.mainVehicle;
    }

    public void setMainVehicle(boolean mainVehicle) {
        this.mainVehicle = mainVehicle;
        this.symMain.setActive(mainVehicle);
        this.reCalculateBackgroundColor();
        this.reCalculateBorderColor();
        if (mainVehicle) {
            this.setMainVehicleToolTip(I18n.text("Main vehicle"));
        } else {
            this.setMainVehicleToolTip(null);
        }
        this.repaint();
    }

    public void setMainVehicleToolTip(String text) {
        this.symMain.setToolTipText(text);
    }

    public boolean toggleMainVehicle() {
        this.setMainVehicle(!this.selected);
        return this.selected;
    }

    public boolean isShowSystemSymbolOrText() {
        return this.showSystemSymbolOrText;
    }

    public void setShowSystemSymbolOrText(boolean showSystemSymbolOrText) {
        this.showSystemSymbolOrText = showSystemSymbolOrText;
        this.symType.setShowSymbolOrText(showSystemSymbolOrText);
        this.repaint();
    }

    public boolean toggleShowSystemSymbolOrText() {
        this.setShowSystemSymbolOrText(!this.showSystemSymbolOrText);
        return this.showSystemSymbolOrText;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
        this.symType.setSystemType(systemType);
    }

    public boolean isWithAuthority() {
        return this.withAuthority != ImcSystem.IMCAuthorityState.NONE && this.withAuthority != ImcSystem.IMCAuthorityState.OFF;
    }

    public ImcSystem.IMCAuthorityState getWithAuthority() {
        return this.withAuthority;
    }

    public void setWithAuthority(ImcSystem.IMCAuthorityState withAuthority) {
        this.withAuthority = withAuthority;
        this.symAuth.setAuthorityType(withAuthority);
        this.reCalculateBackgroundColor();
        this.repaint();
    }

    public void setWithAuthorityToolTip(String text) {
        this.symAuth.setToolTipText(text);
    }

    public boolean isTaskAlocated() {
        return this.taskAlocated;
    }

    public void setTaskAlocated(boolean taskAlocated) {
        this.taskAlocated = taskAlocated;
        this.symTask.setActive(taskAlocated);
        this.repaint();
    }

    public void setTaskAlocatedToolTip(String text) {
        this.symTask.setToolTipText(text);
    }

    public boolean isEmergencyTaskAlocated() {
        return this.emergencyTaskAlocated;
    }

    public void setEmergencyTaskAlocated(boolean emergencyTaskAlocated) {
        this.emergencyTaskAlocated = emergencyTaskAlocated;
        this.sysEmergencyTask.setActive(emergencyTaskAlocated);
        this.repaint();
    }

    public void setEmergencyTaskAlocatedToolTip(String text) {
        this.sysEmergencyTask.setToolTipText(text);
    }

    public EmergencyTaskSymbol.EmergencyStatus getEmergencyStatus() {
        return this.sysEmergencyTask.getStatus();
    }

    public void setEmergencyStatus(EmergencyTaskSymbol.EmergencyStatus status) {
        this.sysEmergencyTask.setStatus(status);
    }

    public boolean isAttentionAlert() {
        return this.attentionAlert;
    }

    public void setAttentionAlert(boolean attentionAlert) {
        this.attentionAlert = attentionAlert;
        this.symAttention.setActive(attentionAlert);
        this.reCalculateBackgroundColor();
        this.repaint();
    }

    public boolean isFuelLevel() {
        return this.symFuelLevel.isActive();
    }

    public void setFuelLevel(boolean active) {
        this.symFuelLevel.setActive(active);
    }

    public double getFuelLevelPercentage() {
        return this.symFuelLevel.getPercentage();
    }

    public void setFuelLevelPercentage(double value) {
        this.symFuelLevel.setPercentage(value);
    }

    public String getFuelLevelToolTip() {
        return this.symFuelLevel.getToolTipText();
    }

    public void setFuelLevelToolTip(String text) {
        this.symFuelLevel.setToolTipText(text);
    }

    public String getAttentionToolTip() {
        return this.symAttention.getToolTipText();
    }

    public void setAttentionToolTip(String text) {
        this.symAttention.setToolTipText(text);
    }

    public boolean isIdAlert() {
        return this.idAlert;
    }

    public void setIdAlert(boolean idAlert) {
        this.idAlert = idAlert;
        this.symIdAttention.setActive(idAlert);
        this.repaint();
    }

    public void setIdAttentionToolTip(String text) {
        this.symIdAttention.setToolTipText(text);
    }

    private void reCalculateBackgroundColor() {
        boolean withAuthorityBoolean = false;
        if (this.withAuthority != ImcSystem.IMCAuthorityState.NONE && this.withAuthority != ImcSystem.IMCAuthorityState.OFF) {
            withAuthorityBoolean = true;
        }
        if (this.active && withAuthorityBoolean) {
            if (this.attentionAlert || this.idAlert) {
                this.updateBackColor(COLOR_ORANGE, null);
            } else {
                this.updateBackColor(COLOR_BLUE, null);
            }
        } else if (!this.active && withAuthorityBoolean) {
            if (this.attentionAlert || this.idAlert) {
                this.updateBackColor(COLOR_RED, null);
            } else {
                this.updateBackColor(COLOR_BLUE.darker().darker(), null);
            }
        } else if (this.active && !withAuthorityBoolean) {
            this.updateBackColor(COLOR_OLD, null);
        } else {
            this.updateBackColor(COLOR_IDLE, null);
        }
    }

    private void reCalculateBorderColor() {
        if (this.selected) {
            this.updateBackColor(null, COLOR_ORANGE.brighter());
        } else if (this.isMainVehicle()) {
            this.updateBackColor(null, COLOR_GREEN);
        } else {
            this.updateBackColor(null, COLOR_IDLE);
        }
    }

    private RectanglePainter getRectPainter() {
        if (this.rectPainter == null) {
            this.rectPainter = new RectanglePainter(5, 5, 5, 5, 10, 10);
            this.rectPainter.setFillPaint((Paint)COLOR_IDLE);
            this.rectPainter.setBorderPaint((Paint)COLOR_IDLE.darker().darker().darker());
            this.rectPainter.setStyle(AbstractAreaPainter.Style.BOTH);
            this.rectPainter.setBorderWidth(6.0f);
            this.rectPainter.setAntialiasing(true);
        }
        return this.rectPainter;
    }

    private CompoundPainter<JXPanel> getCompoundBackPainter() {
        if (this.compoundBackPainter == null) {
            this.glossy = new GlossPainter();
            this.compoundBackPainter = new CompoundPainter(new Painter[]{this.getRectPainter(), this.glossy});
        } else {
            this.compoundBackPainter.setPainters(new Painter[]{this.getRectPainter(), this.glossy});
        }
        return this.compoundBackPainter;
    }

    private void updateBackColor(Color color, Color borderColor) {
        if (color != null) {
            this.getRectPainter().setFillPaint((Paint)color);
        }
        if (borderColor != null) {
            this.getRectPainter().setBorderPaint((Paint)borderColor);
        }
        if (color != null || borderColor != null) {
            this.setBackgroundPainter((Painter)this.getCompoundBackPainter());
        }
    }

    public void blink(boolean blink) {
        if (blink && this.blinkingState == BlinkingStateEnum.NOT_BLINKING) {
            this.blinkingState = BlinkingStateEnum.BLINKING_NORMAL;
            PeriodicUpdatesService.register(this);
        } else if (!blink) {
            this.blinkingState = BlinkingStateEnum.NOT_BLINKING;
        }
    }

    @Override
    public long millisBetweenUpdates() {
        switch (this.blinkingState) {
            case NOT_BLINKING: {
                return 0L;
            }
            case BLINKING_NORMAL: {
                return 200L;
            }
            case BLINKING_BRILLIANT: {
                return 900L;
            }
        }
        return 0L;
    }

    @Override
    public boolean update() {
        if (this.blinkingState == BlinkingStateEnum.NOT_BLINKING) {
            return false;
        }
        this.blinkingState = this.blinkingState == BlinkingStateEnum.BLINKING_NORMAL ? BlinkingStateEnum.BLINKING_BRILLIANT : BlinkingStateEnum.BLINKING_NORMAL;
        this.repaint();
        return true;
    }

    public void updateSystemParameters(EntityParameters message) {
        if (this.systemConfEditor != null) {
            try {
                if (this.lastUpdatedTimeMillis < message.getTimestampMillis()) {
                    SystemConfigurationEditorPanel.updatePropertyWithMessageArrived(this.systemConfEditor, (IMCMessage)message);
                    this.lastUpdatedTimeMillis = message.getTimestampMillis();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        SystemDisplay sys1 = new SystemDisplay("lauv-seacon-1");
        Image image = new ImageIcon("vehicles-files\\lauv\\conf\\images\\lauv-seacon0-presentation.png").getImage();
        sys1.setSystemImage(image);
        sys1.setSystemType("UUV");
        SystemDisplay sys2 = new SystemDisplay("lauv-seacon-lsts");
        SystemDisplay sys3 = new SystemDisplay("lauv-seacon-lsts");
        JXPanel panel = new JXPanel(true);
        panel.setLayout((LayoutManager)new BoxLayout((Container)panel, 1));
        panel.add((Component)((Object)sys2));
        panel.add((Component)((Object)sys1));
        GuiUtils.testFrame((JComponent)panel);
        sys1.setActive(true);
        sys1.setTaskAlocated(true);
        sys1.setWithAuthority(ImcSystem.IMCAuthorityState.NONE);
        sys1.setAttentionAlert(true);
    }

    public static enum BlinkingStateEnum {
        NOT_BLINKING,
        BLINKING_NORMAL,
        BLINKING_BRILLIANT;

    }
}

