/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system;

import java.util.Comparator;
import pt.lsts.neptus.gui.system.SystemDisplay;

public class SystemDisplayComparator
implements Comparator<SystemDisplay> {
    private OrderOptionEnum orderOption = OrderOptionEnum.ID_AUTHORITY_MAIN;

    public SystemDisplayComparator() {
    }

    public SystemDisplayComparator(OrderOptionEnum orderOption) {
        this.setOrderOption(orderOption);
    }

    public OrderOptionEnum getOrderOption() {
        return this.orderOption;
    }

    public void setOrderOption(OrderOptionEnum orderOption) {
        this.orderOption = orderOption;
    }

    @Override
    public int compare(SystemDisplay o1, SystemDisplay o2) {
        if (o1.isMainVehicle() ^ o2.isMainVehicle() && this.orderOption == OrderOptionEnum.ID_AUTHORITY_MAIN) {
            return o1.isMainVehicle() ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
        if (o1.isWithAuthority() ^ o2.isWithAuthority() && this.orderOption != OrderOptionEnum.ID) {
            return o1.isWithAuthority() ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
        if (o1.getWithAuthority() != o2.getWithAuthority() && this.orderOption != OrderOptionEnum.ID) {
            return o2.getWithAuthority().ordinal() - o1.getWithAuthority().ordinal();
        }
        return o1.compareTo(o2);
    }

    public static enum OrderOptionEnum {
        ID,
        ID_AUTHORITY,
        ID_AUTHORITY_MAIN;

    }
}

