/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.gui.system.MilStd2525LikeSymbolsDefinitions;
import pt.lsts.neptus.gui.system.SystemIconsUtil;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;

public class SystemPainterHelper {
    public static final int AGE_TRANSPARENCY = 128;

    private SystemPainterHelper() {
    }

    public static final boolean isLocationKnown(ImcSystem sys) {
        return SystemPainterHelper.isLocationKnown(sys.getLocation(), sys.getLocationTimeMillis());
    }

    public static final boolean isLocationKnown(LocationType loc, long timeMillis) {
        return SystemPainterHelper.getLocationAge(loc, timeMillis) < 10000L && !loc.isLocationEqual(LocationType.ABSOLUTE_ZERO);
    }

    public static final long getLocationAge(LocationType loc, long timeMillis) {
        return System.currentTimeMillis() - timeMillis;
    }

    public static final void drawMilStd2525LikeSymbolForSystem(Graphics2D g, ImcSystem sys, boolean isLocationKnown, boolean isMainVehicle, boolean milStd2525FilledOrNot) {
        MilStd2525LikeSymbolsDefinitions.SymbolTypeEnum type = MilStd2525LikeSymbolsDefinitions.SymbolTypeEnum.AIR;
        type = sys.getType() == VehicleType.SystemTypeEnum.VEHICLE ? (sys.getTypeVehicle() == VehicleType.VehicleTypeEnum.UAV ? MilStd2525LikeSymbolsDefinitions.SymbolTypeEnum.AIR : (sys.getTypeVehicle() == VehicleType.VehicleTypeEnum.UUV ? MilStd2525LikeSymbolsDefinitions.SymbolTypeEnum.SUBSURFACE : (sys.getTypeVehicle() == VehicleType.VehicleTypeEnum.UGV ? MilStd2525LikeSymbolsDefinitions.SymbolTypeEnum.SURFACE : (sys.getTypeVehicle() == VehicleType.VehicleTypeEnum.USV ? MilStd2525LikeSymbolsDefinitions.SymbolTypeEnum.SURFACE : MilStd2525LikeSymbolsDefinitions.SymbolTypeEnum.SURFACE_UNIT)))) : (sys.getType() == VehicleType.SystemTypeEnum.CCU ? MilStd2525LikeSymbolsDefinitions.SymbolTypeEnum.SURFACE_UNIT : MilStd2525LikeSymbolsDefinitions.SymbolTypeEnum.SURFACE);
        MilStd2525LikeSymbolsDefinitions.SymbolShapeEnum shapeType = MilStd2525LikeSymbolsDefinitions.SymbolShapeEnum.FRIEND;
        if (!sys.isWithAuthority()) {
            shapeType = MilStd2525LikeSymbolsDefinitions.SymbolShapeEnum.NEUTRAL;
        }
        if (sys.getType() == VehicleType.SystemTypeEnum.UNKNOWN) {
            shapeType = MilStd2525LikeSymbolsDefinitions.SymbolShapeEnum.UNKNOWN;
        }
        MilStd2525LikeSymbolsDefinitions.SymbolOperationalConditionEnum operationalCondition = MilStd2525LikeSymbolsDefinitions.SymbolOperationalConditionEnum.NONE;
        if (sys.isOnErrorState()) {
            operationalCondition = MilStd2525LikeSymbolsDefinitions.SymbolOperationalConditionEnum.ERROR;
        }
        MilStd2525LikeSymbolsDefinitions.SymbolIconEnum drawIcon = MilStd2525LikeSymbolsDefinitions.SymbolIconEnum.UAS;
        if (sys.getType() == VehicleType.SystemTypeEnum.CCU) {
            drawIcon = MilStd2525LikeSymbolsDefinitions.SymbolIconEnum.CCU;
        } else if (sys.getType() == VehicleType.SystemTypeEnum.UNKNOWN) {
            drawIcon = MilStd2525LikeSymbolsDefinitions.SymbolIconEnum.UNKNOWN;
        } else if (sys.getType() == VehicleType.SystemTypeEnum.MOBILESENSOR || sys.getType() == VehicleType.SystemTypeEnum.STATICSENSOR) {
            drawIcon = MilStd2525LikeSymbolsDefinitions.SymbolIconEnum.SENSOR;
        }
        SystemPainterHelper.drawMilStd2525LikeSymbolForSystem(g, type, shapeType, operationalCondition, drawIcon, isLocationKnown, isMainVehicle, milStd2525FilledOrNot);
    }

    public static final void drawMilStd2525LikeSymbolForSystem(Graphics2D g, MilStd2525LikeSymbolsDefinitions.SymbolTypeEnum type, MilStd2525LikeSymbolsDefinitions.SymbolShapeEnum shapeType, MilStd2525LikeSymbolsDefinitions.SymbolOperationalConditionEnum operationalCondition, MilStd2525LikeSymbolsDefinitions.SymbolIconEnum drawIcon, boolean isLocationKnown, boolean isMainVehicle, boolean milStd2525FilledOrNot) {
        Graphics2D g2 = (Graphics2D)g.create();
        boolean drawMainIndicator = isMainVehicle;
        MilStd2525LikeSymbolsDefinitions.paintMilStd2525(g2, type, shapeType, operationalCondition, 30, true, milStd2525FilledOrNot, true, isLocationKnown ? 255 : 128, drawIcon, drawMainIndicator);
        g2.dispose();
    }

    public static final void drawSystemIcon(StateRenderer2D renderer, Graphics2D g, ImcSystem sys, Color color, double iconDiameter, boolean isLocationKnownUpToDate) {
        SystemPainterHelper.drawSystemIcon(renderer, g, sys.getYawDegrees(), color, iconDiameter, isLocationKnownUpToDate);
    }

    public static final void drawSystemIcon(StateRenderer2D renderer, Graphics2D g, double headingAngleDegrees, Color color, double iconDiameter, boolean isLocationKnownUpToDate) {
        int useTransparency;
        Graphics2D g2 = (Graphics2D)g.create();
        double yawRad = Math.toRadians(headingAngleDegrees);
        GeneralPath gp = SystemIconsUtil.getUAV();
        double scale = iconDiameter / gp.getBounds2D().getWidth();
        if (scale != 1.0) {
            g2.scale(scale, scale);
        }
        int n = useTransparency = isLocationKnownUpToDate ? 255 : 128;
        if (useTransparency != 255) {
            g2.setComposite(AlphaComposite.getInstance(3, (float)useTransparency / 255.0f));
        }
        g2.setColor(color);
        g2.rotate(yawRad - renderer.getRotation());
        g2.fill(gp);
        g2.setColor(Color.BLACK);
        g2.draw(gp);
        g2.dispose();
    }

    public static final void drawSystemNameLabel(Graphics2D g, String sysName, Color color, double safetyOffset, boolean isLocationKnownUpToDate) {
        int useTransparency;
        Graphics2D g2 = (Graphics2D)g.create();
        int n = useTransparency = isLocationKnownUpToDate ? 255 : 128;
        if (useTransparency != 255) {
            g2.setComposite(AlphaComposite.getInstance(3, (float)useTransparency / 255.0f));
        }
        g2.setColor(Color.BLACK);
        g2.drawString(sysName, (int)(12.0 * safetyOffset / 20.0) + 1, 1);
        g2.setColor(color);
        g2.drawString(sysName, (int)(12.0 * safetyOffset / 20.0), 0);
        g2.dispose();
    }

    public static final void drawCircleForSystem(Graphics2D g, Color color, double diameter, boolean isLocationKnownUpToDate) {
        SystemPainterHelper.drawCircleForSystem(g, color, diameter, CircleTypeBySystemType.DEFAULT, isLocationKnownUpToDate);
    }

    public static final void drawCircleForSystem(Graphics2D g, Color color, double diameter, CircleTypeBySystemType circleType, boolean isLocationKnownUpToDate) {
        RectangularShape shape1;
        RectangularShape shape;
        int useTransparency;
        Graphics2D g2 = (Graphics2D)g.create();
        int n = useTransparency = isLocationKnownUpToDate ? 255 : 128;
        if (useTransparency != 255) {
            g2.setComposite(AlphaComposite.getInstance(3, (float)useTransparency / 255.0f));
        }
        switch (circleType) {
            case AIR: {
                shape = new Arc2D.Double(-diameter * 0.1 / 2.0, -diameter * 0.2 * 2.0 / 2.0, diameter * 1.1, diameter * 1.2 * 2.0, 0.0, 180.0, 0);
                shape1 = new Arc2D.Double(-diameter * 0.1 / 2.0 - 1.0, -diameter * 0.2 * 2.0 / 2.0 - 1.0, diameter * 1.1 + 2.0, diameter * 1.2 * 2.0 + 2.0, 0.0, 180.0, 0);
                break;
            }
            case SUBSURFACE: {
                shape = new Arc2D.Double(-diameter * 0.1 / 2.0, -diameter * 1.2 * 2.0 / 2.0, diameter * 1.1, diameter * 1.2 * 2.0, 0.0, -180.0, 0);
                shape1 = new Arc2D.Double(-diameter * 0.1 / 2.0 - 1.0, -diameter * 1.2 * 2.0 / 2.0 - 1.0, diameter * 1.1 + 2.0, diameter * 1.2 * 2.0 + 2.0, 0.0, -180.0, 0);
                break;
            }
            default: {
                shape = new Ellipse2D.Double(-diameter * 0.2 / 2.0, -diameter * 0.2 / 2.0, diameter * 1.2, diameter * 1.2);
                shape1 = new Ellipse2D.Double(-diameter * 0.2 / 2.0 - 1.0, -diameter * 0.2 / 2.0 - 1.0, diameter * 1.2 + 2.0, diameter * 1.2 + 2.0);
                break;
            }
            case SURFACE_UNIT: {
                shape = new RoundRectangle2D.Double(-diameter * 0.5 / 2.0, 0.0, diameter * 1.5, diameter, 0.0, 0.0);
                shape1 = new RoundRectangle2D.Double(-diameter * 0.5 / 2.0 - 1.0, -1.0, diameter * 1.5 + 2.0, diameter + 2.0, 0.0, 0.0);
            }
        }
        g2.translate(-diameter / 2.0, -diameter / 2.0);
        g2.setColor(Color.BLACK);
        g2.draw(shape1);
        g2.setColor(color);
        g2.draw(shape);
        g2.dispose();
    }

    public static final void drawErrorStateForSystem(StateRenderer2D renderer, Graphics2D g, ImcSystem sys, double diameter, boolean isLocationKnownUpToDate) {
        if (sys.isOnErrorState()) {
            int useTransparency;
            Graphics2D g2 = (Graphics2D)g.create();
            int n = useTransparency = isLocationKnownUpToDate ? 255 : 128;
            if (useTransparency != 255) {
                g2.setComposite(AlphaComposite.getInstance(3, (float)useTransparency / 255.0f));
            }
            RoundRectangle2D.Double opShape = new RoundRectangle2D.Double(-diameter / 2.0, diameter / 2.0 + diameter / 10.0, diameter, diameter / 3.0, 0.0, 0.0);
            Color opColor = new Color(255, 128, 0);
            g2.setColor(opColor);
            g2.fill(opShape);
            g2.setColor(Color.BLACK);
            g2.draw(opShape);
            g2.dispose();
        }
    }

    public static final void drawCourseSpeedVectorForSystem(StateRenderer2D renderer, Graphics2D g, ImcSystem sys, double iconWidth, boolean isLocationKnownUpToDate, double minimumSpeedToBeStopped) {
        SystemPainterHelper.drawCourseSpeedVectorForSystem(renderer, g, sys, Color.WHITE, iconWidth, isLocationKnownUpToDate, minimumSpeedToBeStopped);
    }

    public static final void drawCourseSpeedVectorForSystem(StateRenderer2D renderer, Graphics2D g, ImcSystem sys, Color color, double iconWidth, boolean isLocationKnownUpToDate, double minimumSpeedToBeStopped) {
        Object obj;
        int useTransparency;
        Graphics2D g2 = (Graphics2D)g.create();
        Color colorToPaint = color == null ? g2.getColor() : color;
        int vectorOffset = (int)(iconWidth / 2.0);
        int n = useTransparency = isLocationKnownUpToDate ? 255 : 128;
        if (useTransparency != 255) {
            g2.setComposite(AlphaComposite.getInstance(3, (float)useTransparency / 255.0f));
        }
        if ((obj = sys.retrieveData("Course")) != null) {
            double gSpeed;
            double courseDegrees = ((Integer)obj).intValue();
            obj = sys.retrieveData("Ground Speed");
            if (obj != null && (gSpeed = ((Double)obj).doubleValue()) > minimumSpeedToBeStopped) {
                g2.rotate(Math.toRadians(courseDegrees) - renderer.getRotation());
                Stroke cs = g2.getStroke();
                double zs = gSpeed * (double)renderer.getZoom();
                if (zs < 50.0) {
                    g2.setStroke(new BasicStroke(2.0f, 0, 1, 0.0f, new float[]{5.0f, 5.0f}, 0.0f));
                    g2.setColor(Color.BLACK);
                    g2.drawLine(2, -vectorOffset, 0, -50);
                    g2.drawLine(-2, -vectorOffset, 0, -50);
                    g2.setColor(colorToPaint);
                    g2.drawLine(0, -vectorOffset, 0, -50);
                }
                g2.setStroke(new BasicStroke(2.0f, 0, 1));
                g2.setColor(Color.BLACK);
                g2.drawLine(2, -vectorOffset, 0, -((int)zs));
                g2.drawLine(-2, -vectorOffset, 0, -((int)zs));
                g2.setColor(colorToPaint);
                g2.drawLine(0, -vectorOffset, 0, -((int)zs));
                g2.setStroke(cs);
            }
        }
        g2.dispose();
    }

    public static enum CircleTypeBySystemType {
        AIR,
        SUBSURFACE,
        SURFACE,
        SURFACE_UNIT,
        DEFAULT;

    }
}

