/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.gui.system;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXPanel;
import pt.lsts.neptus.gui.system.SymbolLabel;
import pt.lsts.neptus.util.GuiUtils;

public class SystemTypeSymbol
extends SymbolLabel {
    private String systemType = "";
    private boolean showSymbolOrText = true;

    @Override
    protected void initialize() {
        this.active = true;
        this.setSize(10, 10);
        this.setPreferredSize(new Dimension(10, 10));
        super.initialize();
        this.blinkOnChange = false;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public boolean isShowSymbolOrText() {
        return this.showSymbolOrText;
    }

    public void setShowSymbolOrText(boolean showSymbolOrText) {
        this.showSymbolOrText = showSymbolOrText;
    }

    @Override
    public void paint(Graphics2D g, JXPanel c, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.scale((double)width / 10.0, (double)height / 10.0);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, 10.0, 10.0, 0.0, 0.0);
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fill(rect);
        if (this.isActive()) {
            if ("UUV".equalsIgnoreCase(this.systemType)) {
                if (this.showSymbolOrText) {
                    g2.translate(5, 5);
                    GeneralPath sp = new GeneralPath();
                    sp.moveTo(-3.0f, 0.0f);
                    sp.lineTo(-1.0f, -1.0f);
                    sp.lineTo(2.7, -1.0);
                    sp.lineTo(2.7, 1.0);
                    sp.lineTo(-1.0f, 1.0f);
                    sp.closePath();
                    g2.setColor(this.getActiveColor());
                    g2.fill(sp);
                    sp.moveTo(-4.0, -0.5);
                    sp.lineTo(-4.0, 0.5);
                    g2.draw(sp);
                    sp.reset();
                    sp.moveTo(-2.5, -1.0);
                    sp.lineTo(-2.5, 1.0);
                    g2.draw(sp);
                    Ellipse2D.Double el = new Ellipse2D.Double(-1.0, -1.0, 2.0, 2.0);
                    g2.translate(3, 0);
                    g2.draw(el);
                    g2.fill(el);
                } else {
                    this.drawText(g2, "UUV");
                }
            } else if ("UAV".equalsIgnoreCase(this.systemType)) {
                if (this.showSymbolOrText) {
                    GeneralPath sp = new GeneralPath();
                    g2.translate(5, 5);
                    g2.scale(0.5, 0.5);
                    int width1 = 20;
                    int height1 = width1 / 2;
                    sp.moveTo(width1 / 4, height1 / 3);
                    sp.lineTo(width1 / 4, height1 / 3);
                    sp.curveTo(width1 / 2 + 1, height1 / 3, width1 / 2 + 1, -height1 / 8, width1 / 4, -height1 / 8);
                    sp.lineTo(width1 / 4 - 2, -height1 / 8);
                    sp.lineTo(width1 / 4 - 6, -height1 / 8 - 6);
                    sp.lineTo(width1 / 4 - 8, -height1 / 8 - 6);
                    sp.lineTo(width1 / 4 - 8, -height1 / 8);
                    sp.lineTo(-width1 / 4 - 1, -height1 / 8);
                    sp.lineTo(-width1 * 5 / 12, -height1 / 2);
                    sp.lineTo(-width1 / 2, -height1 / 2);
                    sp.lineTo(-width1 / 2, 0.0f);
                    sp.lineTo(-width1 / 4, height1 / 3);
                    sp.closePath();
                    g2.setColor(this.getActiveColor());
                    g2.fill(sp);
                    g2.draw(sp);
                } else {
                    this.drawText(g2, "UAV");
                }
            } else if ("UGV".equalsIgnoreCase(this.systemType)) {
                if (this.showSymbolOrText) {
                    g2.translate(5, 5);
                    GeneralPath sp = new GeneralPath();
                    sp.moveTo(-3.8, -0.3);
                    sp.lineTo(3.8, -0.3);
                    sp.lineTo(3.8, 1.0);
                    sp.lineTo(-3.8, 1.0);
                    sp.closePath();
                    g2.setColor(this.getActiveColor());
                    g2.fill(sp);
                    g2.draw(sp);
                    sp.reset();
                    sp.moveTo(-2.0f, -3.0f);
                    sp.lineTo(1.0f, -3.0f);
                    sp.lineTo(2.1, 0.0);
                    sp.lineTo(-2.7, 0.0);
                    sp.closePath();
                    g2.draw(sp);
                    Ellipse2D.Double el = new Ellipse2D.Double(-0.5, -0.5, 1.0, 1.0);
                    g2.translate(2.5, 2.0);
                    g2.draw(el);
                    g2.fill(el);
                    g2.translate(-5, 0);
                    g2.draw(el);
                    g2.fill(el);
                } else {
                    this.drawText(g2, "UGV");
                }
            } else if ("USV".equalsIgnoreCase(this.systemType)) {
                if (this.showSymbolOrText) {
                    g2.translate(5, 5);
                    GeneralPath sp = new GeneralPath();
                    sp.moveTo(-3.0, -0.1);
                    sp.lineTo(3.2, -0.1);
                    sp.lineTo(2.0f, 1.0f);
                    sp.lineTo(-3.0f, 1.0f);
                    sp.closePath();
                    g2.setColor(this.getActiveColor());
                    g2.fill(sp);
                    sp.moveTo(-4.0, 0.5);
                    sp.lineTo(-4.0, 1.5);
                    g2.draw(sp);
                    sp.reset();
                    sp.moveTo(-2.7, -3.0);
                    sp.lineTo(-1.0f, -3.0f);
                    sp.lineTo(-1.0f, 0.0f);
                    sp.lineTo(-2.7, 0.0);
                    sp.closePath();
                    g2.draw(sp);
                } else {
                    this.drawText(g2, "USV");
                }
            } else if ("CCU".equalsIgnoreCase(this.systemType)) {
                if (this.showSymbolOrText) {
                    GeneralPath sp = new GeneralPath();
                    sp.moveTo(1.0f, 5.0f);
                    sp.lineTo(1.0f, 1.0f);
                    sp.lineTo(6.0f, 1.0f);
                    sp.lineTo(6.0f, 5.0f);
                    sp.lineTo(1.0f, 5.0f);
                    sp.lineTo(6.0f, 5.0f);
                    sp.lineTo(8.0f, 8.0f);
                    sp.lineTo(3.0f, 8.0f);
                    sp.closePath();
                    g2.setColor(this.getActiveColor());
                    g2.draw(sp);
                    Ellipse2D.Double el = new Ellipse2D.Double(-0.1, -0.1, 0.2, 0.2);
                    g2.translate(2.3, 5.7);
                    for (int i = 0; i < 6; ++i) {
                        for (int j = 0; j < 12; ++j) {
                            g2.fill(el);
                            g2.translate(0.3, 0.0);
                        }
                        g2.translate(-3.3999999999999995, 0.3);
                    }
                } else {
                    this.drawText(g2, "CCU");
                }
            } else if ("STATICSENSOR".equalsIgnoreCase(this.systemType)) {
                if (this.showSymbolOrText) {
                    this.drawText(g2, "SS");
                } else {
                    this.drawText(g2, "SS");
                }
            } else if ("MOBILESENSOR".equalsIgnoreCase(this.systemType)) {
                if (this.showSymbolOrText) {
                    this.drawText(g2, "MS");
                } else {
                    this.drawText(g2, "MS");
                }
            } else {
                this.drawText(g2, "?");
            }
        }
    }

    public static void main(String[] args) {
        SystemTypeSymbol symb1 = new SystemTypeSymbol();
        symb1.setActive(true);
        symb1.setSize(50, 50);
        JXPanel panel = new JXPanel();
        panel.setBackground(Color.BLACK);
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)((Object)symb1), (Object)"Center");
        GuiUtils.testFrame((JComponent)panel, "", 400, 400);
    }
}

